/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.command;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KRichGraphics;
import nethome.geom.util.ToolMath;
import nethome.ui.Canvas2D;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;
import nethome.ui.command.CommandUtil;

public class ComViewZoomArea
extends Command
implements ActionListener {
    private int mStartX;
    private int mStartY;
    private int mMouseX;
    private int mMouseY;
    float x1;
    float y1;
    float x2;
    float y2;
    private boolean mSet = false;

    public void play() {
        CommandUtil.setActiveUI(this.mComponent, true);
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        canvas2D.setCursor(Canvas2D.MOUSE_CROSS);
    }

    private void set() {
        this.play();
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        this.mSet = false;
        canvas2D.repaint();
    }

    public void end() {
        CommandUtil.setActiveUI(this.mComponent, false);
        this.y2 = 0.0f;
        this.x2 = 0.0f;
        this.y1 = 0.0f;
        this.x1 = 0.0f;
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        canvas2D.setCursor(Canvas2D.MOUSE_DEF);
    }

    public void mouseMove(int n, int n2, int n3) {
    }

    public void mousePress(int n, int n2, int n3) {
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        this.mSet = true;
        this.mStartX = this.mMouseX = n;
        this.mStartY = this.mMouseY = n2;
        this.x1 = this.x2 = canvas2D.mAbstCanvas.devToRealX(this.mStartX);
        this.y1 = this.y2 = canvas2D.mAbstCanvas.devToRealY(this.mStartY);
    }

    public void mouseDrag(int n, int n2, int n3) {
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        this.mMouseX = n;
        this.mMouseY = n2;
        this.x2 = canvas2D.mAbstCanvas.devToRealX(this.mMouseX);
        this.y2 = canvas2D.mAbstCanvas.devToRealY(this.mMouseY);
        canvas2D.repaint();
    }

    public void mouseRelease(int n, int n2, int n3) {
        this.gogo();
        this.mSet = false;
    }

    private void gogo() {
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        if (Math.abs(this.mMouseX - this.mStartX) > 10 && Math.abs(this.mMouseY - this.mStartY) > 10) {
            canvas2D.mAbstCanvas.setView(this.x1, this.y1, this.x2, this.y2);
            canvas2D.forceImageUpdate();
            canvas2D.repaint();
            canvas2D.updateViewControl();
            mainComponent.updateUserInterface();
        }
        if (!this.mContinue) {
            canvas2D.setMouseCommand(null);
        }
        canvas2D.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        canvas2D.setMouseCommand(this);
        this.set();
    }

    public void drawCommand(IRichGraphics iRichGraphics) {
        if (this.mSet) {
            iRichGraphics.setColor(Color.red);
            if (!ToolMath.isSame2D((double)this.x1, (double)this.y1, (double)this.x2, (double)this.y2)) {
                iRichGraphics.drawRect(this.x1, this.y1, this.x2, this.y2, KRichGraphics.LINE_1);
            }
        }
    }
}

