/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui.command;

import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import nethome.ui.Canvas2D;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;
import nethome.ui.command.CommandUtil;

public class ComViewMove
extends Command
implements ActionListener {
    private int mX;
    private int mY;
    private float mCx;
    private float mCy;
    protected boolean mPres = false;

    public void play() {
        CommandUtil.setActiveUI(this.mComponent, true);
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        canvas2D.setCursor(Canvas2D.MOUSE_MOVE);
    }

    public void end() {
        CommandUtil.setActiveUI(this.mComponent, false);
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        if (this.mPres) {
            this.mPres = false;
            canvas2D.setDrawMode((short)0);
            canvas2D.forceImageUpdate();
            canvas2D.repaint();
        }
        canvas2D.setCursor(Canvas2D.MOUSE_DEF);
    }

    public void mouseMove(int n, int n2, int n3) {
    }

    public void mousePress(int n, int n2, int n3) {
        this.mPres = true;
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        this.mX = n;
        this.mY = n2;
        this.mCx = canvas2D.mAbstCanvas.getViewPort().cx;
        this.mCy = canvas2D.mAbstCanvas.getViewPort().cy;
        canvas2D.setDrawMode((short)2);
        canvas2D.forceImageUpdate();
        canvas2D.repaint();
    }

    public void mouseDrag(int n, int n2, int n3) {
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        canvas2D.setCursor(Canvas2D.MOUSE_MOVE);
        float f = canvas2D.mAbstCanvas.devToRealX(n);
        float f2 = canvas2D.mAbstCanvas.devToRealY(n2);
        canvas2D.mAbstCanvas.setViewCenter(this.mCx - (f - canvas2D.mAbstCanvas.devToRealX(this.mX)), this.mCy - (f2 - canvas2D.mAbstCanvas.devToRealY(this.mY)));
        canvas2D.forceImageUpdate();
        Graphics graphics = canvas2D.getGraphics();
        canvas2D.paint(graphics);
        graphics.dispose();
        canvas2D.updateViewControl();
    }

    public void mouseRelease(int n, int n2, int n3) {
        if (!this.mPres) {
            return;
        }
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        canvas2D.setDrawMode((short)0);
        canvas2D.forceImageUpdate();
        this.mPres = false;
        if (!this.mContinue) {
            canvas2D.setMouseCommand(null);
        }
        canvas2D.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        MainComponent mainComponent = MainComponent.getInstance();
        Canvas2D canvas2D = mainComponent.getActiveCanvas();
        if (canvas2D == null) {
            return;
        }
        canvas2D.setMouseCommand(this);
        this.play();
    }
}

