/*
 * Decompiled with CFR 0.152.
 */
package nethome.ui;

import com.kt.gui.event.AccelKey;
import com.kt.io.AbstFile;
import com.kt.util.Vector2;
import com.kt.util.tree.ObjectFolder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.kitec.kwt.Area;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KKeyEvent;
import jp.kitec.kwt.KPopupMenu;
import jp.kitec.kwt.KRichGraphics;
import jp.kitec.kwt.KViewPort;
import nethome.NethomeLookAndFeel;
import nethome.doc.Document;
import nethome.doc.Project;
import nethome.geom.AreaControl;
import nethome.geom.WorkSheet;
import nethome.geom.primitive.Geometory;
import nethome.ui.CanvasBase;
import nethome.ui.ICanvas2D;
import nethome.ui.MainComponent;
import nethome.ui.command.Command;

public class Canvas2D
extends CanvasBase
implements ICanvas2D,
MouseListener,
MouseMotionListener {
    public static final short DRAW_FULL = 0;
    public static final short DRAW_SIMPLE = 1;
    public static final short DRAW_LINE = 2;
    public static final Cursor MOUSE_DEF = new Cursor(0);
    public static final Cursor MOUSE_WAIT = new Cursor(3);
    public static final Cursor MOUSE_MOVE = new Cursor(13);
    public static final Cursor MOUSE_HAND = new Cursor(12);
    public static final Cursor MOUSE_CROSS = new Cursor(1);
    protected boolean mDispGrid = true;
    protected Vector2 mAdditionalDrawGeoms = new Vector2();
    protected Object mSelectObject;
    protected KPopupMenu mPopup;
    protected Point mCurrentMouse;
    protected Point mPopUpPos;
    protected Vector mOptionalDrawElement;
    protected Vector mOptionalDrawElementDependCanvas;
    protected boolean mDispContext = false;
    protected short mDrawMode = 0;
    private long clicktime = 0L;

    public Canvas2D() {
        this.setLayout(null);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.mPopup = new KPopupMenu();
        this.mPopUpPos = new Point(0, 0);
        this.mCurrentMouse = new Point();
        this.mOptionalDrawElement = new Vector();
        this.mOptionalDrawElementDependCanvas = new Vector();
        this.add((PopupMenu)this.mPopup);
    }

    public void setDocument(Document document) {
        this.mDoc = document;
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.resetView();
    }

    public Document getDocument() {
        return this.mDoc;
    }

    public Project getProject() {
        return this.mDoc.getProject();
    }

    public void setSelectObject(Object object) {
        this.mSelectObject = object;
        this.repaint();
    }

    public Object getSelectObject() {
        return this.mSelectObject;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public void showContext(int n, int n2) {
        KPopupMenu kPopupMenu = this.getPopupMenu();
        this.mPopUpPos.setLocation(n, n2);
        if (kPopupMenu != null) {
            kPopupMenu.show((Component)this, n, n2);
        }
        this.mDispContext = true;
    }

    public KPopupMenu getPopupMenu() {
        return this.mPopup;
    }

    public Point getPopupPos() {
        return this.mPopUpPos;
    }

    public void endContext() {
        this.mDispContext = false;
        this.requestFocus();
    }

    public boolean isShowContext() {
        return this.mDispContext;
    }

    public Vector getOptionalDrawList() {
        return this.mOptionalDrawElement;
    }

    public Vector getOptionalDrawListCanvasDepend() {
        return this.mOptionalDrawElementDependCanvas;
    }

    public void addOptionalDrawObject(Object object) {
        if (this.mOptionalDrawElement.contains(object)) {
            return;
        }
        this.mOptionalDrawElement.addElement(object);
    }

    public void addOptionalDrawObjectCanvasDepend(Object object) {
        if (this.mOptionalDrawElementDependCanvas.contains(object)) {
            return;
        }
        this.mOptionalDrawElementDependCanvas.addElement(object);
    }

    public void removeOptionalDrawObject(Object object) {
        if (!this.mOptionalDrawElement.contains(object)) {
            return;
        }
        this.mOptionalDrawElement.removeElement(object);
    }

    public void removeOptionalDrawObjectCanvasDepend(Object object) {
        if (!this.mOptionalDrawElementDependCanvas.contains(object)) {
            return;
        }
        this.mOptionalDrawElementDependCanvas.removeElement(object);
    }

    public void addAdditionalDrawingGeometory(Geometory geometory) {
        if (this.mAdditionalDrawGeoms.contains((Object)geometory)) {
            return;
        }
        this.mAdditionalDrawGeoms.addElement((Object)geometory);
    }

    public void removeAdditionalDrawingGeometory(Geometory geometory) {
        if (!this.mAdditionalDrawGeoms.contains((Object)geometory)) {
            return;
        }
        this.mAdditionalDrawGeoms.removeElement((Object)geometory);
    }

    public void removeAllAdditionalDrawingGeometory() {
        this.mAdditionalDrawGeoms.removeAllElements();
    }

    public static KViewPort readData(AbstFile abstFile, Document document, float f) throws Exception {
        String string;
        KViewPort kViewPort = new KViewPort();
        StringTokenizer stringTokenizer = new StringTokenizer(abstFile.readLineFromBuffer(), " ,");
        kViewPort.x1 = Float.valueOf((String)stringTokenizer.nextElement()).floatValue();
        kViewPort.y1 = Float.valueOf((String)stringTokenizer.nextElement()).floatValue();
        kViewPort.x2 = Float.valueOf((String)stringTokenizer.nextElement()).floatValue();
        kViewPort.y2 = Float.valueOf((String)stringTokenizer.nextElement()).floatValue();
        while ((string = abstFile.readLineFromBuffer()) != null && string != null && !string.trim().equalsIgnoreCase("</VIEW>")) {
        }
        return kViewPort;
    }

    public void saveGeom(AbstFile abstFile, String string) throws Exception {
        KViewPort kViewPort = this.getViewPort();
        String string2 = string + " ";
        abstFile.writeStringToBuffer(string + "<VIEW>\r\n");
        abstFile.writeStringToBuffer(string2);
        abstFile.writeStringToBuffer(kViewPort.x1 + "f," + kViewPort.y1 + "f," + kViewPort.x2 + "f," + kViewPort.y2 + "f\r\n");
        abstFile.writeStringToBuffer(string + "</VIEW>\r\n");
    }

    public void save(ObjectFolder objectFolder) {
    }

    public void load(ObjectFolder objectFolder) {
    }

    public void updateView() {
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.forceImageUpdate();
        this.repaint();
    }

    public KViewPort getViewPort() {
        if (this.mDoc == null || this.mDoc.getProject() == null) {
            return this.mAbstCanvas.getViewPort();
        }
        Project project = this.mDoc.getProject();
        return project.getCurrentLayer().getViewPort();
    }

    public void setZoomAsScale(float f) {
        Project project = this.mDoc.getProject();
        KViewPort kViewPort = this.mAbstCanvas.getViewPort();
        if (kViewPort != null && this.mAbstCanvas.mDimension != null) {
            float f2 = project.getCurrentLayer().getWorkSheet().getModule();
            Area area = project.getCurrentLayer().getWorkSheet().getArea();
            float f3 = area.maxX + f2 - (area.minX - f2);
            float f4 = area.maxY + f2 - (area.minY - f2);
            float f5 = f2 / 10.0f;
            float f6 = f2 / 10.0f;
            if (f3 > f4) {
                f5 = f3 * 100.0f / f / 2.0f;
            } else {
                f6 = f4 * 100.0f / f / 2.0f;
            }
            this.mAbstCanvas.setView(kViewPort.cx - f5, kViewPort.cy - f6, kViewPort.cx + f5, kViewPort.cy + f6);
        }
    }

    public int getZoomRatio() {
        float f;
        float f2;
        float f3;
        KViewPort kViewPort = this.getViewPort();
        if (kViewPort == null) {
            return 0;
        }
        Project project = this.mDoc.getProject();
        if (this.mAbstCanvas.mDimension == null) {
            return 100;
        }
        Area area = project.getCurrentLayer().getWorkSheet().getArea();
        float f4 = project.getCurrentLayer().getWorkSheet().getModule();
        float f5 = area.maxX + f4 - (area.minX - f4);
        if (f5 > (f3 = area.maxY + f4 - (area.minY - f4))) {
            float f6 = this.mAbstCanvas.devToRealX(0);
            float f7 = this.mAbstCanvas.devToRealX(this.mAbstCanvas.mDimension.width);
            f2 = f7 - f6;
            f = f5;
        } else {
            float f8 = this.mAbstCanvas.devToRealY(this.mAbstCanvas.mDimension.height);
            float f9 = this.mAbstCanvas.devToRealY(0);
            f2 = f9 - f8;
            f = f3;
        }
        return (int)(f / f2 * 100.0f);
    }

    public WorkSheet getWorkSheet() {
        Project project = this.mDoc.getProject();
        if (project != null) {
            return project.getCurrentLayer().getWorkSheet();
        }
        return null;
    }

    public void resetView() {
        KViewPort kViewPort = this.getViewPort();
        if (kViewPort != null) {
            Project project = this.mDoc.getProject();
            float f = project.getCurrentLayer().getWorkSheet().getModule();
            Area area = project.getCurrentLayer().getWorkSheet().getArea();
            kViewPort.x1 = area.minX - f;
            kViewPort.y1 = area.minY - f;
            kViewPort.x2 = area.maxX + f;
            kViewPort.y2 = area.maxY + f;
            kViewPort.cx = (kViewPort.x1 + kViewPort.x2) / 2.0f;
            kViewPort.cy = (kViewPort.y1 + kViewPort.y2) / 2.0f;
            this.mAbstCanvas.setView(kViewPort.x1, kViewPort.y1, kViewPort.x2, kViewPort.y2, this.mAbstCanvas.mDimension);
            this.forceImageUpdate();
            this.repaint();
        }
    }

    public void setDispGrid(boolean bl) {
        this.mDispGrid = bl;
        this.forceImageUpdate();
        this.repaint();
    }

    public boolean isDispGrid() {
        return this.mDispGrid;
    }

    public void paint(Graphics graphics) {
        if (this.mDoc == null) {
            return;
        }
        this.update(graphics);
    }

    public void setDrawMode(short s) {
        this.mDrawMode = s;
    }

    public short getDrawMode() {
        return this.mDrawMode;
    }

    public void update(Graphics graphics) {
        if (this.mDoc == null) {
            return;
        }
        this.createOffGraphics();
        this.mAbstCanvas.updateViewScale(this.mAbstCanvas.mDimension);
        this.drawPlan();
        this.mAbstCanvas.setGC(this.mOffGraphics);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.drawCommand((IRichGraphics)this.mAbstCanvas);
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.drawCommand((IRichGraphics)this.mAbstCanvas);
        }
        super.paint(this.mOffGraphics);
        this.mAbstCanvas.setGC(null);
        graphics.drawImage(this.mOffImage, 0, 0, this);
    }

    protected void drawPlan() {
        if (this.isChengeCanvasSize()) {
            this.forceImageUpdate();
        }
        this.mAbstCanvas.setGC(this.mOffGraphics);
        this.forceCurrentRepaint(this.mAbstCanvas);
        this.drawSelectedObject(this.mAbstCanvas);
        this.mAbstCanvas.setGC(null);
    }

    protected void createOffGraphics() {
        this.mAbstCanvas.setSize(this.getSize().width, this.getSize().height);
        if (this.mOffImage == null || this.mOffImage.getWidth(this) != this.mAbstCanvas.mDimension.width || this.mOffImage.getHeight(this) != this.mAbstCanvas.mDimension.height) {
            if (this.mOffGraphics != null) {
                this.mOffGraphics.dispose();
            }
            if (this.mOffImage != null) {
                this.mOffImage.flush();
            }
            this.mOffImage = this.createImage(this.mAbstCanvas.mDimension.width, this.mAbstCanvas.mDimension.height);
            this.mOffGraphics = this.mOffImage.getGraphics();
        }
    }

    public void forceCurrentRepaint(KRichGraphics kRichGraphics) {
        kRichGraphics.drawBufferImage(this.mBufferImage);
        for (int i = 0; i < this.mAdditionalDrawGeoms.size(); ++i) {
            ((Geometory)this.mAdditionalDrawGeoms.elementAt(i)).drawGeom((IRichGraphics)kRichGraphics);
        }
    }

    protected void drawSelectedObject(KRichGraphics kRichGraphics) {
        Object object = this.getSelectObject();
        if (object != null && object instanceof Geometory) {
            AreaControl areaControl = ((Geometory)object).getAreaControl();
            if (areaControl != null) {
                areaControl.drawGeomHilight((IRichGraphics)kRichGraphics);
            } else {
                ((Geometory)object).drawHighLight((IRichGraphics)kRichGraphics, NethomeLookAndFeel.SELECT_CADELEM_COLOR, false);
            }
        }
    }

    protected void drawOptionalObject(KRichGraphics kRichGraphics) {
        for (int i = 0; i < this.mOptionalDrawElement.size(); ++i) {
            Object e = this.mOptionalDrawElement.elementAt(i);
            if (e instanceof Geometory) {
                ((Geometory)e).drawGeom((IRichGraphics)kRichGraphics);
                continue;
            }
            if (!(e instanceof Command)) continue;
            ((Command)e).drawCommand((IRichGraphics)kRichGraphics);
        }
    }

    protected void drawOptionalObjectCanvasDepend(KRichGraphics kRichGraphics) {
        for (int i = 0; i < this.mOptionalDrawElementDependCanvas.size(); ++i) {
            Object e = this.mOptionalDrawElementDependCanvas.elementAt(i);
            if (e instanceof Geometory) {
                ((Geometory)e).drawGeom((IRichGraphics)kRichGraphics);
                continue;
            }
            if (!(e instanceof Command)) continue;
            ((Command)e).drawCommand((IRichGraphics)kRichGraphics);
        }
    }

    protected void drawGrid(KRichGraphics kRichGraphics, boolean bl) {
    }

    public synchronized void forceImageUpdate() {
        if (this.mAbstCanvas.mDimension == null) {
            return;
        }
        this.mAbstCanvas.updateViewScale(this.mAbstCanvas.mDimension);
        if (this.mBufferImage != null && this.mBufferGraphics != null) {
            int n = this.mBufferImage.getWidth(this);
            int n2 = this.mBufferImage.getHeight(this);
            if (this.mAbstCanvas.mDimension.width != n || this.mAbstCanvas.mDimension.height != n2) {
                this.mBufferImage.flush();
                this.mBufferGraphics.dispose();
                this.mBufferGraphics = null;
                this.mBufferImage = null;
            }
        }
        if (this.mBufferImage == null) {
            this.mBufferImage = this.createImage(this.mAbstCanvas.mDimension.width, this.mAbstCanvas.mDimension.height);
            this.mBufferGraphics = this.mBufferImage.getGraphics();
        }
        this.mAbstCanvas.setGC(this.mBufferGraphics);
        this.mAbstCanvas.setColor(this.mBackColor);
        float f = this.mAbstCanvas.devToRealX(-1);
        float f2 = this.mAbstCanvas.devToRealY(-1);
        float f3 = this.mAbstCanvas.devToRealX(this.mAbstCanvas.mDimension.width + 2);
        float f4 = this.mAbstCanvas.devToRealY(this.mAbstCanvas.mDimension.height + 2);
        this.mAbstCanvas.drawFillRect(f, f2, f3, f4, null);
        this.drawGrid(this.mAbstCanvas, this.mDispGrid);
        this.mAbstCanvas.setGC(null);
    }

    protected void drawPreGridObject(IRichGraphics iRichGraphics) {
    }

    protected void drawPostGridObject(IRichGraphics iRichGraphics) {
    }

    public Point getCurrentMousePos() {
        return this.mCurrentMouse;
    }

    public void mouseWheelUp(MouseEvent mouseEvent) {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.wheelUp(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseWheelDown(MouseEvent mouseEvent) {
        if (this.mViewControlCommand != null) {
            this.mViewControlCommand.wheelDown(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void updateCurrentMousePos(MouseEvent mouseEvent) {
        this.mCurrentMouse.x = mouseEvent.getX();
        this.mCurrentMouse.y = mouseEvent.getY();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mActiveMaskCommand != null) {
            return;
        }
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.clicktime < 300L && this.mActiveCommand != null) {
            this.mActiveCommand.mouseDoubleClicked(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
        this.clicktime = l;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mousePress(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mousePress(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseRelease(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseRelease(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseDrag(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseDrag(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.mouseMove(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseMove(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiers());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.updateCurrentMousePos(mouseEvent);
    }

    public void keyPress(KeyEvent keyEvent) {
        MainComponent mainComponent = MainComponent.getInstance();
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiers();
        if (this.mActiveCommand != null && this.mActiveCommand.keyPress(n, n2)) {
            return;
        }
        if (this.mAllowCommand != null && (KKeyEvent.isMutchKey((int)n, (String)"UP") || KKeyEvent.isMutchKey((int)n, (String)"DOWN") || KKeyEvent.isMutchKey((int)n, (String)"LEFT") || KKeyEvent.isMutchKey((int)n, (String)"RIGHT") || KKeyEvent.isMutchKey((int)n, (String)"PAGE_UP") || KKeyEvent.isMutchKey((int)n, (String)"PAGE_DOWN") || KKeyEvent.isMutchKey((int)n, (String)"HOME")) && this.mAllowCommand.keyPress(n, n2)) {
            return;
        }
        AccelKey accelKey = mainComponent.getAccel(keyEvent);
        if (accelKey != null) {
            ((Command)accelKey.getObject()).accelerate();
            if (this.mActiveCommand != null) {
                this.mActiveCommand.restoration();
            }
            if (this.mActiveMaskCommand != null) {
                this.mActiveMaskCommand.end();
                this.mActiveMaskCommand = null;
            }
            return;
        }
        if (KKeyEvent.isMutchKey((int)keyEvent.getKeyCode(), (String)"ESCAPE")) {
            if (this.mActiveCommand != null) {
                this.mActiveCommand.restoration();
            }
            this.setMouseCommand(null);
            this.repaint();
            return;
        }
        Command command = mainComponent.getMaskCommand(keyEvent.getModifiers());
        if (command != this.mActiveMaskCommand) {
            if (this.mActiveMaskCommand != null) {
                this.mActiveMaskCommand.end();
            }
            this.mActiveMaskCommand = command;
            if (this.mActiveMaskCommand != null) {
                if (this.mActiveCommand != null) {
                    this.mActiveCommand.restoration();
                }
                this.mActiveMaskCommand.play();
            }
        }
    }

    public void keyRelease(KeyEvent keyEvent) {
        MainComponent mainComponent = MainComponent.getInstance();
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.end();
            this.mActiveMaskCommand = null;
        }
        this.mActiveMaskCommand = mainComponent.getMaskCommand(keyEvent.getModifiers());
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.play();
        } else if (this.mActiveCommand != null) {
            this.mActiveCommand.mouseMove(this.mCurrentMouse.x, this.mCurrentMouse.y, keyEvent.getModifiers());
        }
        this.repaint();
    }
}

