/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom.util;

import com.kt.util.Item;
import com.kt.util.RefList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import nethome.geom.primitive.GPoint2Df;
import nethome.geom.util.ToolMath;
import nethome.geom.util.ToolMathEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolPolygon {
    public static final int POLY_NO_RELATION = 0;
    public static final int POLY_A_INCLUDE_B = 1;
    public static final int POLY_B_INCLUDE_A = 2;
    private static RefList<GPoint2Df> triaList = new RefList();

    public static float getArea(RefList<? extends GPoint2Df> refList, GPoint2Df gPoint2Df) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = ((GPoint2Df)refList.lastElement()).x;
        float f5 = ((GPoint2Df)refList.lastElement()).y;
        float f6 = ((GPoint2Df)refList.elementAt((int)0)).x;
        float f7 = ((GPoint2Df)refList.elementAt((int)0)).y;
        for (int i = 1; i < refList.size(); ++i) {
            float f8 = ((GPoint2Df)refList.elementAt((int)i)).x;
            float f9 = ((GPoint2Df)refList.elementAt((int)i)).y;
            float f10 = ((f4 - f8) * (f7 - f5) + (f6 - f4) * (f9 - f5)) / 2.0f;
            f += f10 * (f8 + f6);
            f2 += f10 * (f9 + f7);
            f3 += f10;
            f6 = f8;
            f7 = f9;
        }
        if (gPoint2Df != null) {
            gPoint2Df.x = (f / f3 + f4) / 3.0f;
            gPoint2Df.y = (f2 / f3 + f5) / 3.0f;
        }
        if (f3 < 0.001f) {
            return 0.0f;
        }
        return f3;
    }

    public static boolean isInnerPolygon(RefList<? extends GPoint2Df> refList, float f, float f2) {
        double d = 0.0;
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            if (ToolMath.isOnLimitLinePoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y)) {
                return true;
            }
            double d2 = ToolMath.getAngle2D(f, f2, gPoint2Df2.x, gPoint2Df2.y) - ToolMath.getAngle2D(f, f2, gPoint2Df.x, gPoint2Df.y);
            if (d2 < -Math.PI) {
                d2 += Math.PI * 2;
            } else if (d2 > Math.PI) {
                d2 -= Math.PI * 2;
            }
            d += d2;
        }
        return Math.abs((d = Math.abs(d)) - Math.PI * 2) < 0.001;
    }

    public static <T extends GPoint2Df> boolean isOnLinePolygon(RefList<T> refList, float f, float f2, float f3, float f4) {
        GPoint2Df gPoint2Df;
        GPoint2Df gPoint2Df2;
        GPoint2Df gPoint2Df3;
        Item item = null;
        for (int i = 0; i < refList.size(); ++i) {
            gPoint2Df3 = (GPoint2Df)refList.elementAt(i - 1);
            if (ToolMathEx.isParallel2D(gPoint2Df3, gPoint2Df2 = (GPoint2Df)refList.elementAt(i), gPoint2Df2, gPoint2Df = (GPoint2Df)refList.elementAt(i + 1))) continue;
            item = refList.itemAt(i);
            break;
        }
        if (item == null) {
            return false;
        }
        Item item2 = item;
        do {
            gPoint2Df3 = (GPoint2Df)item.getObject();
            gPoint2Df2 = (GPoint2Df)item.nextItem.getObject();
            while ((item = item.nextItem) != item2 && ToolMathEx.isParallel2D(gPoint2Df3, gPoint2Df2, gPoint2Df2, gPoint2Df = (GPoint2Df)item.nextItem.getObject())) {
                gPoint2Df2 = gPoint2Df;
            }
            if (!ToolMath.isOnLimitLinePoint2D(f, f2, gPoint2Df3.x, gPoint2Df3.y, gPoint2Df2.x, gPoint2Df2.y) || !ToolMath.isOnLimitLinePoint2D(f3, f4, gPoint2Df3.x, gPoint2Df3.y, gPoint2Df2.x, gPoint2Df2.y)) continue;
            return true;
        } while (item != item2);
        return false;
    }

    public static boolean isCorrectRotation(RefList<GPoint2Df> refList) {
        Item item = refList.itemAt(0);
        float f = ((GPoint2Df)item.getObject()).x;
        Item item2 = refList.itemAt((int)0).nextItem;
        while (item2 != refList.itemAt(0)) {
            if (((GPoint2Df)item2.getObject()).x < f) {
                f = ((GPoint2Df)item2.getObject()).x;
                item = item2;
            }
            item2 = item2.nextItem;
        }
        Item item3 = item.prevItem;
        Item item4 = null;
        item2 = item.nextItem;
        GPoint2Df gPoint2Df = (GPoint2Df)item3.getObject();
        GPoint2Df gPoint2Df2 = (GPoint2Df)item.getObject();
        do {
            GPoint2Df gPoint2Df3 = (GPoint2Df)item2.getObject();
            if (ToolMath.isParallel2D(gPoint2Df2.x, gPoint2Df2.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y, gPoint2Df3.x, gPoint2Df3.y)) continue;
            item4 = item2;
            break;
        } while ((item2 = item2.nextItem) != item);
        if (item4 == null) {
            return false;
        }
        float f2 = (float)ToolMath.getAngle2D(((GPoint2Df)item3.getObject()).x, ((GPoint2Df)item3.getObject()).y, ((GPoint2Df)item.getObject()).x, ((GPoint2Df)item.getObject()).y);
        float[] fArray = new float[2];
        ToolMath.rotation2D(((GPoint2Df)item3.getObject()).x, ((GPoint2Df)item3.getObject()).y, -f2, ((GPoint2Df)item4.getObject()).x, ((GPoint2Df)item4.getObject()).y, fArray);
        return fArray[1] > ((GPoint2Df)item3.getObject()).y;
    }

    public static RefList<GPoint2Df> getHatchingLine(RefList<? extends GPoint2Df> refList, float f, float f2, float f3, float f4) {
        RefList refList2 = new RefList();
        float[] fArray = new float[2];
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            if (ToolPolygon.isInnerPolygon(refList, f, f2)) {
                refList2.addElement((Object)new GPoint2Df(f, f2));
            }
            if (ToolPolygon.isInnerPolygon(refList, f3, f4)) {
                refList2.addElement((Object)new GPoint2Df(f3, f4));
            }
            if (ToolMath.isParallel2D(f, f2, f3, f4, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y) || !ToolMath.isCrossSegment(f, f2, f3, f4, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y, fArray)) continue;
            refList2.addElement((Object)new GPoint2Df(fArray[0], fArray[1]));
        }
        ToolPolygon.removeOverlapNode(refList2);
        if (refList2.size() == 0) {
            return null;
        }
        return refList2;
    }

    public static <T extends GPoint2Df> void removeOverlapNode(RefList<T> refList) {
        Item item = refList.itemAt(0);
        for (int i = 0; i < refList.size() - 1; ++i) {
            Item item2 = item.nextItem;
            int n = refList.size();
            for (int j = i + 1; j < n; ++j) {
                Item item3 = item2.nextItem;
                if (ToolMath.isSame2D(((GPoint2Df)item.getObject()).x, ((GPoint2Df)item.getObject()).y, ((GPoint2Df)item2.getObject()).x, ((GPoint2Df)item2.getObject()).y)) {
                    refList.removeItemAt(item2);
                }
                item2 = item3;
            }
            item = item.nextItem;
        }
    }

    public static void removeOverlapNode2(RefList<? extends GPoint2Df> refList) {
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            if (!ToolMath.isSame2D(gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y)) continue;
            refList.removeElement((Object)gPoint2Df2);
            --i;
        }
    }

    public static <T extends GPoint2Df> void removeParaNodes(RefList<T> refList) {
        int n = refList.size();
        Item item = refList.itemAt(0);
        for (int i = 0; i < n; ++i) {
            Item item2 = item.nextItem;
            GPoint2Df gPoint2Df = (GPoint2Df)item.prevItem.getObject();
            GPoint2Df gPoint2Df2 = (GPoint2Df)item.getObject();
            GPoint2Df gPoint2Df3 = (GPoint2Df)item.nextItem.getObject();
            if (ToolMath.isOnLine(gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y, gPoint2Df2.x, gPoint2Df2.y, gPoint2Df3.x, gPoint2Df3.y)) {
                refList.removeItemAt(item);
            }
            item = item2;
        }
    }

    public static boolean isOnEdge(RefList<? extends GPoint2Df> refList, float f, float f2) {
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            if (!ToolMath.isOnLimitLinePoint2D(f, f2, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverlap(RefList<? extends GPoint2Df> refList, RefList<? extends GPoint2Df> refList2) {
        GPoint2Df gPoint2Df;
        int n;
        for (n = 0; n < refList.size(); ++n) {
            gPoint2Df = (GPoint2Df)refList.elementAt(n);
            if (!ToolPolygon.isInnerPolygon(refList2, gPoint2Df.x, gPoint2Df.y)) continue;
            return true;
        }
        for (n = 0; n < refList2.size(); ++n) {
            gPoint2Df = (GPoint2Df)refList2.elementAt(n);
            if (!ToolPolygon.isInnerPolygon(refList, gPoint2Df.x, gPoint2Df.y)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHasCross(RefList<? extends GPoint2Df> refList, RefList<? extends GPoint2Df> refList2) {
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            for (int j = 0; j < refList2.size(); ++j) {
                GPoint2Df gPoint2Df3;
                GPoint2Df gPoint2Df4 = (GPoint2Df)refList2.elementAt(j);
                if (ToolMathEx.isLimitLineCross2D(gPoint2Df, gPoint2Df2, gPoint2Df4, gPoint2Df3 = (GPoint2Df)refList2.elementAt(j + 1), null)) {
                    return true;
                }
                if (!ToolMathEx.isOnLimitLinePoint2D(gPoint2Df, gPoint2Df4, gPoint2Df3) && !ToolMathEx.isOnLimitLinePoint2D(gPoint2Df4, gPoint2Df, gPoint2Df2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCompleteCrossLine(GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2, GPoint2Df gPoint2Df3, GPoint2Df gPoint2Df4) {
        float[] fArray = new float[2];
        return ToolMath.isCrossSegment(gPoint2Df3.x, gPoint2Df3.y, gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y, fArray) && !ToolMath.isOnLine(gPoint2Df3.x, gPoint2Df3.y, gPoint2Df4.x, gPoint2Df4.y, gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y) && !ToolMath.isSame2D(fArray[0], fArray[1], gPoint2Df3.x, gPoint2Df3.y) && !ToolMath.isSame2D(fArray[0], fArray[1], gPoint2Df4.x, gPoint2Df4.y) && !ToolMath.isSame2D(fArray[0], fArray[1], gPoint2Df.x, gPoint2Df.y) && !ToolMath.isSame2D(fArray[0], fArray[1], gPoint2Df2.x, gPoint2Df2.y);
    }

    public static boolean checkInclude(RefList<GPoint2Df> refList, RefList<GPoint2Df> refList2) {
        RefList refList3 = refList.getCopy();
        RefList refList4 = refList2.getCopy();
        ToolPolygon.intersect((RefList<GPoint2Df>)refList3, (RefList<GPoint2Df>)refList4);
        for (int i = 0; i < refList3.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList3.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList3.elementAt(i + 1);
            float f = (gPoint2Df.x + gPoint2Df2.x) / 2.0f;
            float f2 = (gPoint2Df.y + gPoint2Df2.y) / 2.0f;
            if (ToolPolygon.isInnerPolygon((RefList<? extends GPoint2Df>)refList4, f, f2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isHasSelfCross(RefList<? extends GPoint2Df> refList) {
        float[] fArray = new float[2];
        for (int i = 0; i < refList.size() - 1; ++i) {
            for (int j = i + 1; j < refList.size(); ++j) {
                GPoint2Df gPoint2Df;
                GPoint2Df gPoint2Df2;
                GPoint2Df gPoint2Df3;
                GPoint2Df gPoint2Df4 = (GPoint2Df)refList.elementAt(i);
                if (!ToolMathEx.isLimitLineCross2D(gPoint2Df4, gPoint2Df3 = (GPoint2Df)refList.elementAt(i + 1), gPoint2Df2 = (GPoint2Df)refList.elementAt(j), gPoint2Df = (GPoint2Df)refList.elementAt(j + 1), fArray) || ToolMath.isSame2D(gPoint2Df4.x, gPoint2Df4.y, fArray[0], fArray[1]) || ToolMath.isSame2D(gPoint2Df3.x, gPoint2Df3.y, fArray[0], fArray[1])) continue;
                return true;
            }
        }
        return false;
    }

    static void intersect(RefList<GPoint2Df> refList, RefList<GPoint2Df> refList2) {
        Object object;
        GPoint2Df gPoint2Df;
        int n;
        Serializable serializable;
        int n2;
        block0: for (n2 = 0; n2 < refList.size(); ++n2) {
            serializable = (GPoint2Df)refList.elementAt(n2);
            for (n = 0; n < refList2.size(); ++n) {
                gPoint2Df = (GPoint2Df)refList2.elementAt(n);
                object = (GPoint2Df)refList2.elementAt(n + 1);
                if (!ToolMath.isOnLimitLinePoint2D(((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y, gPoint2Df.x, gPoint2Df.y, ((GPoint2Df)object).x, ((GPoint2Df)object).y) || ToolMath.isSame2D(((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y, gPoint2Df.x, gPoint2Df.y) || ToolMath.isSame2D(((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y, ((GPoint2Df)object).x, ((GPoint2Df)object).y)) continue;
                refList2.insertElementAt((Object)new GPoint2Df(((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y), n);
                continue block0;
            }
        }
        block2: for (n2 = 0; n2 < refList2.size(); ++n2) {
            serializable = (GPoint2Df)refList2.elementAt(n2);
            for (n = 0; n < refList.size(); ++n) {
                gPoint2Df = (GPoint2Df)refList2.elementAt(n);
                object = (GPoint2Df)refList2.elementAt(n + 1);
                if (!ToolMath.isOnLimitLinePoint2D(((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y, gPoint2Df.x, gPoint2Df.y, ((GPoint2Df)object).x, ((GPoint2Df)object).y) || ToolMath.isSame2D(((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y, gPoint2Df.x, gPoint2Df.y) || ToolMath.isSame2D(((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y, ((GPoint2Df)object).x, ((GPoint2Df)object).y)) continue;
                refList.insertElementAt((Object)new GPoint2Df(((GPoint2Df)serializable).x, ((GPoint2Df)serializable).y), n);
                continue block2;
            }
        }
        float[] fArray = new float[2];
        serializable = new ArrayList();
        Item item = refList.itemAt(0);
        do {
            GPoint2Df gPoint2Df2;
            gPoint2Df = refList2.itemAt(0);
            ((ArrayList)serializable).clear();
            do {
                object = (GPoint2Df)item.getObject();
                gPoint2Df2 = (GPoint2Df)item.nextItem.getObject();
                GPoint2Df gPoint2Df3 = (GPoint2Df)gPoint2Df.getObject();
                GPoint2Df gPoint2Df4 = (GPoint2Df)((Item)gPoint2Df).nextItem.getObject();
                if (ToolMath.isOnLine(((GPoint2Df)object).x, ((GPoint2Df)object).y, gPoint2Df2.x, gPoint2Df2.y, gPoint2Df3.x, gPoint2Df3.y, gPoint2Df4.x, gPoint2Df4.y) || !ToolMath.isCrossSegment(((GPoint2Df)object).x, ((GPoint2Df)object).y, gPoint2Df2.x, gPoint2Df2.y, gPoint2Df3.x, gPoint2Df3.y, gPoint2Df4.x, gPoint2Df4.y, fArray, 0.0f)) continue;
                if (!ToolMath.isSame2D(((GPoint2Df)object).x, ((GPoint2Df)object).y, fArray[0], fArray[1]) && !ToolMath.isSame2D(gPoint2Df2.x, gPoint2Df2.y, fArray[0], fArray[1])) {
                    ToolPolygon.addSorted((List<GPoint2Df>)((Object)serializable), (GPoint2Df)object, new GPoint2Df(fArray[0], fArray[1]));
                }
                if (ToolMath.isSame2D(gPoint2Df3.x, gPoint2Df3.y, fArray[0], fArray[1]) || ToolMath.isSame2D(gPoint2Df4.x, gPoint2Df4.y, fArray[0], fArray[1])) continue;
                refList2.insertElementAt((Object)new GPoint2Df(fArray[0], fArray[1]), (Item)gPoint2Df);
                gPoint2Df = ((Item)gPoint2Df).nextItem;
            } while ((gPoint2Df = ((Item)gPoint2Df).nextItem) != refList2.itemAt(0));
            object = ((ArrayList)serializable).iterator();
            while (object.hasNext()) {
                gPoint2Df2 = (GPoint2Df)object.next();
                refList.insertElementAt((Object)gPoint2Df2, item);
                item = item.nextItem;
            }
        } while ((item = item.nextItem) != refList.itemAt(0));
    }

    static void addSorted(List<GPoint2Df> list, GPoint2Df gPoint2Df, GPoint2Df gPoint2Df2) {
        int n;
        if (list.size() == 0) {
            list.add(gPoint2Df2);
            return;
        }
        double d = ToolMathEx.getLengthSquared2D(gPoint2Df, gPoint2Df2);
        for (n = list.size() - 1; n >= 0; --n) {
            GPoint2Df gPoint2Df3 = list.get(n);
            double d2 = ToolMathEx.getLengthSquared2D(gPoint2Df, gPoint2Df3);
            if (d == d2) {
                return;
            }
            if (d > d2) break;
        }
        list.add(n + 1, gPoint2Df2);
    }

    public boolean crossCheckArea(RefList<? extends GPoint2Df> refList, RefList<? extends GPoint2Df> refList2) {
        GPoint2Df gPoint2Df;
        int n;
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = -3.4028235E38f;
        float f5 = Float.MAX_VALUE;
        float f6 = Float.MAX_VALUE;
        float f7 = -3.4028235E38f;
        float f8 = -3.4028235E38f;
        for (n = 0; n < refList.size(); ++n) {
            gPoint2Df = (GPoint2Df)refList.elementAt(n);
            if (n == 0) {
                f = f3 = gPoint2Df.x;
                f2 = f4 = gPoint2Df.y;
                continue;
            }
            f = gPoint2Df.x < f ? gPoint2Df.x : f;
            f2 = gPoint2Df.y < f2 ? gPoint2Df.y : f2;
            f3 = gPoint2Df.x > f3 ? gPoint2Df.x : f3;
            f4 = gPoint2Df.y > f4 ? gPoint2Df.y : f4;
        }
        for (n = 0; n < refList2.size(); ++n) {
            gPoint2Df = (GPoint2Df)refList2.elementAt(n);
            if (n == 0) {
                f5 = f7 = gPoint2Df.x;
                f6 = f8 = gPoint2Df.y;
                continue;
            }
            f5 = gPoint2Df.x < f5 ? gPoint2Df.x : f5;
            f6 = gPoint2Df.y < f6 ? gPoint2Df.y : f6;
            f7 = gPoint2Df.x > f7 ? gPoint2Df.x : f7;
            f8 = gPoint2Df.y > f8 ? gPoint2Df.y : f8;
        }
        if (f5 > f3) {
            return false;
        }
        if (f6 > f4) {
            return false;
        }
        if (f > f7) {
            return false;
        }
        return !(f2 > f8);
    }

    public static boolean isHasCommonEdge(RefList<GPoint2Df> refList, RefList<GPoint2Df> refList2) {
        ToolPolygon.intersect(refList, refList2);
        ToolPolygon.intersect(refList2, refList);
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            for (int j = 0; j < refList2.size(); ++j) {
                GPoint2Df gPoint2Df3 = (GPoint2Df)refList2.elementAt(j);
                GPoint2Df gPoint2Df4 = (GPoint2Df)refList2.elementAt(j + 1);
                if (!ToolMath.isSameLine(gPoint2Df.x, gPoint2Df.y, gPoint2Df2.x, gPoint2Df2.y, gPoint2Df3.x, gPoint2Df3.y, gPoint2Df4.x, gPoint2Df4.y)) continue;
                return true;
            }
        }
        return false;
    }

    public static void removeOnLinePoint(RefList<? extends GPoint2Df> refList) {
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.elementAt(i + 1);
            GPoint2Df gPoint2Df3 = (GPoint2Df)refList.elementAt(i + 2);
            if (ToolMathEx.isSame2D(gPoint2Df, gPoint2Df2)) {
                refList.removeElement((Object)gPoint2Df2);
            } else if (ToolMathEx.isOnLimitLinePoint2D(gPoint2Df, gPoint2Df2, gPoint2Df3)) {
                refList.removeElement((Object)gPoint2Df2);
            } else {
                if (!ToolMathEx.isOnLimitLinePoint2D(gPoint2Df3, gPoint2Df, gPoint2Df2)) continue;
                refList.removeElement((Object)gPoint2Df2);
            }
            --i;
        }
    }

    public static float getMinX(RefList<? extends GPoint2Df> refList) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            f = gPoint2Df.x > f ? f : gPoint2Df.x;
        }
        return f;
    }

    public static float getMaxX(RefList<? extends GPoint2Df> refList) {
        float f = -3.4028235E38f;
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            f = gPoint2Df.x < f ? f : gPoint2Df.x;
        }
        return f;
    }

    public static float getMinY(RefList<? extends GPoint2Df> refList) {
        float f = Float.MAX_VALUE;
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            f = gPoint2Df.y > f ? f : gPoint2Df.y;
        }
        return f;
    }

    public static float getMaxY(RefList<? extends GPoint2Df> refList) {
        float f = -3.4028235E38f;
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            f = gPoint2Df.y < f ? f : gPoint2Df.y;
        }
        return f;
    }

    public static void getMinMax(RefList<? extends GPoint2Df> refList, float[] fArray, float[] fArray2) {
        fArray[0] = Float.POSITIVE_INFINITY;
        fArray[1] = Float.POSITIVE_INFINITY;
        fArray2[0] = Float.NEGATIVE_INFINITY;
        fArray2[1] = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < refList.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)refList.elementAt(i);
            fArray[0] = Math.min(gPoint2Df.x, fArray[0]);
            fArray[1] = Math.min(gPoint2Df.y, fArray[1]);
            fArray2[0] = Math.max(gPoint2Df.x, fArray2[0]);
            fArray2[1] = Math.max(gPoint2Df.y, fArray2[1]);
        }
    }

    public static int check2PolygonRelation(RefList<GPoint2Df> refList, RefList<GPoint2Df> refList2, boolean bl) {
        GPoint2Df gPoint2Df;
        int n;
        RefList refList3;
        RefList refList4;
        if (bl) {
            int n2;
            refList4 = new RefList();
            for (n2 = 0; n2 < refList.size(); ++n2) {
                refList4.addElement(refList.elementAt(n2));
            }
            refList3 = new RefList();
            for (n2 = 0; n2 < refList2.size(); ++n2) {
                refList3.addElement(refList2.elementAt(n2));
            }
        } else {
            refList4 = refList;
            refList3 = refList2;
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = -3.4028235E38f;
        float f4 = -3.4028235E38f;
        float f5 = Float.MAX_VALUE;
        float f6 = Float.MAX_VALUE;
        float f7 = -3.4028235E38f;
        float f8 = -3.4028235E38f;
        for (n = 0; n < refList4.size(); ++n) {
            gPoint2Df = (GPoint2Df)refList4.elementAt(n);
            f = f < gPoint2Df.x ? f : gPoint2Df.x;
            f2 = f2 < gPoint2Df.y ? f2 : gPoint2Df.y;
            f3 = f3 > gPoint2Df.x ? f3 : gPoint2Df.x;
            f4 = f4 > gPoint2Df.y ? f4 : gPoint2Df.y;
        }
        for (n = 0; n < refList3.size(); ++n) {
            gPoint2Df = (GPoint2Df)refList3.elementAt(n);
            f5 = f5 < gPoint2Df.x ? f5 : gPoint2Df.x;
            f6 = f6 < gPoint2Df.y ? f6 : gPoint2Df.y;
            f7 = f7 > gPoint2Df.x ? f7 : gPoint2Df.x;
            f8 = f8 > gPoint2Df.y ? f8 : gPoint2Df.y;
        }
        if (f3 < f5 || f7 < f || f4 < f6 || f8 < f2) {
            return 0;
        }
        if (ToolPolygon.checkInclude((RefList<GPoint2Df>)refList4, (RefList<GPoint2Df>)refList3)) {
            return 2;
        }
        if (ToolPolygon.checkInclude((RefList<GPoint2Df>)refList3, (RefList<GPoint2Df>)refList4)) {
            return 1;
        }
        return -1;
    }

    public static boolean isAddPolylineToPoint(RefList<? extends GPoint2Df> refList, float f, float f2) {
        GPoint2Df gPoint2Df;
        if (refList.size() > 0) {
            GPoint2Df gPoint2Df2 = (GPoint2Df)refList.lastElement();
            if (ToolMath.isSame2D(f, f2, gPoint2Df2.x, gPoint2Df2.y)) {
                return false;
            }
        }
        for (int i = 1; i < refList.size(); ++i) {
            gPoint2Df = (GPoint2Df)refList.elementAt(i);
            if (!ToolMath.isSame2D(f, f2, gPoint2Df.x, gPoint2Df.y)) continue;
            return false;
        }
        if (refList.size() < 3) {
            return true;
        }
        GPoint2Df gPoint2Df3 = (GPoint2Df)refList.elementAt(0);
        gPoint2Df = (GPoint2Df)refList.lastElement();
        float[] fArray = new float[2];
        for (int i = 0; i < refList.size() - 1; ++i) {
            GPoint2Df gPoint2Df4 = (GPoint2Df)refList.elementAt(i);
            GPoint2Df gPoint2Df5 = (GPoint2Df)refList.elementAt(i + 1);
            if (ToolMath.isSame2D(gPoint2Df.x, gPoint2Df.y, f, f2)) {
                return false;
            }
            if (!ToolMath.isCrossSegment(gPoint2Df4.x, gPoint2Df4.y, gPoint2Df5.x, gPoint2Df5.y, gPoint2Df.x, gPoint2Df.y, f, f2, fArray) || ToolMath.isSame2D(gPoint2Df.x, gPoint2Df.y, fArray[0], fArray[1]) || ToolMath.isSame2D(gPoint2Df3.x, gPoint2Df3.y, fArray[0], fArray[1])) continue;
            return false;
        }
        return true;
    }

    public static boolean getTriaRotation(float f, float f2, float f3, float f4, float f5, float f6) {
        ((GPoint2Df)triaList.elementAt(0)).setXY(f, f2);
        ((GPoint2Df)triaList.elementAt(1)).setXY(f3, f4);
        ((GPoint2Df)triaList.elementAt(2)).setXY(f5, f6);
        return ToolPolygon.isCorrectRotation(triaList);
    }

    static {
        triaList.addElement((Object)new GPoint2Df());
        triaList.addElement((Object)new GPoint2Df());
        triaList.addElement((Object)new GPoint2Df());
    }
}

