/*
 * Decompiled with CFR 0.152.
 */
package nethome.geom;

import com.kt.util.RefList;
import com.kt.util.Vector2;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import jp.kitec.kwt.Area;
import nethome.geom.primitive.GPoint2Df;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkSheet
implements Serializable {
    public static final int NEAR_GRID2_THRESHOLD_DIVIDE = 30;
    public static final int DEF_NEAR_GRID_DIVIDE = 50;
    private String mName;
    private float mModule;
    private Area mArea;
    private int mGridDiv = 1;
    private float mGridCenterX;
    private float mGridCenterY;
    private int mGridRoundingScale = 0;
    private RoundingMode mGridRoundingMode = RoundingMode.UNNECESSARY;
    private Vector2<Float> mExtraGridX;
    private Vector2<Float> mExtraGridY;
    private RefList<GPoint2Df> mAreaPolygon;

    public WorkSheet() {
        this.mArea = new Area();
        this.mAreaPolygon = new RefList();
    }

    public WorkSheet getCopy() {
        WorkSheet workSheet = new WorkSheet();
        workSheet.setName(this.getName());
        workSheet.setArea(this.mArea.minX, this.mArea.minY, this.mArea.maxX, this.mArea.maxY);
        workSheet.mGridDiv = this.mGridDiv;
        workSheet.mModule = this.mModule;
        workSheet.mGridCenterX = this.mGridCenterX;
        workSheet.mGridCenterY = this.mGridCenterY;
        return workSheet;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public void setArea(float f, float f2, float f3, float f4) {
        this.mArea.maximize();
        this.mArea.updateMinMax(f, f2);
        this.mArea.updateMinMax(f3, f4);
        this.mAreaPolygon.removeAllElements();
        this.mAreaPolygon.addElement((Object)new GPoint2Df(f, f2));
        this.mAreaPolygon.addElement((Object)new GPoint2Df(f3, f2));
        this.mAreaPolygon.addElement((Object)new GPoint2Df(f3, f4));
        this.mAreaPolygon.addElement((Object)new GPoint2Df(f, f4));
    }

    public Area getArea() {
        return this.mArea;
    }

    public void updateArea() {
        this.mArea.maximize();
        for (int i = 0; i < this.mAreaPolygon.size(); ++i) {
            GPoint2Df gPoint2Df = (GPoint2Df)this.mAreaPolygon.elementAt(i);
            this.mArea.updateMinMax(gPoint2Df.x, gPoint2Df.y);
        }
    }

    public RefList<GPoint2Df> getAreaPolygon() {
        return this.mAreaPolygon;
    }

    public float getModule() {
        return this.mModule;
    }

    public void setModule(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.mModule = f;
    }

    public void setGridDivide(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.mGridDiv = n;
    }

    public int getGridDivide() {
        return this.mGridDiv;
    }

    public float getCurrentGrid() {
        return this.mModule / (float)this.mGridDiv;
    }

    public void setGridCenter(float f, float f2) {
        this.mGridCenterX = f;
        this.mGridCenterY = f2;
    }

    public float getGridCenterX() {
        return this.mGridCenterX;
    }

    public float getGridCenterY() {
        return this.mGridCenterY;
    }

    public float getNearGridX(float f, boolean bl) {
        return this.getNearGrid(f, bl, this.getCurrentGrid(), this.getGridCenterX(), this.mExtraGridX);
    }

    public float getNearGridY(float f, boolean bl) {
        return this.getNearGrid(f, bl, this.getCurrentGrid(), this.getGridCenterY(), this.mExtraGridY);
    }

    private float getNearGrid(float f, boolean bl, float f2, float f3, Vector2<Float> vector2) {
        float f4;
        if (f2 == 0.0f) {
            if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
                f = this.roundGridValue(f);
            }
            return f;
        }
        float f5 = Float.MAX_VALUE;
        int n = f <= f3 ? -1 : 1;
        int n2 = (int)Math.floor((f - f3) / f2 * (float)n);
        while (f5 > (f4 = Math.abs(f - (f3 + f2 * (float)n2 * (float)n)))) {
            f5 = f4;
            ++n2;
        }
        f4 = (float)(n * (n2 - 1)) * f2 + f3;
        if (bl && vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                float f6 = ((Float)vector2.elementAt(i)).floatValue();
                float f7 = Math.abs(f - f6);
                if (!(f7 < f5)) continue;
                f4 = f6;
                f5 = f7;
            }
        }
        if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
            return this.roundGridValue(f4);
        }
        return f4;
    }

    public float getDefNearGridX(float f) {
        float f2 = Float.MAX_VALUE;
        float f3 = this.getModule() / 50.0f;
        int n = (int)((f - f % f3) / f3);
        int n2 = 0;
        for (int i = n - 1; i <= n + 1; ++i) {
            if (!(Math.abs(f3 * (float)i - f) < f2)) continue;
            f2 = Math.abs(f3 * (float)i - f);
            n2 = i;
        }
        if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
            return this.roundGridValue((float)n2 * f3);
        }
        return (float)n2 * f3;
    }

    public float getDefNearGridY(float f) {
        float f2 = Float.MAX_VALUE;
        float f3 = this.getModule() / 50.0f;
        int n = (int)((f - f % f3) / f3);
        int n2 = 0;
        for (int i = n - 1; i <= n + 1; ++i) {
            if (!(Math.abs(f3 * (float)i - f) < f2)) continue;
            f2 = Math.abs(f3 * (float)i - f);
            n2 = i;
        }
        if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
            return this.roundGridValue((float)n2 * f3);
        }
        return (float)n2 * f3;
    }

    public boolean isOnGridX(float f) {
        float f2 = this.getNearGridX(f, true);
        return Math.abs(f2 - f) < 0.001f;
    }

    public boolean isOnGridY(float f) {
        float f2 = this.getNearGridY(f, true);
        return Math.abs(f2 - f) < 0.001f;
    }

    public boolean isOnBaseGridX(float f) {
        float f2 = Math.abs(f % this.mModule);
        return f2 < 0.001f || Math.abs(f2 - this.mModule) < 0.001f;
    }

    public boolean isOnBaseGridY(float f) {
        float f2 = Math.abs(f % this.mModule);
        return f2 < 0.001f || Math.abs(f2 - this.mModule) < 0.001f;
    }

    public float getNearGridX2(float f, boolean bl) {
        float f2;
        float f3;
        if (this.getCurrentGrid() == 0.0f) {
            if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
                f = this.roundGridValue(f);
            }
            return f;
        }
        int n = (int)Math.floor((f - this.getGridCenterX()) / this.getCurrentGrid());
        float f4 = this.getGridCenterX() + (float)n * this.getCurrentGrid();
        if (f4 < f) {
            f3 = f4;
            f2 = this.getGridCenterX() + (float)(n + 1) * this.getCurrentGrid();
        } else {
            f3 = this.getGridCenterX() + (float)(n - 1) * this.getCurrentGrid();
            f2 = f4;
        }
        if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
            f3 = this.roundGridValue(f3);
            f2 = this.roundGridValue(f2);
        }
        if (Math.abs(f3 - f) < this.getCurrentGrid() / 30.0f) {
            return f3;
        }
        if (Math.abs(f2 - f) < this.getCurrentGrid() / 30.0f) {
            return f2;
        }
        if (this.mExtraGridX != null) {
            for (int i = 0; i < this.mExtraGridX.size(); ++i) {
                float f5 = ((Float)this.mExtraGridX.elementAt(i)).floatValue();
                if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
                    f5 = this.roundGridValue(f5);
                }
                if (Math.abs(f5 - f) < this.getCurrentGrid() / 30.0f) {
                    return f5;
                }
                if (f3 < f5 && f > f5) {
                    f3 = f5;
                }
                if (!(f < f5) || !(f2 > f5)) continue;
                f2 = f5;
            }
        }
        if (bl) {
            return f2;
        }
        return f3;
    }

    public float getNearGridY2(float f, boolean bl) {
        float f2;
        float f3;
        if (this.getCurrentGrid() == 0.0f) {
            if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
                f = this.roundGridValue(f);
            }
            return f;
        }
        int n = (int)Math.floor((f - this.getGridCenterY()) / this.getCurrentGrid());
        float f4 = this.getGridCenterY() + (float)n * this.getCurrentGrid();
        if (f4 < f) {
            f3 = f4;
            f2 = this.getGridCenterY() + (float)(n + 1) * this.getCurrentGrid();
        } else {
            f3 = this.getGridCenterY() + (float)(n - 1) * this.getCurrentGrid();
            f2 = f4;
        }
        if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
            f3 = this.roundGridValue(f3);
            f2 = this.roundGridValue(f2);
        }
        if (Math.abs(f3 - f) < this.getCurrentGrid() / 30.0f) {
            return f3;
        }
        if (Math.abs(f2 - f) < this.getCurrentGrid() / 30.0f) {
            return f2;
        }
        if (this.mExtraGridY != null) {
            for (int i = 0; i < this.mExtraGridY.size(); ++i) {
                float f5 = ((Float)this.mExtraGridY.elementAt(i)).floatValue();
                if (this.mGridRoundingMode != RoundingMode.UNNECESSARY) {
                    f5 = this.roundGridValue(f5);
                }
                if (Math.abs(f5 - f) < this.getCurrentGrid() / 30.0f) {
                    return f5;
                }
                if (f3 < f5 && f > f5) {
                    f3 = f5;
                }
                if (!(f < f5) || !(f2 > f5)) continue;
                f2 = f5;
            }
        }
        if (bl) {
            return f2;
        }
        return f3;
    }

    public int getNearNotExtraGrid(float f, float f2, float f3) {
        float f4;
        float f5 = Float.MAX_VALUE;
        int n = f <= f2 ? -1 : 1;
        int n2 = (int)Math.floor((f - f2) / f3 * (float)n);
        while (f5 > (f4 = Math.abs(f - (f2 + f3 * (float)n2 * (float)n)))) {
            f5 = f4;
            ++n2;
        }
        return n * (n2 - 1);
    }

    public Vector2<Float> getExtraGridX() {
        return this.mExtraGridX;
    }

    public Vector2<Float> getExtraGridY() {
        return this.mExtraGridY;
    }

    public boolean addExtraGridX(float f) {
        if (Math.abs(this.getNearGridX(f, true) - f) < 0.001f) {
            return false;
        }
        if (this.mExtraGridX == null) {
            this.mExtraGridX = new Vector2();
        }
        for (int i = 0; i < this.mExtraGridX.size(); ++i) {
            Float f2 = (Float)this.mExtraGridX.elementAt(i);
            if (f2.floatValue() != f) continue;
            return false;
        }
        this.mExtraGridX.addElement((Object)new Float(f));
        return true;
    }

    public boolean addExtraGridY(float f) {
        if (Math.abs(this.getNearGridY(f, true) - f) < 0.001f) {
            return false;
        }
        if (this.mExtraGridY == null) {
            this.mExtraGridY = new Vector2();
        }
        for (int i = 0; i < this.mExtraGridY.size(); ++i) {
            Float f2 = (Float)this.mExtraGridY.elementAt(i);
            if (!(Math.abs(f2.floatValue() - f) < 0.001f)) continue;
            return false;
        }
        this.mExtraGridY.addElement((Object)new Float(f));
        return true;
    }

    private float roundGridValue(float f) {
        if (Double.isInfinite(f) || Double.isNaN(f)) {
            return f;
        }
        BigDecimal bigDecimal = new BigDecimal(Float.toString(f));
        BigDecimal bigDecimal2 = bigDecimal.setScale(this.mGridRoundingScale, this.mGridRoundingMode);
        float f2 = bigDecimal2.floatValue();
        return f2;
    }

    public void setGridRoundingScale(int n) {
        this.mGridRoundingScale = n;
    }

    public void setGridRoundingMode(RoundingMode roundingMode) {
        this.mGridRoundingMode = roundingMode;
    }

    public void setGridRound(int n, RoundingMode roundingMode) {
        this.setGridRoundingScale(n);
        this.setGridRoundingMode(roundingMode);
    }
}

