/*
 * Decompiled with CFR 0.152.
 */
package nethome.doc;

import com.kt.util.History;
import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import java.util.Hashtable;
import java.util.Vector;
import nethome.doc.DocumentFactory;
import nethome.doc.Layer;
import nethome.doc.LayerManager;
import nethome.geom.ILinkLine;
import nethome.geom.primitive.Geometory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Project {
    private History mHistory;
    protected LayerManager mActiveLayerManager;
    protected Vector<LayerManager> mLayerManagers = new Vector();
    protected boolean mSaved;
    protected Hashtable<Object, Object> mProjectInfo = new Hashtable();

    public Project() {
        this.mHistory = new History(6);
        this.setSaved(true);
    }

    public ObjectFolder save() {
        ObjectFolder objectFolder = new ObjectFolder("DATA");
        this.saveProjectInfomation(objectFolder);
        for (int i = 0; i < this.getLayerManagers().size(); ++i) {
            LayerManager layerManager = this.getLayerManagers().elementAt(i);
            layerManager.save(objectFolder);
        }
        return objectFolder;
    }

    public void load(ObjectFolder objectFolder, DocumentFactory documentFactory) {
        ObjectNode objectNode = objectFolder.getNode("DATA");
        if (objectNode != null && objectNode instanceof ObjectFolder) {
            ObjectFolder objectFolder2 = (ObjectFolder)objectNode;
            this.loadProjectInfomation(objectFolder2);
            Vector vector = objectFolder2.getNamedElement("LAYER");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    objectFolder2 = (ObjectFolder)vector.elementAt(i);
                    LayerManager layerManager = this.loadLayer(objectFolder2, documentFactory);
                    this.addLayerManager(layerManager);
                }
            }
        }
    }

    public LayerManager loadLayer(ObjectFolder objectFolder, DocumentFactory documentFactory) {
        return this.loadLayer(objectFolder, documentFactory, true);
    }

    public LayerManager loadLayer(ObjectFolder objectFolder, DocumentFactory documentFactory, boolean bl) {
        String string = (String)objectFolder.getNode("NAME").getObject();
        LayerManager layerManager = this.createLoadLayer(documentFactory, string);
        Layer layer = layerManager.getLayer();
        for (int i = 0; i < objectFolder.getChildlen().size(); ++i) {
            Object e = objectFolder.getChildlen().elementAt(i);
            if (!(e instanceof ObjectFolder)) continue;
            ObjectFolder objectFolder2 = (ObjectFolder)e;
            Geometory geometory = documentFactory.getGeomPerser().getGeomeroty(objectFolder2);
            this.addGeomToLayer(layer, geometory);
        }
        if (bl) {
            this.recoverAfterLoad(layer);
        }
        return layerManager;
    }

    protected LayerManager createLoadLayer(DocumentFactory documentFactory, String string) {
        LayerManager layerManager = documentFactory.createLayerManager(this, string);
        return layerManager;
    }

    protected void saveProjectInfomation(ObjectFolder objectFolder) {
    }

    protected void loadProjectInfomation(ObjectFolder objectFolder) {
    }

    protected void addGeomToLayer(Layer layer, Geometory geometory) {
        if (geometory != null) {
            layer.addPrimitive(geometory);
        }
    }

    protected void recoverAfterLoad(Layer layer) {
        for (int i = 0; i < layer.getPrims().size(); ++i) {
            Object object = layer.getPrims().elementAt(i);
            if (!(object instanceof ILinkLine)) continue;
            ((ILinkLine)object).recoverLink(layer.getPrims());
        }
    }

    public Hashtable<Object, Object> getProjectInfo() {
        return this.mProjectInfo;
    }

    public Object getProjectInfo(Object object) {
        if (this.mProjectInfo == null) {
            return null;
        }
        return this.mProjectInfo.get(object);
    }

    public void addLayerManager(LayerManager layerManager) {
        this.mLayerManagers.addElement(layerManager);
    }

    public void setCurrentLayer(int n) {
        if (n >= 0 && n <= this.mLayerManagers.size() - 1) {
            this.mActiveLayerManager = this.mLayerManagers.elementAt(n);
        }
    }

    public void setCurrentLayer(String string) {
        for (int i = 0; i < this.mLayerManagers.size(); ++i) {
            LayerManager layerManager = this.mLayerManagers.elementAt(i);
            String string2 = layerManager.getName();
            if (string2 == null || !string2.equalsIgnoreCase(string)) continue;
            this.mActiveLayerManager = layerManager;
            return;
        }
    }

    public Vector<LayerManager> getLayerManagers() {
        return this.mLayerManagers;
    }

    public void setSaved(boolean bl) {
        this.mSaved = bl;
    }

    public boolean isSaved() {
        return this.mSaved;
    }

    public Layer getCurrentLayer() {
        if (this.mActiveLayerManager != null) {
            return this.mActiveLayerManager.getLayer();
        }
        return null;
    }

    public void documentReflesh() {
        this.mActiveLayerManager = null;
        for (int i = 0; i < this.mLayerManagers.size(); ++i) {
            LayerManager layerManager = this.mLayerManagers.elementAt(i);
            layerManager.getLayer().deleteAll();
            layerManager.getLayer().clearSelectBuffer();
        }
        this.mLayerManagers.removeAllElements();
        this.mHistory.flushHistory();
    }

    public LayerManager getCurrentLayerManager() {
        return this.mActiveLayerManager;
    }

    public void flushHistory() {
        this.mHistory.flushHistory();
    }

    public void setHistoryObject(Object object) {
        this.mActiveLayerManager.setHistoryObject(object);
    }

    public Object getLastHistory() {
        return this.mHistory.getLastHistory();
    }

    public Object getCurrentHistory() {
        return this.mHistory.getCurrentHistory();
    }

    public boolean undo() {
        boolean bl = false;
        Object object = this.mHistory.undo();
        if (object == null) {
            bl = false;
        } else {
            Object[] objectArray = (Object[])object;
            this.mLayerManagers = (Vector)objectArray[0];
            this.mActiveLayerManager = (LayerManager)objectArray[1];
            bl = true;
        }
        if (bl) {
            this.setSaved(false);
        }
        return bl;
    }

    public boolean redo() {
        boolean bl = false;
        Object object = this.mHistory.redo();
        if (object == null) {
            bl = false;
        } else {
            Object[] objectArray = (Object[])object;
            this.mLayerManagers = (Vector)objectArray[0];
            this.mActiveLayerManager = (LayerManager)objectArray[1];
            bl = true;
        }
        if (bl) {
            this.setSaved(false);
        }
        return bl;
    }

    public void addHistory() {
        for (int i = 0; i < this.getLayerManagers().size(); ++i) {
            LayerManager layerManager = this.getLayerManagers().elementAt(i);
            layerManager.getLayer().renumberID();
        }
        Object[] objectArray = new Object[]{this.getLayerManagers(), this.mActiveLayerManager};
        this.mHistory.addHistory((Object)objectArray);
        this.setSaved(false);
    }

    public boolean isHasUndo() {
        return this.mHistory.isHasUndo();
    }

    public boolean isHasRedo() {
        return this.mHistory.isHasRedo();
    }

    public void setMaxHistory(int n) {
        this.mHistory.setMaxHistory(n);
    }
}

