/*
 * Decompiled with CFR 0.152.
 */
package model.primitive;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import model.entity.ModelCtrlInfo;
import model.primitive.LsObject;
import model.primitive.LsSurface;
import model.primitive.Primitive3D;
import model.shape.primitive.SMatrix4d;
import model.shape.primitive.SVector3d;
import model.util.PrimitiveGenerator;
import option.gad.core.util.ObjectUtil;

public class LsShape
extends Primitive3D
implements LsObject {
    private List<LsSurface> surfaces;
    private List<SVector3d> vertices;
    public Color fillColor = Color.WHITE;
    public Color edgeColor = Color.BLACK;
    public boolean drawBothSide = false;
    public boolean projection2dVisible = true;
    public boolean section2dVisible = true;
    public SMatrix4d tempMatrix = null;

    protected LsShape() {
        this(false);
    }

    protected LsShape(boolean bl) {
        this.surfaces = new ArrayList<LsSurface>();
        this.vertices = new ArrayList<SVector3d>();
        this.drawBothSide = bl;
    }

    public List<LsSurface> getSurfaces() {
        return this.surfaces;
    }

    public List<SVector3d> getVertices() {
        return this.vertices;
    }

    @Override
    public void build() {
        for (LsSurface lsSurface : this.surfaces) {
            lsSurface.build();
        }
        this.vertices.clear();
        for (LsSurface lsSurface : this.surfaces) {
            List<SVector3d> list = lsSurface.getVertices();
            for (SVector3d sVector3d : list) {
                if (this.vertices.contains(sVector3d)) continue;
                this.vertices.add(sVector3d);
            }
        }
    }

    @Override
    public void clearLink() {
        if (this.surfaces != null) {
            for (LsSurface lsSurface : this.surfaces) {
                lsSurface.clearLink();
            }
            this.surfaces = null;
        }
        if (this.vertices != null) {
            this.vertices.clear();
            this.vertices = null;
        }
    }

    @Override
    public void translate3D(PrimitiveGenerator primitiveGenerator, SMatrix4d sMatrix4d) {
        this.tempMatrix = sMatrix4d;
        primitiveGenerator.addShape(this);
        this.tempMatrix = null;
    }

    @Override
    public void to2DPrim(Vector<LsShape> vector, SMatrix4d sMatrix4d, ModelCtrlInfo modelCtrlInfo) {
        if (sMatrix4d != null) {
            SVector3d sVector3d = new SVector3d();
            LsShape lsShape = (LsShape)ObjectUtil.deepCopy((Serializable)this);
            for (SVector3d sVector3d2 : lsShape.getVertices()) {
                sMatrix4d.translate(sVector3d, sVector3d2.x, sVector3d2.y, sVector3d2.z);
                sVector3d2.set(sVector3d);
            }
            vector.add(lsShape);
        } else {
            vector.add(this);
        }
    }
}

