/*
 * Decompiled with CFR 0.152.
 */
package geom;

import com.kt.util.tree.ObjectFolder;
import com.kt.util.tree.ObjectNode;
import geom.AbstractTerraceGeometory;
import geom.LineType;
import java.awt.Color;
import java.util.Vector;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KLineType;
import kinoki3exchange.KxModuleUtil;
import nethome.geom.LocalAxis2Df;
import proto.graphics2d.GeomNodeName;

public class TerraceGeometory
extends AbstractTerraceGeometory {
    @Deprecated
    public static final int HATCH_NONE = 0;
    @Deprecated
    public static final int HATCH_LINE_1 = 1;
    @Deprecated
    public static final int HATCH_LINE_2 = 2;
    @Deprecated
    public static final int HATCH_DOT = 3;
    protected int hatchmode = 0;
    protected int hatchPitch = -1;
    protected Color lineColor = Color.BLACK;
    protected KLineType lineType = null;
    protected boolean drawLine = true;
    protected boolean fillArea = true;
    protected boolean closePath = true;
    protected Vector<TerraceGeometory> hatchObjects;

    @Override
    public void drawGeom(IRichGraphics iRichGraphics) {
        this.drawAbstDevice(iRichGraphics, null, null, null);
    }

    public void updateHatch() {
    }

    public void drawHatch(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        if (this.hatchmode == 0) {
            return;
        }
        if (this.hatchObjects == null) {
            this.updateHatch();
        }
        if (this.hatchObjects == null) {
            return;
        }
        int n = 0;
        while (n < this.hatchObjects.size()) {
            TerraceGeometory terraceGeometory = this.hatchObjects.get(n);
            terraceGeometory.drawAbstDevice(iRichGraphics, color, color2, localAxis2Df);
            ++n;
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setLineType(KLineType kLineType) {
        this.lineType = kLineType;
    }

    public int getHatchmode() {
        return this.hatchmode;
    }

    public void setHatchmode(int n) {
        this.hatchmode = n;
    }

    public int getHatchPitch() {
        return this.hatchPitch;
    }

    public void setHatchPitch(int n) {
        this.hatchPitch = n;
    }

    public boolean isDrawLine() {
        return this.drawLine;
    }

    public boolean isFillArea() {
        return this.fillArea;
    }

    public boolean isClosePath() {
        return this.closePath;
    }

    public void setDrawLine(boolean bl) {
        this.drawLine = bl;
    }

    public void setFillArea(boolean bl) {
        this.fillArea = bl;
    }

    public void setClosePath(boolean bl) {
        this.closePath = bl;
    }

    public boolean isInner(double d, double d2) {
        return false;
    }

    public void drawAbstDevice(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
    }

    @Override
    public void save(ObjectFolder objectFolder) {
        super.saveCommon(objectFolder);
        if (this.lineColor != null) {
            KxModuleUtil.addInt(objectFolder, GeomNodeName.edgeColor, this.lineColor.getRGB());
        }
        KxModuleUtil.addInt(objectFolder, GeomNodeName.hatch, this.hatchmode);
        KxModuleUtil.addInt(objectFolder, GeomNodeName.hatchPitch, this.hatchPitch);
        if (this.lineType != null) {
            ObjectFolder objectFolder2 = KxModuleUtil.createNode(GeomNodeName.lineType);
            objectFolder.addChild((ObjectNode)objectFolder2, true);
            LineType lineType = this.translateLineType(this.lineType);
            KxModuleUtil.addString(objectFolder2, GeomNodeName.type, lineType.name());
            if (lineType.equals((Object)LineType.CUSTOM)) {
                ObjectFolder objectFolder3 = KxModuleUtil.createNode();
                this.lineType.save(objectFolder3);
                objectFolder2.addChild((ObjectNode)objectFolder3, true);
            }
        }
        KxModuleUtil.addBool(objectFolder, GeomNodeName.drawEdge, this.drawLine);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.fillArea, this.fillArea);
        KxModuleUtil.addBool(objectFolder, GeomNodeName.closePath, this.closePath);
    }

    @Override
    public void load(ObjectFolder objectFolder) {
        ObjectNode objectNode = KxModuleUtil.getNode(objectFolder, GeomNodeName.edgeColor);
        if (objectNode != null) {
            int n = KxModuleUtil.getInt(objectFolder, GeomNodeName.edgeColor);
            this.lineColor = new Color(n);
        }
        this.hatchmode = KxModuleUtil.getInt(objectFolder, GeomNodeName.hatch);
        objectNode = KxModuleUtil.getNode(objectFolder, GeomNodeName.hatchPitch);
        if (objectNode != null) {
            this.hatchPitch = KxModuleUtil.getInt(objectFolder, GeomNodeName.hatchPitch);
        }
        if ((objectNode = KxModuleUtil.getNode(objectFolder, GeomNodeName.lineType)) != null && objectNode instanceof ObjectFolder) {
            ObjectFolder objectFolder2 = (ObjectFolder)objectNode;
            String string = KxModuleUtil.getString(objectFolder2, GeomNodeName.type);
            LineType lineType = LineType.valueOf(string);
            if (lineType.equals((Object)LineType.CUSTOM)) {
                ObjectFolder objectFolder3 = (ObjectFolder)objectFolder2.getNode("LINETYPE");
                if (objectFolder3 != null) {
                    this.lineType = new KLineType();
                    KLineType.readData((ObjectFolder)objectFolder3, (KLineType)this.lineType);
                } else {
                    this.lineType = IRichGraphics.LINE_1;
                }
            } else {
                this.lineType = lineType.getLineType();
            }
        }
        this.drawLine = KxModuleUtil.getBool(objectFolder, GeomNodeName.drawEdge, this.drawLine);
        this.fillArea = KxModuleUtil.getBool(objectFolder, GeomNodeName.fillArea, this.fillArea);
        this.closePath = KxModuleUtil.getBool(objectFolder, GeomNodeName.closePath, this.closePath);
    }

    private LineType translateLineType(KLineType kLineType) {
        if (kLineType == null) {
            return LineType.LINE_1;
        }
        if (kLineType.equals(IRichGraphics.LINE_1)) {
            return LineType.LINE_1;
        }
        if (kLineType.equals(IRichGraphics.LINE_2)) {
            return LineType.LINE_2;
        }
        if (kLineType.equals(IRichGraphics.LINE_3)) {
            return LineType.LINE_3;
        }
        if (kLineType.equals(IRichGraphics.LINE_DASH_1)) {
            return LineType.LINE_DASH_1;
        }
        return LineType.CUSTOM;
    }
}

