/*
 * Decompiled with CFR 0.152.
 */
package geom;

import com.kt.util.tree.ObjectFolder;
import geom.GSunpo;
import geom.GeomType;
import java.awt.Color;
import jp.kitec.kwt.IRichGraphics;
import jp.kitec.kwt.KFont;
import nethome.NethomeResource;
import nethome.geom.LocalAxis2Df;

public class GSunpoSelectable
extends GSunpo {
    private int id;
    protected float minx;
    protected float maxx;
    protected float miny;
    protected float maxy;
    private boolean enable = true;

    public GSunpoSelectable() {
        this.type = GeomType.SUNPOS;
    }

    public void updateArea() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        if (this.horizontal) {
            f5 = this.p1.x;
            f4 = this.p2.x;
            if (this.offset >= 0.0f) {
                f3 = this.p1.y > this.p2.y ? this.p1.y : this.p2.y;
                f = f2 = f3 + this.offset;
            } else {
                f3 = this.p1.y > this.p2.y ? this.p2.y : this.p1.y;
                f = f2 = f3 + this.offset;
            }
        } else {
            f = this.p1.y;
            f2 = this.p2.y;
            if (this.offset >= 0.0f) {
                f3 = this.p1.x > this.p2.x ? this.p1.x : this.p2.x;
                f5 = f4 = f3 + this.offset;
            } else {
                f3 = this.p1.x > this.p2.x ? this.p2.x : this.p1.x;
                f5 = f4 = f3 + this.offset;
            }
        }
        KFont kFont = NethomeResource.getScaleFont((String)"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af");
        float f6 = this.fontSize / kFont.getSize();
        float f7 = (kFont.getDescentf() + kFont.getAscentf()) * f6;
        float f8 = (float)kFont.stringWidth(this.text) * f6;
        float f9 = 20.0f;
        if (this.horizontal) {
            float f10 = (f5 + f4 - f8) / 2.0f;
            this.minx = f10 - f9;
            this.miny = f - f9;
            this.maxx = f10 + f8 + f9;
            this.maxy = f + f7 + f9;
        } else {
            float f11 = (f + f2 - f8) / 2.0f;
            this.minx = f4 - f7 - f9;
            this.miny = f11 - f9;
            this.maxx = f4 + f9;
            this.maxy = f11 + f8 + f9;
        }
    }

    public void setSeq(int n) {
        this.id = n;
    }

    public int getSeq() {
        return this.id;
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isInner(double d, double d2) {
        if (!this.enable) {
            return false;
        }
        if (d < (double)this.minx || (double)this.maxx < d) {
            return false;
        }
        return !(d2 < (double)this.miny) && !((double)this.maxy < d2);
    }

    public void drawHighLight(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        this.drawLabel(iRichGraphics, color, color2, localAxis2Df);
    }

    @Override
    protected void drawLabel(IRichGraphics iRichGraphics, LocalAxis2Df localAxis2Df) {
        this.drawLabel(iRichGraphics, Color.WHITE, this.enable ? Color.BLACK : Color.LIGHT_GRAY, localAxis2Df);
    }

    protected void drawLabel(IRichGraphics iRichGraphics, Color color, Color color2, LocalAxis2Df localAxis2Df) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        if (this.text == null) {
            return;
        }
        if (this.horizontal) {
            f6 = this.p1.x;
            f5 = this.p2.x;
            if (this.offset >= 0.0f) {
                f4 = this.p1.y > this.p2.y ? this.p1.y : this.p2.y;
                f2 = f3 = f4 + this.offset;
            } else {
                f4 = this.p1.y > this.p2.y ? this.p2.y : this.p1.y;
                f2 = f3 = f4 + this.offset;
            }
        } else {
            f2 = this.p1.y;
            f3 = this.p2.y;
            if (this.offset >= 0.0f) {
                f4 = this.p1.x > this.p2.x ? this.p1.x : this.p2.x;
                f6 = f5 = f4 + this.offset;
            } else {
                f4 = this.p1.x > this.p2.x ? this.p2.x : this.p1.x;
                f6 = f5 = f4 + this.offset;
            }
        }
        if (localAxis2Df != null) {
            f4 = localAxis2Df.getGlobalX(f6, f2);
            f = localAxis2Df.getGlobalY(f6, f2);
            f6 = f4;
            f2 = f;
            f4 = localAxis2Df.getGlobalX(f5, f3);
            f = localAxis2Df.getGlobalY(f5, f3);
            f5 = f4;
            f3 = f;
        }
        KFont kFont = NethomeResource.getScaleFont((String)"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af");
        f = this.fontSize / kFont.getSize();
        float f7 = (kFont.getDescentf() + kFont.getAscentf()) * f;
        float f8 = (float)kFont.stringWidth(this.text) * f;
        float f9 = kFont.getDescentf() * f;
        float f10 = 20.0f;
        if (this.horizontal) {
            float f11 = (f6 + f5 - f8) / 2.0f;
            iRichGraphics.setColor(color);
            iRichGraphics.drawFillRect(f11 - f10, f2 - f10, f11 + f8 + f10, f2 + f7 + f10, null);
            iRichGraphics.setColor(color2);
            iRichGraphics.drawRect(f11 - f10, f2 - f10, f11 + f8 + f10, f2 + f7 + f10, null);
            iRichGraphics.drawText(this.text, f11, f2 + this.fontSize / 2.0f - f7 / 2.0f + f9, "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 0, this.fontSize, 0.0f);
        } else {
            float f12 = (f2 + f3 - f8) / 2.0f;
            float f13 = f6 - this.fontSize / 2.0f + f7 / 2.0f - f9;
            iRichGraphics.setColor(color);
            iRichGraphics.drawFillRect(f5 - f7 - f10, f12 - f10, f5 + f10, f12 + f8 + f10, null);
            iRichGraphics.setColor(color2);
            iRichGraphics.drawRect(f5 - f7 - f10, f12 - f10, f5 + f10, f12 + f8 + f10, null);
            iRichGraphics.drawText(this.text, f13, f12, "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", 0, this.fontSize, 90.0f);
        }
    }

    @Override
    public void save(ObjectFolder objectFolder) {
    }

    @Override
    public void load(ObjectFolder objectFolder) {
    }
}

