/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.domain;

import java.lang.reflect.Method;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.Domain;
import org.seasar.doma.internal.ClassNames;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.util.MethodUtil;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainTypeNotFoundException;
import org.seasar.doma.message.Message;

public final class DomainTypeFactory {
    public static <BASIC, DOMAIN> DomainType<BASIC, DOMAIN> getDomainType(Class<DOMAIN> domainClass) {
        return DomainTypeFactory.getDomainType(domainClass, new ClassHelper(){});
    }

    public static <BASIC, DOMAIN> DomainType<BASIC, DOMAIN> getDomainType(Class<DOMAIN> domainClass, ClassHelper classHelper) {
        if (domainClass == null) {
            throw new DomaNullPointerException("domainClass");
        }
        if (classHelper == null) {
            throw new DomaNullPointerException("classHelper");
        }
        if (!domainClass.isAnnotationPresent(Domain.class)) {
            throw new DomaIllegalArgumentException("domainClass", Message.DOMA2205.getMessage(domainClass.getName()));
        }
        String domainTypeClassName = ClassNames.newDomainDescClassName(domainClass.getName()).toString();
        try {
            Class clazz = classHelper.forName(domainTypeClassName);
            Method method = ClassUtil.getMethod(clazz, "getSingletonInternal", new Class[0]);
            return (DomainType)MethodUtil.invoke(method, null, new Object[0]);
        }
        catch (WrapException e) {
            throw new DomainTypeNotFoundException(e.getCause(), domainClass.getName(), domainTypeClassName);
        }
        catch (Exception e) {
            throw new DomainTypeNotFoundException(e, domainClass.getName(), domainTypeClassName);
        }
    }

    public static <BASIC, DOMAIN> DomainType<BASIC, DOMAIN> getExternalDomainType(Class<DOMAIN> domainClass) {
        return DomainTypeFactory.getExternalDomainType(domainClass, new ClassHelper(){});
    }

    public static <BASIC, DOMAIN> DomainType<BASIC, DOMAIN> getExternalDomainType(Class<DOMAIN> domainClass, ClassHelper classHelper) {
        Class<?> clazz;
        if (domainClass == null) {
            throw new DomaNullPointerException("domainClass");
        }
        if (classHelper == null) {
            throw new DomaNullPointerException("classHelper");
        }
        if (domainClass.isArray()) {
            String domainName = domainClass.getComponentType().getName() + "__ARRAY__";
            clazz = DomainTypeFactory.loadExternalDomainDescClass(domainName, classHelper);
        } else {
            clazz = DomainTypeFactory.loadExternalDomainDescClassWithTraversal(domainClass, classHelper);
        }
        if (clazz == null) {
            return null;
        }
        try {
            Method method = ClassUtil.getMethod(clazz, "getSingletonInternal", new Class[0]);
            return (DomainType)MethodUtil.invoke(method, null, new Object[0]);
        }
        catch (WrapException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> loadExternalDomainDescClass(String domainName, ClassHelper classHelper) {
        String domainTypeClassName = ClassNames.newExternalDomainDescClassName(domainName).toString();
        try {
            return classHelper.forName(domainTypeClassName);
        }
        catch (WrapException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> loadExternalDomainDescClassWithTraversal(Class<?> domainClass, ClassHelper classHelper) {
        return ClassUtil.traverse(domainClass, c -> {
            String domainName = c.getName();
            return DomainTypeFactory.loadExternalDomainDescClass(domainName, classHelper);
        });
    }
}

