/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta.domain;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Context;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.def.TypeParametersDef;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.meta.domain.ExternalDomainMeta;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainConverter;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ExternalDomainMetaFactory
implements TypeElementMetaFactory<ExternalDomainMeta> {
    private final Context ctx;

    public ExternalDomainMetaFactory(Context ctx) {
        AssertionUtil.assertNotNull(ctx);
        this.ctx = ctx;
    }

    @Override
    public ExternalDomainMeta createTypeElementMeta(TypeElement converterElement) {
        this.validateConverter(converterElement);
        TypeMirror[] argTypes = this.getConverterArgTypes(converterElement.asType());
        if (argTypes == null) {
            throw new AptIllegalStateException("converter doesn't have type args: " + converterElement.getQualifiedName());
        }
        ExternalDomainMeta meta = new ExternalDomainMeta(converterElement);
        this.doDomainType(converterElement, argTypes[0], meta);
        this.doValueType(converterElement, argTypes[1], meta);
        return meta;
    }

    private void validateConverter(TypeElement converterElement) {
        if (!this.ctx.getMoreTypes().isAssignableWithErasure(converterElement.asType(), DomainConverter.class)) {
            throw new AptException((MessageResource)Message.DOMA4191, converterElement, new Object[0]);
        }
        if (converterElement.getNestingKind().isNested()) {
            throw new AptException((MessageResource)Message.DOMA4198, converterElement, new Object[0]);
        }
        if (converterElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4192, converterElement, new Object[0]);
        }
        ExecutableElement constructor = this.ctx.getMoreElements().getNoArgConstructor(converterElement);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4193, converterElement, new Object[0]);
        }
    }

    private TypeMirror[] getConverterArgTypes(TypeMirror typeMirror) {
        for (TypeMirror typeMirror2 : this.ctx.getMoreTypes().directSupertypes(typeMirror)) {
            if (!this.ctx.getMoreTypes().isAssignableWithErasure(typeMirror2, DomainConverter.class)) continue;
            if (this.ctx.getMoreTypes().isSameTypeWithErasure(typeMirror2, DomainConverter.class)) {
                DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(typeMirror2);
                AssertionUtil.assertNotNull(declaredType);
                List<? extends TypeMirror> args = declaredType.getTypeArguments();
                AssertionUtil.assertEquals(2, args.size());
                return new TypeMirror[]{args.get(0), args.get(1)};
            }
            TypeMirror[] argTypes = this.getConverterArgTypes(typeMirror2);
            if (argTypes == null) continue;
            return argTypes;
        }
        return null;
    }

    private void doDomainType(TypeElement converterElement, TypeMirror domainType, ExternalDomainMeta meta) {
        PackageElement pkgElement;
        meta.setType(domainType);
        ArrayType arrayType = this.ctx.getMoreTypes().toArrayType(domainType);
        if (arrayType != null) {
            TypeMirror componentType = arrayType.getComponentType();
            if (componentType.getKind() == TypeKind.ARRAY) {
                throw new AptException((MessageResource)Message.DOMA4447, converterElement, new Object[0]);
            }
            TypeElement componentElement = this.ctx.getMoreTypes().toTypeElement(componentType);
            if (componentElement == null) {
                throw new AptIllegalStateException(componentType.toString());
            }
            if (!componentElement.getTypeParameters().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4448, converterElement, new Object[0]);
            }
            return;
        }
        TypeElement domainElement = this.ctx.getMoreTypes().toTypeElement(domainType);
        if (domainElement == null) {
            throw new AptIllegalStateException(domainType.toString());
        }
        if (domainElement.getNestingKind().isNested()) {
            this.validateEnclosingElement(domainElement);
        }
        if ((pkgElement = this.ctx.getMoreElements().getPackageOf(domainElement)).isUnnamed()) {
            throw new AptException((MessageResource)Message.DOMA4197, converterElement, new Object[]{domainElement.getQualifiedName()});
        }
        DeclaredType declaredType = this.ctx.getMoreTypes().toDeclaredType(domainType);
        if (declaredType == null) {
            throw new AptIllegalStateException(domainType.toString());
        }
        for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
            if (typeMirror.getKind() == TypeKind.WILDCARD) continue;
            throw new AptException((MessageResource)Message.DOMA4203, converterElement, new Object[]{domainElement.getQualifiedName()});
        }
        meta.setTypeElement(domainElement);
        TypeParametersDef typeParametersDef = this.ctx.getMoreElements().getTypeParametersDef(domainElement);
        meta.setTypeParametersDef(typeParametersDef);
    }

    private void validateEnclosingElement(Element element) {
        TypeElement typeElement = this.ctx.getMoreElements().toTypeElement(element);
        if (typeElement == null) {
            return;
        }
        String simpleName = typeElement.getSimpleName().toString();
        if (simpleName.contains("$") || simpleName.contains("__")) {
            throw new AptException((MessageResource)Message.DOMA4280, typeElement, new Object[]{typeElement.getQualifiedName()});
        }
        NestingKind nestingKind = typeElement.getNestingKind();
        if (nestingKind == NestingKind.TOP_LEVEL) {
            return;
        }
        if (nestingKind == NestingKind.MEMBER) {
            Set<Modifier> modifiers = typeElement.getModifiers();
            if (!modifiers.containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC))) {
                throw new AptException((MessageResource)Message.DOMA4278, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
        } else {
            throw new AptException((MessageResource)Message.DOMA4279, typeElement, new Object[]{typeElement.getQualifiedName()});
        }
        this.validateEnclosingElement(typeElement.getEnclosingElement());
    }

    private void doValueType(TypeElement converterElement, TypeMirror valueType, ExternalDomainMeta meta) {
        meta.setValueType(valueType);
        BasicCtType basicCtType = this.ctx.getCtTypes().newBasicCtType(valueType);
        if (basicCtType == null) {
            throw new AptException((MessageResource)Message.DOMA4194, converterElement, new Object[]{valueType});
        }
        meta.setBasicCtType(basicCtType);
    }
}

