/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.generator;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.generator.Code;
import org.seasar.doma.internal.jdbc.scalar.BasicScalar;
import org.seasar.doma.internal.jdbc.scalar.OptionalBasicScalar;
import org.seasar.doma.internal.jdbc.scalar.OptionalDoubleScalar;
import org.seasar.doma.internal.jdbc.scalar.OptionalIntScalar;
import org.seasar.doma.internal.jdbc.scalar.OptionalLongScalar;
import org.seasar.doma.internal.util.AssertionUtil;

class ScalarMetaFactory
extends SimpleCtTypeVisitor<ScalarMeta, Boolean, RuntimeException> {
    private BasicCtType basicCtType;
    private Code containerTypeCode;
    private Code supplierCode;

    ScalarMetaFactory() {
    }

    @Override
    protected ScalarMeta defaultAction(CtType ctType, Boolean optional) {
        AssertionUtil.assertNotNull((Object)this.basicCtType, (Object)this.containerTypeCode, (Object)this.supplierCode);
        return new ScalarMeta();
    }

    @Override
    public ScalarMeta visitOptionalCtType(OptionalCtType ctType, Boolean optional) {
        return ctType.getElementCtType().accept(this, true);
    }

    @Override
    public ScalarMeta visitOptionalIntCtType(OptionalIntCtType ctType, Boolean optional) {
        this.basicCtType = ctType.getElementCtType();
        this.containerTypeCode = new Code(p -> p.print("%1$s", OptionalInt.class));
        this.supplierCode = new Code(p -> p.print("%1$s::new", OptionalIntScalar.class));
        return this.defaultAction((CtType)ctType, optional);
    }

    @Override
    public ScalarMeta visitOptionalLongCtType(OptionalLongCtType ctType, Boolean optional) {
        this.basicCtType = ctType.getElementCtType();
        this.containerTypeCode = new Code(p -> p.print("%1$s", OptionalLong.class));
        this.supplierCode = new Code(p -> p.print("%1$s::new", OptionalLongScalar.class));
        return this.defaultAction((CtType)ctType, optional);
    }

    @Override
    public ScalarMeta visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Boolean optional) {
        this.basicCtType = ctType.getElementCtType();
        this.containerTypeCode = new Code(p -> p.print("%1$s", OptionalDouble.class));
        this.supplierCode = new Code(p -> p.print("%1$s::new", OptionalDoubleScalar.class));
        return this.defaultAction((CtType)ctType, optional);
    }

    @Override
    public ScalarMeta visitBasicCtType(BasicCtType basicCtType, Boolean optional) {
        this.basicCtType = basicCtType;
        this.containerTypeCode = new Code(p -> {
            if (optional.booleanValue()) {
                p.print("%1$s<%2$s>", Optional.class, basicCtType.getBoxedType());
            } else {
                p.print("%1$s", basicCtType.getBoxedType());
            }
        });
        this.supplierCode = new Code(p -> {
            if (optional.booleanValue()) {
                p.print("() -> new %1$s<>(%2$s)", OptionalBasicScalar.class, basicCtType.getWrapperSupplierCode());
            } else {
                p.print("() -> new %1$s<>(%2$s)", BasicScalar.class, basicCtType.getWrapperSupplierCode());
            }
        });
        return this.defaultAction((CtType)basicCtType, optional);
    }

    @Override
    public ScalarMeta visitDomainCtType(DomainCtType domainCtType, Boolean optional) {
        this.basicCtType = domainCtType.getBasicCtType();
        this.containerTypeCode = new Code(p -> {
            if (optional.booleanValue()) {
                p.print("%1$s<%2$s>", Optional.class, domainCtType.getType());
            } else {
                p.print("%1$s", domainCtType.getType());
            }
        });
        this.supplierCode = new Code(p -> {
            if (optional.booleanValue()) {
                p.print("%1$s::createOptionalScalar", domainCtType.getDescCode());
            } else {
                p.print("%1$s::createScalar", domainCtType.getDescCode());
            }
        });
        return this.defaultAction((CtType)domainCtType, optional);
    }

    public class ScalarMeta {
        public TypeMirror getBasicType() {
            return ScalarMetaFactory.this.basicCtType.getBoxedType();
        }

        public Code getContainerType() {
            return ScalarMetaFactory.this.containerTypeCode;
        }

        public Code getSupplier() {
            return ScalarMetaFactory.this.supplierCode;
        }
    }
}

