/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.wrapper;

import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.wrapper.AbstractWrapper;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.WrapperVisitor;

public class FloatWrapper
extends AbstractWrapper<Float>
implements NumberWrapper<Float> {
    public FloatWrapper() {
        super(Float.class);
    }

    public FloatWrapper(Float value) {
        super(Float.class, value);
    }

    @Override
    public void set(Number v) {
        super.set(Float.valueOf(v.floatValue()));
    }

    @Override
    public Float getDefault() {
        return Float.valueOf(0.0f);
    }

    @Override
    public void increment() {
        Float value = (Float)this.doGet();
        if (value != null) {
            this.doSet(Float.valueOf(value.floatValue() + 1.0f));
        }
    }

    @Override
    public void decrement() {
        Float value = (Float)this.doGet();
        if (value != null) {
            this.doSet(Float.valueOf(value.floatValue() - 1.0f));
        }
    }

    @Override
    public <R, P, Q, TH extends Throwable> R accept(WrapperVisitor<R, P, Q, TH> visitor, P p, Q q) throws TH {
        if (visitor == null) {
            throw new DomaNullPointerException("visitor");
        }
        return visitor.visitFloatWrapper(this, p, q);
    }
}

