/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.tx;

import java.util.function.Supplier;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.tx.LocalTransaction;
import org.seasar.doma.jdbc.tx.LocalTransactionContext;
import org.seasar.doma.jdbc.tx.TransactionIsolationLevel;
import org.seasar.doma.jdbc.tx.TransactionManager;

public class LocalTransactionManager
implements TransactionManager {
    protected final LocalTransaction transaction;

    public LocalTransactionManager(LocalTransaction transaction) {
        if (transaction == null) {
            throw new DomaNullPointerException("transaction");
        }
        this.transaction = transaction;
    }

    @Override
    public void required(Runnable block) {
        if (block == null) {
            throw new DomaNullPointerException("block");
        }
        this.requiredInternal(TransactionIsolationLevel.DEFAULT, this.toSupplier(block));
    }

    @Override
    public void required(TransactionIsolationLevel isolationLevel, Runnable block) {
        if (isolationLevel == null) {
            throw new DomaNullPointerException("isolationLevel");
        }
        if (block == null) {
            throw new DomaNullPointerException("block");
        }
        this.requiredInternal(isolationLevel, this.toSupplier(block));
    }

    @Override
    public <RESULT> RESULT required(Supplier<RESULT> supplier) {
        if (supplier == null) {
            throw new DomaNullPointerException("supplier");
        }
        return this.requiredInternal(TransactionIsolationLevel.DEFAULT, supplier);
    }

    @Override
    public <RESULT> RESULT required(TransactionIsolationLevel isolationLevel, Supplier<RESULT> supplier) {
        if (isolationLevel == null) {
            throw new DomaNullPointerException("isolationLevel");
        }
        if (supplier == null) {
            throw new DomaNullPointerException("supplier");
        }
        return this.requiredInternal(isolationLevel, supplier);
    }

    protected <RESULT> RESULT requiredInternal(TransactionIsolationLevel isolationLevel, Supplier<RESULT> supplier) {
        AssertionUtil.assertNotNull((Object)isolationLevel, supplier);
        if (this.transaction.isActive()) {
            return supplier.get();
        }
        return this.executeInTransaction(isolationLevel, supplier);
    }

    @Override
    public void requiresNew(Runnable block) {
        if (block == null) {
            throw new DomaNullPointerException("block");
        }
        this.requiresNewInternal(TransactionIsolationLevel.DEFAULT, this.toSupplier(block));
    }

    @Override
    public void requiresNew(TransactionIsolationLevel isolationLevel, Runnable block) {
        if (isolationLevel == null) {
            throw new DomaNullPointerException("isolationLevel");
        }
        if (block == null) {
            throw new DomaNullPointerException("block");
        }
        this.requiresNewInternal(isolationLevel, this.toSupplier(block));
    }

    @Override
    public <RESULT> RESULT requiresNew(Supplier<RESULT> supplier) {
        if (supplier == null) {
            throw new DomaNullPointerException("supplier");
        }
        return this.requiresNewInternal(TransactionIsolationLevel.DEFAULT, supplier);
    }

    @Override
    public <RESULT> RESULT requiresNew(TransactionIsolationLevel isolationLevel, Supplier<RESULT> supplier) {
        if (isolationLevel == null) {
            throw new DomaNullPointerException("isolationLevel");
        }
        if (supplier == null) {
            throw new DomaNullPointerException("supplier");
        }
        return this.requiresNewInternal(isolationLevel, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> RESULT requiresNewInternal(TransactionIsolationLevel isolationLevel, Supplier<RESULT> supplier) {
        AssertionUtil.assertNotNull((Object)isolationLevel, supplier);
        if (this.transaction.isActive()) {
            LocalTransactionContext context = this.transaction.suspend();
            try {
                RESULT RESULT = this.executeInTransaction(isolationLevel, supplier);
                return RESULT;
            }
            finally {
                this.transaction.resume(context);
            }
        }
        return this.executeInTransaction(isolationLevel, supplier);
    }

    @Override
    public void notSupported(Runnable block) {
        if (block == null) {
            throw new DomaNullPointerException("block");
        }
        this.notSupportedInternal(TransactionIsolationLevel.DEFAULT, this.toSupplier(block));
    }

    @Override
    public void notSupported(TransactionIsolationLevel isolationLevel, Runnable block) {
        if (isolationLevel == null) {
            throw new DomaNullPointerException("isolationLevel");
        }
        if (block == null) {
            throw new DomaNullPointerException("block");
        }
        this.notSupportedInternal(isolationLevel, this.toSupplier(block));
    }

    @Override
    public <RESULT> RESULT notSupported(Supplier<RESULT> supplier) {
        if (supplier == null) {
            throw new DomaNullPointerException("supplier");
        }
        return this.notSupportedInternal(TransactionIsolationLevel.DEFAULT, supplier);
    }

    @Override
    public <RESULT> RESULT notSupported(TransactionIsolationLevel isolationLevel, Supplier<RESULT> supplier) {
        if (isolationLevel == null) {
            throw new DomaNullPointerException("isolationLevel");
        }
        if (supplier == null) {
            throw new DomaNullPointerException("supplier");
        }
        return this.notSupportedInternal(isolationLevel, supplier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> RESULT notSupportedInternal(TransactionIsolationLevel isolationLevel, Supplier<RESULT> supplier) {
        AssertionUtil.assertNotNull((Object)isolationLevel, supplier);
        if (this.transaction.isActive()) {
            LocalTransactionContext context = this.transaction.suspend();
            try {
                RESULT RESULT = supplier.get();
                return RESULT;
            }
            finally {
                this.transaction.resume(context);
            }
        }
        return supplier.get();
    }

    protected Supplier<Void> toSupplier(Runnable block) {
        return () -> {
            block.run();
            return null;
        };
    }

    @Override
    public void setRollbackOnly() {
        this.transaction.setRollbackOnly();
    }

    @Override
    public boolean isRollbackOnly() {
        return this.transaction.isRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RESULT> RESULT executeInTransaction(TransactionIsolationLevel isolationLevel, Supplier<RESULT> supplier) {
        AssertionUtil.assertNotNull((Object)isolationLevel, supplier);
        this.transaction.begin(isolationLevel);
        try {
            RESULT result = supplier.get();
            if (!this.transaction.isRollbackOnly()) {
                this.transaction.commit();
            }
            RESULT RESULT = result;
            return RESULT;
        }
        finally {
            this.transaction.rollback();
        }
    }

    @Override
    public void setSavepoint(String savepointName) {
        this.transaction.setSavepoint(savepointName);
    }

    @Override
    public boolean hasSavepoint(String savepointName) {
        return this.transaction.hasSavepoint(savepointName);
    }

    @Override
    public void releaseSavepoint(String savepointName) {
        this.transaction.releaseSavepoint(savepointName);
    }

    @Override
    public void rollback(String savepointName) {
        this.transaction.rollback(savepointName);
    }
}

