/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.jdbc.sql.SqlContext;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.Naming;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.Property;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.wrapper.Wrapper;

public class UpdateQueryHelper<E> {
    protected final Config config;
    protected final EntityType<E> entityType;
    protected final boolean nullExcluded;
    protected final boolean versionIgnored;
    protected final boolean optimisticLockExceptionSuppressed;
    protected final boolean unchangedPropertyIncluded;
    protected final String[] includedPropertyNames;
    protected final String[] excludedPropertyNames;

    public UpdateQueryHelper(Config config, EntityType<E> entityType, String[] includedPropertyNames, String[] excludedPropertyNames, boolean nullExcluded, boolean versionIgnored, boolean optimisticLockExceptionSuppressed, boolean unchangedPropertyIncluded) {
        this.config = config;
        this.entityType = entityType;
        this.nullExcluded = nullExcluded;
        this.versionIgnored = versionIgnored;
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
        this.unchangedPropertyIncluded = unchangedPropertyIncluded;
        this.includedPropertyNames = includedPropertyNames;
        this.excludedPropertyNames = excludedPropertyNames;
    }

    public List<EntityPropertyType<E, ?>> getTargetPropertyTypes(E entity) {
        int capacity = this.entityType.getEntityPropertyTypes().size();
        ArrayList results = new ArrayList(capacity);
        E originalStates = this.entityType.getOriginalStates(entity);
        for (EntityPropertyType<E, ?> propertyType : this.entityType.getEntityPropertyTypes()) {
            String name;
            if (!propertyType.isUpdatable() || propertyType.isId() || !this.versionIgnored && propertyType.isVersion() || propertyType.isTenantId()) continue;
            if (this.nullExcluded) {
                Property<E, ?> property = propertyType.createProperty();
                property.load(entity);
                if (property.getWrapper().get() == null) continue;
            }
            if (!this.unchangedPropertyIncluded && originalStates != null && !this.isChanged(entity, originalStates, propertyType) || !this.isTargetPropertyName(name = propertyType.getName())) continue;
            results.add(propertyType);
        }
        return results;
    }

    protected boolean isTargetPropertyName(String name) {
        if (this.includedPropertyNames.length > 0) {
            for (String includedName : this.includedPropertyNames) {
                if (!includedName.equals(name)) continue;
                for (String excludedName : this.excludedPropertyNames) {
                    if (!excludedName.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.excludedPropertyNames.length > 0) {
            for (String excludedName : this.excludedPropertyNames) {
                if (!excludedName.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    protected boolean isChanged(E entity, E originalStates, EntityPropertyType<E, ?> propertyType) {
        Wrapper originalWrapper;
        Wrapper wrapper = propertyType.createProperty().load(entity).getWrapper();
        return !wrapper.hasEqualValue((originalWrapper = propertyType.createProperty().load(originalStates).getWrapper()).get());
    }

    public void populateValues(E entity, List<EntityPropertyType<E, ?>> targetPropertyTypes, VersionPropertyType<? super E, E, ?, ?> versionPropertyType, SqlContext context) {
        Dialect dialect = this.config.getDialect();
        Naming naming = this.config.getNaming();
        for (EntityPropertyType<E, ?> propertyType : targetPropertyTypes) {
            Property<E, ?> property = propertyType.createProperty();
            property.load(entity);
            context.appendSql(propertyType.getColumnName(naming::apply, dialect::applyQuote));
            context.appendSql(" = ");
            context.appendParameter(property.asInParameter());
            context.appendSql(", ");
        }
        if (!this.versionIgnored && versionPropertyType != null) {
            Property property = versionPropertyType.createProperty();
            property.load(entity);
            context.appendSql(versionPropertyType.getColumnName(naming::apply, dialect::applyQuote));
            context.appendSql(" = ");
            context.appendParameter(property.asInParameter());
            context.appendSql(" + 1");
        } else {
            context.cutBackSql(2);
        }
    }
}

