/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.util.List;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.sql.SqlContext;
import org.seasar.doma.internal.jdbc.sql.node.PopulateNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.jdbc.query.SqlFileModifyQuery;
import org.seasar.doma.jdbc.query.UpdateQuery;
import org.seasar.doma.jdbc.query.UpdateQueryHelper;

public class SqlFileUpdateQuery
extends SqlFileModifyQuery
implements UpdateQuery {
    protected EntityHandler<?> entityHandler;
    protected boolean nullExcluded;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;
    protected boolean unchangedPropertyIncluded;

    public SqlFileUpdateQuery() {
        super(SqlKind.UPDATE);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.sqlFilePath);
        this.initEntityHandler();
        this.preUpdate();
        this.prepareOptimisticLock();
        this.prepareOptions();
        this.prepareTargetPropertyTypes();
        this.prepareExecutable();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void initEntityHandler() {
        if (this.entityHandler != null) {
            this.entityHandler.init();
        }
    }

    protected void preUpdate() {
        if (this.entityHandler != null) {
            this.entityHandler.preUpdate();
        }
    }

    protected void prepareTargetPropertyTypes() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareTargetPropertyTypes();
        }
    }

    protected void prepareExecutable() {
        if (this.entityHandler == null || this.entityHandler.hasTargetPropertyTypes()) {
            this.executable = true;
            this.sqlExecutionSkipCause = null;
        }
    }

    @Override
    protected void populateValues(PopulateNode node, SqlContext context) {
        if (this.entityHandler == null) {
            throw new UnsupportedOperationException();
        }
        this.entityHandler.populateValues(context);
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void incrementVersion() {
        if (this.entityHandler != null) {
            this.entityHandler.incrementVersion();
        }
    }

    public <E> E getEntity(Class<E> entityType) {
        if (this.entityHandler != null) {
            return this.entityHandler.entity;
        }
        return null;
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            this.entityHandler.postUpdate();
        }
    }

    @Override
    public <E> void setEntityAndEntityType(String name, E entity, EntityType<E> entityType) {
        this.entityHandler = new EntityHandler<E>(name, entity, entityType);
    }

    public void setNullExcluded(boolean nullExcluded) {
        this.nullExcluded = nullExcluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    public void setUnchangedPropertyIncluded(Boolean unchangedPropertyIncluded) {
        this.unchangedPropertyIncluded = unchangedPropertyIncluded;
    }

    protected static class SqlFilePostUpdateContext<E>
    extends AbstractPostUpdateContext<E> {
        public SqlFilePostUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class SqlFilePreUpdateContext<E>
    extends AbstractPreUpdateContext<E> {
        public SqlFilePreUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected class EntityHandler<E> {
        protected String name;
        protected E entity;
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;
        protected List<EntityPropertyType<E, ?>> targetPropertyTypes;
        protected UpdateQueryHelper<E> helper;

        protected EntityHandler(String name, E entity, EntityType<E> entityType) {
            AssertionUtil.assertNotNull((Object)name, entity, entityType);
            this.name = name;
            this.entity = entity;
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void init() {
            this.helper = new UpdateQueryHelper<E>(SqlFileUpdateQuery.this.config, this.entityType, SqlFileUpdateQuery.this.includedPropertyNames, SqlFileUpdateQuery.this.excludedPropertyNames, SqlFileUpdateQuery.this.nullExcluded, SqlFileUpdateQuery.this.versionIgnored, SqlFileUpdateQuery.this.optimisticLockExceptionSuppressed, SqlFileUpdateQuery.this.unchangedPropertyIncluded);
        }

        protected void preUpdate() {
            SqlFilePreUpdateContext<E> context = new SqlFilePreUpdateContext<E>(this.entityType, SqlFileUpdateQuery.this.method, SqlFileUpdateQuery.this.config);
            this.entityType.preUpdate(this.entity, context);
            if (context.getNewEntity() != null) {
                this.entity = context.getNewEntity();
                SqlFileUpdateQuery.this.addParameterInternal(this.name, this.entityType.getEntityClass(), this.entity);
            }
        }

        protected void prepareTargetPropertyTypes() {
            this.targetPropertyTypes = this.helper.getTargetPropertyTypes(this.entity);
        }

        protected boolean hasTargetPropertyTypes() {
            return this.targetPropertyTypes != null && !this.targetPropertyTypes.isEmpty();
        }

        protected void postUpdate() {
            SqlFilePostUpdateContext<E> context = new SqlFilePostUpdateContext<E>(this.entityType, SqlFileUpdateQuery.this.method, SqlFileUpdateQuery.this.config);
            this.entityType.postUpdate(this.entity, context);
            if (context.getNewEntity() != null) {
                this.entity = context.getNewEntity();
            }
            this.entityType.saveCurrentStates(this.entity);
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileUpdateQuery.this.versionIgnored && !SqlFileUpdateQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileUpdateQuery.this.optimisticLockCheckRequired = true;
            }
        }

        protected void incrementVersion() {
            if (this.versionPropertyType != null && !SqlFileUpdateQuery.this.versionIgnored) {
                this.entity = this.versionPropertyType.increment(this.entityType, this.entity);
            }
        }

        protected void populateValues(SqlContext context) {
            this.helper.populateValues((E)this.entity, (List<EntityPropertyType<? super E, ?>>)this.targetPropertyTypes, (VersionPropertyType<? super E, ? super E, ?, ?>)this.versionPropertyType, context);
        }
    }
}

