/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.net.URL;
import org.seasar.doma.internal.jdbc.util.ScriptFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ResourceUtil;
import org.seasar.doma.jdbc.ScriptFileNotFoundException;
import org.seasar.doma.jdbc.Sql;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.ScriptQuery;

public class SqlFileScriptQuery
extends AbstractQuery
implements ScriptQuery {
    protected String scriptFilePath;
    protected String blockDelimiter;
    protected boolean haltOnError;
    protected URL scriptFileUrl;
    protected SqlLogType sqlLogType;

    public void setScriptFilePath(String scriptFilePath) {
        this.scriptFilePath = scriptFilePath;
    }

    public void setBlockDelimiter(String blockDelimiter) {
        this.blockDelimiter = blockDelimiter;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.scriptFilePath, (Object)this.blockDelimiter);
        AssertionUtil.assertTrue(this.scriptFilePath.startsWith("META-INF/"), new Object[0]);
        AssertionUtil.assertTrue(this.scriptFilePath.endsWith(".script"), new Object[0]);
        String dbmsSpecificPath = ScriptFileUtil.convertToDbmsSpecificPath(this.scriptFilePath, this.config.getDialect());
        this.scriptFileUrl = ResourceUtil.getResource(dbmsSpecificPath);
        if (this.scriptFileUrl != null) {
            this.scriptFilePath = dbmsSpecificPath;
        } else {
            this.scriptFileUrl = ResourceUtil.getResource(this.scriptFilePath);
            if (this.scriptFileUrl == null) {
                throw new ScriptFileNotFoundException(this.scriptFilePath);
            }
        }
        if (this.blockDelimiter.isEmpty()) {
            this.blockDelimiter = this.config.getDialect().getScriptBlockDelimiter();
        }
    }

    @Override
    public void complete() {
    }

    @Override
    public int getQueryTimeout() {
        return -1;
    }

    @Override
    public Sql<?> getSql() {
        AssertionUtil.assertUnreachable();
        return null;
    }

    @Override
    public String getScriptFilePath() {
        return this.scriptFilePath;
    }

    @Override
    public URL getScriptFileUrl() {
        return this.scriptFileUrl;
    }

    @Override
    public String getBlockDelimiter() {
        return this.blockDelimiter;
    }

    @Override
    public boolean getHaltOnError() {
        return this.haltOnError;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }
}

