/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import org.seasar.doma.internal.jdbc.entity.AbstractPostDeleteContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreDeleteContext;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.jdbc.query.DeleteQuery;
import org.seasar.doma.jdbc.query.SqlFileModifyQuery;

public class SqlFileDeleteQuery
extends SqlFileModifyQuery
implements DeleteQuery {
    protected EntityHandler<?> entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileDeleteQuery() {
        super(SqlKind.DELETE);
    }

    @Override
    public void prepare() {
        super.prepare();
        AssertionUtil.assertNotNull((Object)this.method, (Object)this.sqlFilePath);
        this.preDelete();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareExecutable();
        this.prepareSql();
        AssertionUtil.assertNotNull(this.sql);
    }

    protected void preDelete() {
        if (this.entityHandler != null) {
            this.entityHandler.preDelete();
        }
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    protected void prepareExecutable() {
        this.executable = true;
        this.sqlExecutionSkipCause = null;
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            this.entityHandler.postDelete();
        }
    }

    @Override
    public <E> void setEntityAndEntityType(String name, E entity, EntityType<E> entityType) {
        this.entityHandler = new EntityHandler<E>(name, entity, entityType);
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored = versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    public <E> E getEntity(Class<E> entityType) {
        if (this.entityHandler != null) {
            return this.entityHandler.entity;
        }
        return null;
    }

    protected static class SqlFilePostDeleteContext<E>
    extends AbstractPostDeleteContext<E> {
        public SqlFilePostDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected static class SqlFilePreDeleteContext<E>
    extends AbstractPreDeleteContext<E> {
        public SqlFilePreDeleteContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }
    }

    protected class EntityHandler<E> {
        protected String name;
        protected E entity;
        protected EntityType<E> entityType;
        protected VersionPropertyType<? super E, E, ?, ?> versionPropertyType;

        protected EntityHandler(String name, E entity, EntityType<E> entityType) {
            AssertionUtil.assertNotNull((Object)name, entity, entityType);
            this.name = name;
            this.entity = entity;
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void preDelete() {
            SqlFilePreDeleteContext<E> context = new SqlFilePreDeleteContext<E>(this.entityType, SqlFileDeleteQuery.this.method, SqlFileDeleteQuery.this.config);
            this.entityType.preDelete(this.entity, context);
            if (context.getNewEntity() != null) {
                this.entity = context.getNewEntity();
                SqlFileDeleteQuery.this.addParameterInternal(this.name, this.entityType.getEntityClass(), this.entity);
            }
        }

        protected void postDelete() {
            SqlFilePostDeleteContext<E> context = new SqlFilePostDeleteContext<E>(this.entityType, SqlFileDeleteQuery.this.method, SqlFileDeleteQuery.this.config);
            this.entityType.postDelete(this.entity, context);
            if (context.getNewEntity() != null) {
                this.entity = context.getNewEntity();
            }
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileDeleteQuery.this.versionIgnored && !SqlFileDeleteQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileDeleteQuery.this.optimisticLockCheckRequired = true;
            }
        }
    }
}

