/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import org.seasar.doma.internal.jdbc.entity.AbstractPostUpdateContext;
import org.seasar.doma.internal.jdbc.entity.AbstractPreUpdateContext;
import org.seasar.doma.internal.jdbc.sql.SqlContext;
import org.seasar.doma.internal.jdbc.sql.node.PopulateNode;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.Config;
import org.seasar.doma.jdbc.SqlKind;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.jdbc.query.BatchUpdateQuery;
import org.seasar.doma.jdbc.query.BatchUpdateQueryHelper;
import org.seasar.doma.jdbc.query.SqlFileBatchModifyQuery;

public class SqlFileBatchUpdateQuery<ELEMENT>
extends SqlFileBatchModifyQuery<ELEMENT>
implements BatchUpdateQuery {
    protected EntityHandler entityHandler;
    protected boolean versionIgnored;
    protected boolean optimisticLockExceptionSuppressed;

    public SqlFileBatchUpdateQuery(Class<ELEMENT> elementClass) {
        super(elementClass, SqlKind.BATCH_UPDATE);
    }

    @Override
    public void prepare() {
        super.prepare();
        int size = this.elements.size();
        if (size == 0) {
            return;
        }
        this.executable = true;
        this.sqlExecutionSkipCause = null;
        this.currentEntity = this.elements.get(0);
        this.initEntityHandler();
        this.preUpdate();
        this.prepareSqlFile();
        this.prepareOptions();
        this.prepareOptimisticLock();
        this.prepareTargetPropertyTypes();
        this.prepareSql();
        this.elements.set(0, this.currentEntity);
        ListIterator<Object> it = this.elements.listIterator(1);
        while (it.hasNext()) {
            this.currentEntity = it.next();
            this.preUpdate();
            this.prepareSql();
            it.set(this.currentEntity);
        }
        AssertionUtil.assertEquals(size, this.sqls.size());
    }

    protected void initEntityHandler() {
        if (this.entityHandler != null) {
            this.entityHandler.init();
        }
    }

    protected void preUpdate() {
        if (this.entityHandler != null) {
            this.entityHandler.preUpdate();
        }
    }

    protected void prepareTargetPropertyTypes() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareTargetPropertyTypes();
        }
    }

    @Override
    protected void populateValues(PopulateNode node, SqlContext context) {
        if (this.entityHandler == null) {
            throw new UnsupportedOperationException();
        }
        this.entityHandler.populateValues(context);
    }

    protected void prepareOptimisticLock() {
        if (this.entityHandler != null) {
            this.entityHandler.prepareOptimisticLock();
        }
    }

    @Override
    public void incrementVersions() {
        if (this.entityHandler != null) {
            this.entityHandler.incrementVersions();
        }
    }

    @Override
    public void complete() {
        if (this.entityHandler != null) {
            ListIterator<Object> it = this.elements.listIterator();
            while (it.hasNext()) {
                this.currentEntity = it.next();
                this.entityHandler.postUpdate();
                it.set(this.currentEntity);
            }
        }
    }

    @Override
    public void setEntityType(EntityType<ELEMENT> entityType) {
        this.entityHandler = new EntityHandler(entityType);
    }

    public void setVersionIncluded(boolean versionIncluded) {
        this.versionIgnored |= versionIncluded;
    }

    public void setVersionIgnored(boolean versionIgnored) {
        this.versionIgnored |= versionIgnored;
    }

    public void setOptimisticLockExceptionSuppressed(boolean optimisticLockExceptionSuppressed) {
        this.optimisticLockExceptionSuppressed = optimisticLockExceptionSuppressed;
    }

    protected static class SqlFileBatchPostUpdateContext<E>
    extends AbstractPostUpdateContext<E> {
        public SqlFileBatchPostUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected static class SqlFileBatchPreUpdateContext<E>
    extends AbstractPreUpdateContext<E> {
        public SqlFileBatchPreUpdateContext(EntityType<E> entityType, Method method, Config config) {
            super(entityType, method, config);
        }

        @Override
        public boolean isEntityChanged() {
            return true;
        }

        @Override
        public boolean isPropertyChanged(String propertyName) {
            this.validatePropertyDefined(propertyName);
            return true;
        }
    }

    protected class EntityHandler {
        protected EntityType<ELEMENT> entityType;
        protected VersionPropertyType<? super ELEMENT, ELEMENT, ?, ?> versionPropertyType;
        protected List<EntityPropertyType<ELEMENT, ?>> targetPropertyTypes;
        protected BatchUpdateQueryHelper<ELEMENT> helper;

        protected EntityHandler(EntityType<ELEMENT> entityType) {
            AssertionUtil.assertNotNull(entityType);
            this.entityType = entityType;
            this.versionPropertyType = entityType.getVersionPropertyType();
        }

        protected void init() {
            this.helper = new BatchUpdateQueryHelper(SqlFileBatchUpdateQuery.this.config, this.entityType, SqlFileBatchUpdateQuery.this.includedPropertyNames, SqlFileBatchUpdateQuery.this.excludedPropertyNames, SqlFileBatchUpdateQuery.this.versionIgnored, SqlFileBatchUpdateQuery.this.optimisticLockExceptionSuppressed);
        }

        protected void preUpdate() {
            SqlFileBatchPreUpdateContext context = new SqlFileBatchPreUpdateContext(this.entityType, SqlFileBatchUpdateQuery.this.method, SqlFileBatchUpdateQuery.this.config);
            this.entityType.preUpdate(SqlFileBatchUpdateQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchUpdateQuery.this.currentEntity = context.getNewEntity();
            }
        }

        protected void prepareTargetPropertyTypes() {
            this.targetPropertyTypes = this.helper.getTargetPropertyTypes();
        }

        protected void postUpdate() {
            SqlFileBatchPostUpdateContext context = new SqlFileBatchPostUpdateContext(this.entityType, SqlFileBatchUpdateQuery.this.method, SqlFileBatchUpdateQuery.this.config);
            this.entityType.postUpdate(SqlFileBatchUpdateQuery.this.currentEntity, context);
            if (context.getNewEntity() != null) {
                SqlFileBatchUpdateQuery.this.currentEntity = context.getNewEntity();
            }
            this.entityType.saveCurrentStates(SqlFileBatchUpdateQuery.this.currentEntity);
        }

        protected void prepareOptimisticLock() {
            if (this.versionPropertyType != null && !SqlFileBatchUpdateQuery.this.versionIgnored && !SqlFileBatchUpdateQuery.this.optimisticLockExceptionSuppressed) {
                SqlFileBatchUpdateQuery.this.optimisticLockCheckRequired = true;
            }
        }

        protected void incrementVersions() {
            if (this.versionPropertyType != null && !SqlFileBatchUpdateQuery.this.versionIgnored) {
                ListIterator it = SqlFileBatchUpdateQuery.this.elements.listIterator();
                while (it.hasNext()) {
                    Object newEntity = this.versionPropertyType.increment(this.entityType, it.next());
                    it.set(newEntity);
                }
            }
        }

        protected void populateValues(SqlContext context) {
            this.helper.populateValues(SqlFileBatchUpdateQuery.this.currentEntity, this.targetPropertyTypes, this.versionPropertyType, context);
        }
    }
}

