/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.PreparedSql;
import org.seasar.doma.jdbc.SqlExecutionSkipCause;
import org.seasar.doma.jdbc.SqlLogType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.TenantIdPropertyType;
import org.seasar.doma.jdbc.entity.VersionPropertyType;
import org.seasar.doma.jdbc.query.AbstractQuery;
import org.seasar.doma.jdbc.query.BatchModifyQuery;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AutoBatchModifyQuery<ENTITY>
extends AbstractQuery
implements BatchModifyQuery {
    protected static final String[] EMPTY_STRINGS = new String[0];
    protected List<EntityPropertyType<ENTITY, ?>> targetPropertyTypes;
    protected List<EntityPropertyType<ENTITY, ?>> idPropertyTypes;
    protected String[] includedPropertyNames = EMPTY_STRINGS;
    protected String[] excludedPropertyNames = EMPTY_STRINGS;
    protected final EntityType<ENTITY> entityType;
    protected VersionPropertyType<? super ENTITY, ENTITY, ?, ?> versionPropertyType;
    protected TenantIdPropertyType<? super ENTITY, ENTITY, ?, ?> tenantIdPropertyType;
    protected boolean optimisticLockCheckRequired;
    protected boolean autoGeneratedKeysSupported;
    protected boolean executable;
    protected SqlExecutionSkipCause executionSkipCause = SqlExecutionSkipCause.BATCH_TARGET_NONEXISTENT;
    protected List<PreparedSql> sqls;
    protected List<ENTITY> entities;
    protected ENTITY currentEntity;
    protected int batchSize;
    protected SqlLogType sqlLogType;

    public AutoBatchModifyQuery(EntityType<ENTITY> entityType) {
        AssertionUtil.assertNotNull(entityType);
        this.entityType = entityType;
    }

    protected void prepareIdAndVersionPropertyTypes() {
        this.idPropertyTypes = this.entityType.getIdPropertyTypes();
        this.versionPropertyType = this.entityType.getVersionPropertyType();
        this.tenantIdPropertyType = this.entityType.getTenantIdPropertyType();
    }

    protected void validateIdExistent() {
        if (this.idPropertyTypes.isEmpty()) {
            throw new JdbcException((MessageResource)Message.DOMA2022, this.entityType.getName());
        }
    }

    protected void prepareOptions() {
        if (this.queryTimeout <= 0) {
            this.queryTimeout = this.config.getQueryTimeout();
        }
        if (this.batchSize <= 0) {
            this.batchSize = this.config.getBatchSize();
        }
    }

    protected boolean isTargetPropertyName(String name) {
        if (this.includedPropertyNames.length > 0) {
            for (String includedName : this.includedPropertyNames) {
                if (!includedName.equals(name)) continue;
                for (String excludedName : this.excludedPropertyNames) {
                    if (!excludedName.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.excludedPropertyNames.length > 0) {
            for (String excludedName : this.excludedPropertyNames) {
                if (!excludedName.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public void setEntities(Iterable<ENTITY> entities) {
        AssertionUtil.assertNotNull(entities);
        if (entities instanceof Collection) {
            this.entities = new ArrayList<ENTITY>((Collection)entities);
        } else {
            this.entities = new ArrayList<ENTITY>();
            for (ENTITY entity : entities) {
                this.entities.add(entity);
            }
        }
        this.sqls = new ArrayList<PreparedSql>(this.entities.size());
    }

    public List<ENTITY> getEntities() {
        return this.entities;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setIncludedPropertyNames(String ... includedPropertyNames) {
        this.includedPropertyNames = includedPropertyNames;
    }

    public void setExcludedPropertyNames(String ... excludedPropertyNames) {
        this.excludedPropertyNames = excludedPropertyNames;
    }

    public void setSqlLogType(SqlLogType sqlLogType) {
        this.sqlLogType = sqlLogType;
    }

    @Override
    public PreparedSql getSql() {
        return this.sqls.get(0);
    }

    @Override
    public List<PreparedSql> getSqls() {
        return this.sqls;
    }

    @Override
    public boolean isOptimisticLockCheckRequired() {
        return this.optimisticLockCheckRequired;
    }

    @Override
    public boolean isAutoGeneratedKeysSupported() {
        return this.autoGeneratedKeysSupported;
    }

    @Override
    public boolean isExecutable() {
        return this.executable;
    }

    @Override
    public SqlExecutionSkipCause getSqlExecutionSkipCause() {
        return this.executionSkipCause;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public SqlLogType getSqlLogType() {
        return this.sqlLogType;
    }

    public String toString() {
        return this.sqls.toString();
    }
}

