/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.sql.Statement;
import java.util.function.Supplier;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.GenerationType;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.entity.DefaultPropertyType;
import org.seasar.doma.jdbc.entity.EntityPropertyType;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.id.IdGenerationConfig;
import org.seasar.doma.jdbc.id.IdGenerator;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;
import org.seasar.doma.wrapper.NumberWrapper;
import org.seasar.doma.wrapper.NumberWrapperVisitor;
import org.seasar.doma.wrapper.Wrapper;

public class GeneratedIdPropertyType<PARENT, ENTITY extends PARENT, BASIC extends Number, DOMAIN>
extends DefaultPropertyType<PARENT, ENTITY, BASIC, DOMAIN> {
    protected final IdGenerator idGenerator;

    public GeneratedIdPropertyType(Class<ENTITY> entityClass, Class<?> entityPropertyClass, Class<BASIC> basicClass, Supplier<Wrapper<BASIC>> wrapperSupplier, EntityPropertyType<PARENT, BASIC> parentEntityPropertyType, DomainType<BASIC, DOMAIN> domainType, String name, String columnName, NamingType namingType, boolean quoteRequired, IdGenerator idGenerator) {
        super(entityClass, entityPropertyClass, basicClass, wrapperSupplier, parentEntityPropertyType, domainType, name, columnName, namingType, true, true, quoteRequired);
        if (idGenerator == null) {
            throw new DomaNullPointerException("idGenerator");
        }
        this.idGenerator = idGenerator;
    }

    @Override
    public boolean isId() {
        return true;
    }

    public void validateGenerationStrategy(IdGenerationConfig config) {
        Dialect dialect = config.getDialect();
        GenerationType generationType = this.idGenerator.getGenerationType();
        if (!this.isGenerationTypeSupported(generationType, dialect)) {
            EntityType<?> entityType = config.getEntityType();
            throw new JdbcException((MessageResource)Message.DOMA2021, entityType.getName(), this.name, generationType.name(), dialect.getName());
        }
    }

    protected boolean isGenerationTypeSupported(GenerationType generationType, Dialect dialect) {
        switch (generationType) {
            case IDENTITY: {
                return dialect.supportsIdentity();
            }
            case SEQUENCE: {
                return dialect.supportsSequence();
            }
        }
        return true;
    }

    public boolean isIncluded(IdGenerationConfig config) {
        return this.idGenerator.includesIdentityColumn(config);
    }

    public boolean isBatchSupported(IdGenerationConfig config) {
        return this.idGenerator.supportsBatch(config);
    }

    public boolean isAutoGeneratedKeysSupported(IdGenerationConfig config) {
        return this.idGenerator.supportsAutoGeneratedKeys(config);
    }

    public ENTITY preInsert(EntityType<ENTITY> entityType, ENTITY entity, IdGenerationConfig config) {
        return this.setIfNecessary(entityType, entity, () -> this.idGenerator.generatePreInsert(config));
    }

    public ENTITY postInsert(EntityType<ENTITY> entityType, ENTITY entity, IdGenerationConfig config, Statement statement) {
        return this.setIfNecessary(entityType, entity, () -> this.idGenerator.generatePostInsert(config, statement));
    }

    protected ENTITY setIfNecessary(EntityType<ENTITY> entityType, ENTITY entity, Supplier<Long> supplier) {
        return this.modifyIfNecessary(entityType, entity, new ValueSetter(), supplier);
    }

    protected static class ValueSetter
    implements NumberWrapperVisitor<Boolean, Supplier<Long>, Void, RuntimeException> {
        protected ValueSetter() {
        }

        @Override
        public <V extends Number> Boolean visitNumberWrapper(NumberWrapper<V> wrapper, Supplier<Long> valueSupplier, Void q) throws RuntimeException {
            Long value;
            Number currentValue = (Number)wrapper.get();
            if ((currentValue == null || currentValue.intValue() < 0) && (value = valueSupplier.get()) != null) {
                wrapper.set(value);
                return true;
            }
            return false;
        }
    }
}

