/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.lang.reflect.Method;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.Entity;
import org.seasar.doma.internal.Conventions;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.internal.util.MethodUtil;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.entity.EntityType;
import org.seasar.doma.jdbc.entity.EntityTypeNotFoundException;
import org.seasar.doma.message.Message;

public final class EntityTypeFactory {
    public static <E> EntityType<E> getEntityType(Class<E> entityClass, ClassHelper classHelper) {
        if (entityClass == null) {
            throw new DomaNullPointerException("entityClass");
        }
        if (classHelper == null) {
            throw new DomaNullPointerException("classHelper");
        }
        if (!entityClass.isAnnotationPresent(Entity.class)) {
            throw new DomaIllegalArgumentException("entityClass", Message.DOMA2206.getMessage("entityClass"));
        }
        String entityTypeClassName = Conventions.toFullMetaName(entityClass.getName());
        try {
            Class clazz = classHelper.forName(entityTypeClassName);
            Method method = ClassUtil.getMethod(clazz, "getSingletonInternal", new Class[0]);
            return (EntityType)MethodUtil.invoke(method, null, new Object[0]);
        }
        catch (WrapException e) {
            throw new EntityTypeNotFoundException(e.getCause(), entityClass.getName(), entityTypeClassName);
        }
        catch (Exception e) {
            throw new EntityTypeNotFoundException(e.getCause(), entityClass.getName(), entityTypeClassName);
        }
    }
}

