/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.entity;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.jdbc.entity.PropertyField;
import org.seasar.doma.jdbc.entity.EntityPropertyType;

public class EmbeddedPropertyType<ENTITY, EMBEDDABLE> {
    protected final String name;
    protected final List<EntityPropertyType<ENTITY, ?>> embeddablePropertyTypes;
    protected final Map<String, EntityPropertyType<ENTITY, ?>> embeddablePropertyTypeMap;
    protected final PropertyField<ENTITY> field;

    public EmbeddedPropertyType(String name, Class<ENTITY> entityClass, List<EntityPropertyType<ENTITY, ?>> embeddablePropertyType) {
        if (name == null) {
            throw new DomaNullPointerException("name");
        }
        if (entityClass == null) {
            throw new DomaNullPointerException("entityClass");
        }
        if (embeddablePropertyType == null) {
            throw new DomaNullPointerException("embeddablePropertyType");
        }
        this.name = name;
        this.embeddablePropertyTypes = embeddablePropertyType;
        this.embeddablePropertyTypeMap = this.embeddablePropertyTypes.stream().collect(Collectors.toMap(EntityPropertyType::getName, Function.identity()));
        this.field = new PropertyField<ENTITY>(name, entityClass);
    }

    public List<EntityPropertyType<ENTITY, ?>> getEmbeddablePropertyTypes() {
        return this.embeddablePropertyTypes;
    }

    public Map<String, EntityPropertyType<ENTITY, ?>> getEmbeddablePropertyTypeMap() {
        return this.embeddablePropertyTypeMap;
    }

    public void save(ENTITY entity, EMBEDDABLE value) {
        this.field.setValue(entity, value);
    }
}

