/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.domain;

import java.util.Optional;
import java.util.function.Supplier;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.wrapper.Wrapper;

public abstract class AbstractDomainType<BASIC, DOMAIN>
implements DomainType<BASIC, DOMAIN> {
    protected final Supplier<Wrapper<BASIC>> wrapperSupplier;

    protected AbstractDomainType(Supplier<Wrapper<BASIC>> wrapperSupplier) {
        AssertionUtil.assertNotNull(wrapperSupplier);
        this.wrapperSupplier = wrapperSupplier;
    }

    protected abstract DOMAIN newDomain(BASIC var1);

    protected abstract BASIC getBasicValue(DOMAIN var1);

    public DomainScalar createScalar() {
        return new DomainScalar(this.wrapperSupplier.get());
    }

    public DomainScalar createScalar(DOMAIN value) {
        Wrapper<BASIC> wrapper = this.wrapperSupplier.get();
        wrapper.set(this.getBasicValue(value));
        return new DomainScalar(wrapper);
    }

    public OptionalDomainScalar createOptionalScalar() {
        return new OptionalDomainScalar(this.wrapperSupplier.get());
    }

    public OptionalDomainScalar createOptionalScalar(DOMAIN value) {
        Wrapper<BASIC> wrapper = this.wrapperSupplier.get();
        wrapper.set(this.getBasicValue(value));
        return new OptionalDomainScalar(wrapper);
    }

    protected class OptionalDomainScalar
    implements Scalar<BASIC, Optional<DOMAIN>> {
        protected final Wrapper<BASIC> wrapper;

        protected OptionalDomainScalar(Wrapper<BASIC> wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public Optional<Class<?>> getDomainClass() {
            Class clazz = AbstractDomainType.this.getDomainClass();
            return Optional.of(clazz);
        }

        @Override
        public Optional<DOMAIN> cast(Object value) {
            return (Optional)value;
        }

        @Override
        public Optional<DOMAIN> get() {
            Object value = this.wrapper.get();
            if (value == null && !AbstractDomainType.this.getBasicClass().isPrimitive()) {
                return this.getDefaultInternal();
            }
            return Optional.of(AbstractDomainType.this.newDomain(value));
        }

        @Override
        public Optional<DOMAIN> getDefault() {
            return this.getDefaultInternal();
        }

        protected Optional<DOMAIN> getDefaultInternal() {
            return Optional.empty();
        }

        @Override
        public void set(Optional<DOMAIN> optional) {
            if (optional != null && optional.isPresent()) {
                this.wrapper.set(AbstractDomainType.this.getBasicValue(optional.get()));
            } else {
                this.wrapper.set(null);
            }
        }

        @Override
        public Wrapper<BASIC> getWrapper() {
            return this.wrapper;
        }
    }

    protected class DomainScalar
    implements Scalar<BASIC, DOMAIN> {
        protected final Wrapper<BASIC> wrapper;

        protected DomainScalar(Wrapper<BASIC> wrapper) {
            this.wrapper = wrapper;
        }

        @Override
        public Optional<Class<?>> getDomainClass() {
            Class c = AbstractDomainType.this.getDomainClass();
            return Optional.of(c);
        }

        @Override
        public DOMAIN cast(Object value) {
            return AbstractDomainType.this.getDomainClass().cast(value);
        }

        @Override
        public DOMAIN get() {
            return AbstractDomainType.this.newDomain(this.wrapper.get());
        }

        @Override
        public DOMAIN getDefault() {
            return null;
        }

        @Override
        public void set(DOMAIN domain) {
            Object value = AbstractDomainType.this.getBasicValue(domain);
            this.wrapper.set(value);
        }

        @Override
        public Wrapper<BASIC> getWrapper() {
            return this.wrapper;
        }
    }
}

