/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc.dialect;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.expr.ExpressionFunctions;
import org.seasar.doma.internal.jdbc.dialect.MysqlCountCalculatingTransformer;
import org.seasar.doma.internal.jdbc.dialect.MysqlCountGettingTransformer;
import org.seasar.doma.internal.jdbc.dialect.MysqlForUpdateTransformer;
import org.seasar.doma.internal.jdbc.dialect.MysqlPagingTransformer;
import org.seasar.doma.jdbc.JdbcMappingVisitor;
import org.seasar.doma.jdbc.ScriptBlockContext;
import org.seasar.doma.jdbc.SelectForUpdateType;
import org.seasar.doma.jdbc.SqlLogFormattingVisitor;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.StandardDialect;

public class MysqlDialect
extends StandardDialect {
    protected static final Set<Integer> UNIQUE_CONSTRAINT_VIOLATION_ERROR_CODES = new HashSet<Integer>(Arrays.asList(1022, 1062));
    protected static final char OPEN_QUOTE = '`';
    protected static final char CLOSE_QUOTE = '`';

    public MysqlDialect() {
        this(new MysqlJdbcMappingVisitor(), new MysqlSqlLogFormattingVisitor(), new MysqlExpressionFunctions());
    }

    public MysqlDialect(JdbcMappingVisitor jdbcMappingVisitor) {
        this(jdbcMappingVisitor, new MysqlSqlLogFormattingVisitor(), new MysqlExpressionFunctions());
    }

    public MysqlDialect(SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(new MysqlJdbcMappingVisitor(), sqlLogFormattingVisitor, new MysqlExpressionFunctions());
    }

    public MysqlDialect(ExpressionFunctions expressionFunctions) {
        this(new MysqlJdbcMappingVisitor(), new MysqlSqlLogFormattingVisitor(), expressionFunctions);
    }

    public MysqlDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor) {
        this(jdbcMappingVisitor, sqlLogFormattingVisitor, new MysqlExpressionFunctions());
    }

    public MysqlDialect(JdbcMappingVisitor jdbcMappingVisitor, SqlLogFormattingVisitor sqlLogFormattingVisitor, ExpressionFunctions expressionFunctions) {
        super(jdbcMappingVisitor, sqlLogFormattingVisitor, expressionFunctions);
    }

    @Override
    public String getName() {
        return "mysql";
    }

    @Override
    public boolean isUniqueConstraintViolated(SQLException sqlException) {
        if (sqlException == null) {
            throw new DomaNullPointerException("sqlException");
        }
        int code = this.getErrorCode(sqlException);
        return UNIQUE_CONSTRAINT_VIOLATION_ERROR_CODES.contains(code);
    }

    @Override
    public boolean supportsAutoGeneratedKeys() {
        return true;
    }

    @Override
    public boolean supportsIdentity() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate(SelectForUpdateType type, boolean withTargets) {
        return type == SelectForUpdateType.NORMAL && !withTargets;
    }

    @Override
    protected SqlNode toCountCalculatingSqlNode(SqlNode sqlNode) {
        MysqlCountCalculatingTransformer transformer = new MysqlCountCalculatingTransformer();
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toPagingSqlNode(SqlNode sqlNode, long offset, long limit) {
        MysqlPagingTransformer transformer = new MysqlPagingTransformer(offset, limit);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toForUpdateSqlNode(SqlNode sqlNode, SelectForUpdateType forUpdateType, int waitSeconds, String ... aliases) {
        MysqlForUpdateTransformer transformer = new MysqlForUpdateTransformer(forUpdateType, waitSeconds, aliases);
        return transformer.transform(sqlNode);
    }

    @Override
    protected SqlNode toCountGettingSqlNode(SqlNode sqlNode) {
        MysqlCountGettingTransformer transformer = new MysqlCountGettingTransformer();
        return transformer.transform(sqlNode);
    }

    @Override
    public String getScriptBlockDelimiter() {
        return "/";
    }

    @Override
    public ScriptBlockContext createScriptBlockContext() {
        return new MysqlScriptBlockContext();
    }

    @Override
    public String applyQuote(String name) {
        return '`' + name + '`';
    }

    public static class MysqlScriptBlockContext
    extends StandardDialect.StandardScriptBlockContext {
        protected MysqlScriptBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("declare"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("begin"));
        }
    }

    public static class MysqlExpressionFunctions
    extends StandardDialect.StandardExpressionFunctions {
        public MysqlExpressionFunctions() {
        }

        public MysqlExpressionFunctions(char[] wildcards) {
            super(wildcards);
        }

        protected MysqlExpressionFunctions(char escapeChar, char[] wildcards) {
            super(escapeChar, wildcards);
        }
    }

    public static class MysqlSqlLogFormattingVisitor
    extends StandardDialect.StandardSqlLogFormattingVisitor {
    }

    public static class MysqlJdbcMappingVisitor
    extends StandardDialect.StandardJdbcMappingVisitor {
    }
}

