/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.jdbc;

import java.lang.reflect.Method;
import org.seasar.doma.DomaIllegalArgumentException;
import org.seasar.doma.DomaNullPointerException;
import org.seasar.doma.internal.WrapException;
import org.seasar.doma.internal.jdbc.sql.SqlParser;
import org.seasar.doma.internal.jdbc.util.SqlFileUtil;
import org.seasar.doma.internal.util.ResourceUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.SqlFile;
import org.seasar.doma.jdbc.SqlFileNotFoundException;
import org.seasar.doma.jdbc.SqlFileRepository;
import org.seasar.doma.jdbc.SqlNode;
import org.seasar.doma.jdbc.dialect.Dialect;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public abstract class AbstractSqlFileRepository
implements SqlFileRepository {
    @Override
    public final SqlFile getSqlFile(Method method, String path, Dialect dialect) {
        if (method == null) {
            throw new DomaNullPointerException("method");
        }
        if (path == null) {
            throw new DomaNullPointerException("path");
        }
        if (!path.startsWith("META-INF/")) {
            throw new DomaIllegalArgumentException("path", "The path does not start with 'META-INF/'");
        }
        if (!path.endsWith(".sql")) {
            throw new DomaIllegalArgumentException("path", "The path does not end with '.sql'");
        }
        if (dialect == null) {
            throw new DomaNullPointerException("dialect");
        }
        return this.getSqlFileWithCacheControl(method, path, dialect);
    }

    protected abstract SqlFile getSqlFileWithCacheControl(Method var1, String var2, Dialect var3);

    protected final SqlFile createSqlFile(String path, Dialect dialect) {
        String primaryPath = this.getPrimaryPath(path, dialect);
        String sql = this.getSql(primaryPath);
        if (sql != null) {
            SqlNode sqlNode = this.parse(sql);
            return new SqlFile(primaryPath, sql, sqlNode);
        }
        sql = this.getSql(path);
        if (sql != null) {
            SqlNode sqlNode = this.parse(sql);
            return new SqlFile(path, sql, sqlNode);
        }
        throw new SqlFileNotFoundException(path);
    }

    protected final String getPrimaryPath(String path, Dialect dialect) {
        return SqlFileUtil.convertToDbmsSpecificPath(path, dialect);
    }

    protected final SqlNode parse(String sql) {
        SqlParser parser = new SqlParser(sql);
        return parser.parse();
    }

    protected final String getSql(String path) {
        try {
            return ResourceUtil.getResourceAsString(path);
        }
        catch (WrapException e) {
            Throwable cause = e.getCause();
            throw new JdbcException((MessageResource)Message.DOMA2010, cause, path, cause);
        }
    }
}

