/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.scalar;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Supplier;
import org.seasar.doma.Domain;
import org.seasar.doma.internal.jdbc.scalar.BasicScalar;
import org.seasar.doma.internal.jdbc.scalar.OptionalBasicScalar;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.internal.jdbc.scalar.ScalarException;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.ClassUtil;
import org.seasar.doma.jdbc.ClassHelper;
import org.seasar.doma.jdbc.domain.DomainType;
import org.seasar.doma.jdbc.domain.DomainTypeFactory;
import org.seasar.doma.message.Message;
import org.seasar.doma.wrapper.ArrayWrapper;
import org.seasar.doma.wrapper.BigDecimalWrapper;
import org.seasar.doma.wrapper.BigIntegerWrapper;
import org.seasar.doma.wrapper.BlobWrapper;
import org.seasar.doma.wrapper.BooleanWrapper;
import org.seasar.doma.wrapper.ByteWrapper;
import org.seasar.doma.wrapper.BytesWrapper;
import org.seasar.doma.wrapper.ClobWrapper;
import org.seasar.doma.wrapper.DateWrapper;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.EnumWrapper;
import org.seasar.doma.wrapper.FloatWrapper;
import org.seasar.doma.wrapper.IntegerWrapper;
import org.seasar.doma.wrapper.LocalDateTimeWrapper;
import org.seasar.doma.wrapper.LocalDateWrapper;
import org.seasar.doma.wrapper.LocalTimeWrapper;
import org.seasar.doma.wrapper.LongWrapper;
import org.seasar.doma.wrapper.NClobWrapper;
import org.seasar.doma.wrapper.ObjectWrapper;
import org.seasar.doma.wrapper.SQLXMLWrapper;
import org.seasar.doma.wrapper.ShortWrapper;
import org.seasar.doma.wrapper.StringWrapper;
import org.seasar.doma.wrapper.TimeWrapper;
import org.seasar.doma.wrapper.TimestampWrapper;
import org.seasar.doma.wrapper.UtilDateWrapper;
import org.seasar.doma.wrapper.Wrapper;

public final class Scalars {
    public static Supplier<Scalar<?, ?>> wrap(Object value, Class<?> valueClass, boolean optional, ClassHelper classHelper) {
        AssertionUtil.assertNotNull(valueClass, (Object)classHelper);
        Class<?> boxedClass = ClassUtil.toBoxedPrimitiveTypeIfPossible(valueClass);
        AssertionUtil.assertTrue(value == null || boxedClass.isInstance(value), new Object[0]);
        if (Scalar.class.isAssignableFrom(boxedClass)) {
            return () -> (Scalar)value;
        }
        Supplier<Scalar<?, ?>> result = Scalars.wrapBasicObject(value, boxedClass, optional, valueClass.isPrimitive());
        if (result == null && (result = Scalars.wrapDomainObject(value, boxedClass, optional, classHelper)) == null && (result = Scalars.wrapEnumObject(value, boxedClass, optional)) == null) {
            throw new ScalarException(Message.DOMA1007, valueClass.getName(), value);
        }
        return result;
    }

    protected static Supplier<Scalar<?, ?>> wrapBasicObject(Object value, Class<?> valueClass, boolean optional, boolean primitive) {
        AssertionUtil.assertNotNull(valueClass);
        if (valueClass == String.class) {
            Supplier supplier = () -> new StringWrapper((String)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Integer.class) {
            Supplier supplier = () -> new IntegerWrapper((Integer)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Long.class) {
            Supplier supplier = () -> new LongWrapper((Long)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == BigDecimal.class) {
            Supplier supplier = () -> new BigDecimalWrapper((BigDecimal)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == java.util.Date.class) {
            Supplier supplier = () -> new UtilDateWrapper((java.util.Date)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == LocalDate.class) {
            Supplier supplier = () -> new LocalDateWrapper((LocalDate)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == LocalTime.class) {
            Supplier supplier = () -> new LocalTimeWrapper((LocalTime)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == LocalDateTime.class) {
            Supplier supplier = () -> new LocalDateTimeWrapper((LocalDateTime)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Date.class) {
            Supplier supplier = () -> new DateWrapper((Date)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Timestamp.class) {
            Supplier supplier = () -> new TimestampWrapper((Timestamp)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Time.class) {
            Supplier supplier = () -> new TimeWrapper((Time)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Boolean.class) {
            Supplier supplier = () -> new BooleanWrapper((Boolean)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Array.class) {
            Supplier supplier = () -> new ArrayWrapper((Array)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == BigInteger.class) {
            Supplier supplier = () -> new BigIntegerWrapper((BigInteger)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Blob.class) {
            Supplier supplier = () -> new BlobWrapper((Blob)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == byte[].class) {
            Supplier supplier = () -> new BytesWrapper((byte[])value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Byte.class) {
            Supplier supplier = () -> new ByteWrapper((Byte)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Clob.class) {
            Supplier supplier = () -> new ClobWrapper((Clob)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Double.class) {
            Supplier supplier = () -> new DoubleWrapper((Double)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Float.class) {
            Supplier supplier = () -> new FloatWrapper((Float)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == NClob.class) {
            Supplier supplier = () -> new NClobWrapper((NClob)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Short.class) {
            Supplier supplier = () -> new ShortWrapper((Short)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == SQLXML.class) {
            Supplier supplier = () -> new SQLXMLWrapper((SQLXML)value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        if (valueClass == Object.class) {
            Supplier supplier = () -> new ObjectWrapper(value);
            return Scalars.createBasicScalarSupplier(supplier, optional, primitive);
        }
        return null;
    }

    protected static <BASIC> Supplier<Scalar<?, ?>> createBasicScalarSupplier(Supplier<Wrapper<BASIC>> wrapperSupplier, boolean optional, boolean primitive) {
        if (optional) {
            return () -> new OptionalBasicScalar(wrapperSupplier);
        }
        return () -> new BasicScalar(wrapperSupplier, primitive);
    }

    protected static Supplier<Scalar<?, ?>> wrapEnumObject(Object value, Class<?> valueClass, boolean optional) {
        AssertionUtil.assertNotNull(valueClass);
        if (valueClass.isEnum() || Enum.class.isAssignableFrom(valueClass)) {
            Supplier<EnumWrapper> supplier = () -> new EnumWrapper<Enum>(valueClass, (Enum)value);
            if (optional) {
                return () -> new OptionalBasicScalar(supplier);
            }
            return () -> new BasicScalar(supplier, false);
        }
        return null;
    }

    protected static <BASIC, DOMAIN> Supplier<Scalar<?, ?>> wrapDomainObject(Object value, Class<DOMAIN> valueClass, boolean optional, ClassHelper classHelper) {
        DomainType domainType = valueClass.isAnnotationPresent(Domain.class) ? DomainTypeFactory.getDomainType(valueClass, classHelper) : DomainTypeFactory.getExternalDomainType(valueClass, classHelper);
        if (domainType == null) {
            return null;
        }
        Object domain = valueClass.cast(value);
        if (optional) {
            return () -> domainType.createOptionalScalar(domain);
        }
        return () -> domainType.createScalar(domain);
    }
}

