/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.scalar;

import java.util.Optional;
import java.util.OptionalDouble;
import org.seasar.doma.internal.jdbc.scalar.Scalar;
import org.seasar.doma.wrapper.DoubleWrapper;
import org.seasar.doma.wrapper.Wrapper;

public class OptionalDoubleScalar
implements Scalar<Double, OptionalDouble> {
    protected final Wrapper<Double> wrapper = new DoubleWrapper();

    @Override
    public Optional<Class<?>> getDomainClass() {
        return Optional.empty();
    }

    @Override
    public OptionalDouble cast(Object value) {
        return (OptionalDouble)value;
    }

    @Override
    public OptionalDouble get() {
        Double value = this.wrapper.get();
        return value != null ? OptionalDouble.of(value) : OptionalDouble.empty();
    }

    @Override
    public OptionalDouble getDefault() {
        return OptionalDouble.empty();
    }

    @Override
    public void set(OptionalDouble optional) {
        if (optional != null && optional.isPresent()) {
            this.wrapper.set(optional.getAsDouble());
        } else {
            this.wrapper.set(null);
        }
    }

    @Override
    public Wrapper<Double> getWrapper() {
        return this.wrapper;
    }
}

