/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.jdbc.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.seasar.doma.internal.Constants;
import org.seasar.doma.internal.jdbc.command.ScriptTokenType;
import org.seasar.doma.internal.jdbc.command.ScriptTokenizer;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.internal.util.IOUtil;
import org.seasar.doma.jdbc.JdbcException;
import org.seasar.doma.jdbc.ScriptBlockContext;
import org.seasar.doma.jdbc.query.ScriptQuery;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class ScriptReader {
    protected ScriptQuery query;
    protected ScriptTokenizer tokenizer;
    protected BufferedReader reader;
    protected int lineCount;
    protected int lineNumber;
    protected boolean endOfFile;
    protected boolean endOfLine = true;

    public ScriptReader(ScriptQuery query) {
        AssertionUtil.assertNotNull(query);
        this.query = query;
        this.tokenizer = new ScriptTokenizer(query.getBlockDelimiter());
    }

    public String readSql() {
        if (this.endOfFile) {
            return null;
        }
        try {
            if (this.reader == null) {
                this.reader = this.createBufferedReader();
            }
            SqlBuilder builder = new SqlBuilder();
            block2: while (true) {
                if (this.endOfLine) {
                    ++this.lineCount;
                    this.tokenizer.addLine(this.reader.readLine());
                    builder.notifyLineChanged();
                }
                while (true) {
                    builder.build(this.tokenizer.nextToken(), this.tokenizer.getToken());
                    if (builder.isTokenRequired()) continue;
                    if (builder.isLineRequired()) continue block2;
                    if (builder.isCompleted()) {
                        return builder.getSql();
                    }
                    AssertionUtil.assertUnreachable();
                }
                break;
            }
        }
        catch (IOException e) {
            throw new JdbcException((MessageResource)Message.DOMA2078, (Throwable)e, this.query.getScriptFilePath(), e);
        }
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void close() {
        IOUtil.close(this.reader);
    }

    protected BufferedReader createBufferedReader() throws IOException {
        InputStream inputStream = this.query.getScriptFileUrl().openStream();
        return new BufferedReader(new InputStreamReader(inputStream, Constants.UTF_8));
    }

    protected class SqlBuilder {
        protected boolean tokenRequired;
        protected boolean lineRequired;
        protected boolean completed;
        protected StringBuilder buf = new StringBuilder(300);
        protected List<String> wordList = new ArrayList<String>();
        protected ScriptBlockContext sqlBlockContext;
        protected boolean lineChanged;

        protected SqlBuilder() {
            this.sqlBlockContext = ScriptReader.this.query.getConfig().getDialect().createScriptBlockContext();
        }

        protected void build(ScriptTokenType tokenType, String token) {
            this.reset();
            if (this.buf.length() == 0) {
                ScriptReader.this.lineNumber = ScriptReader.this.lineCount;
            }
            switch (tokenType) {
                case WORD: {
                    this.appendWord(token);
                }
                case QUOTE: 
                case OTHER: {
                    this.appendToken(token);
                    this.requireToken();
                    break;
                }
                case END_OF_LINE: {
                    ScriptReader.this.endOfLine = true;
                    this.requireLine();
                    break;
                }
                case STATEMENT_DELIMITER: {
                    if (this.isInBlock()) {
                        this.appendToken(token);
                        this.requireToken();
                        break;
                    }
                    this.complete();
                    break;
                }
                case BLOCK_DELIMITER: {
                    if (this.isSqlEmpty()) {
                        this.requireToken();
                        break;
                    }
                    this.complete();
                    break;
                }
                case END_OF_FILE: {
                    ScriptReader.this.endOfFile = true;
                    this.complete();
                    break;
                }
                default: {
                    this.requireToken();
                }
            }
        }

        protected void reset() {
            ScriptReader.this.endOfLine = false;
            this.requireToken();
        }

        protected boolean isTokenRequired() {
            return this.tokenRequired;
        }

        protected void requireToken() {
            this.tokenRequired = true;
            this.lineRequired = false;
            this.completed = false;
        }

        protected boolean isLineRequired() {
            return this.lineRequired;
        }

        protected void requireLine() {
            this.lineRequired = true;
            this.tokenRequired = false;
            this.completed = false;
        }

        protected boolean isCompleted() {
            return this.completed;
        }

        protected void complete() {
            this.completed = true;
            this.tokenRequired = false;
            this.lineRequired = false;
        }

        protected void appendWord(String word) {
            this.sqlBlockContext.addKeyword(word);
        }

        protected void appendToken(String token) {
            this.appendWhitespaceIfNecessary();
            this.buf.append(token);
        }

        protected void appendWhitespaceIfNecessary() {
            char lastChar;
            if (!this.lineChanged) {
                return;
            }
            if (this.buf.length() > 0 && !Character.isWhitespace(lastChar = this.buf.charAt(this.buf.length() - 1))) {
                this.buf.append(' ');
            }
            this.lineChanged = false;
        }

        protected void notifyLineChanged() {
            this.lineChanged = true;
        }

        protected boolean isInBlock() {
            return this.sqlBlockContext.isInBlock();
        }

        protected boolean isSqlEmpty() {
            return this.buf.toString().trim().length() == 0;
        }

        protected String getSql() {
            if (!this.completed) {
                AssertionUtil.assertUnreachable();
            }
            String sql = this.buf.toString().trim();
            return ScriptReader.this.endOfFile && sql.length() == 0 ? null : sql;
        }
    }
}

