/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.util;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.seasar.doma.ParameterName;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public final class ElementUtil {
    public static String getPackageName(Element element, ProcessingEnvironment env) {
        PackageElement packageElement = env.getElementUtils().getPackageOf(element);
        return packageElement.getQualifiedName().toString();
    }

    public static String getBinaryName(TypeElement typeElement, ProcessingEnvironment env) {
        return env.getElementUtils().getBinaryName(typeElement).toString();
    }

    public static String getPackageExcludedBinaryName(TypeElement typeElement, ProcessingEnvironment env) {
        String binaryName = env.getElementUtils().getBinaryName(typeElement).toString();
        int pos = binaryName.lastIndexOf(46);
        if (pos < 0) {
            return binaryName;
        }
        return binaryName.substring(pos + 1);
    }

    public static String getParameterName(VariableElement variableElement) {
        AssertionUtil.assertNotNull(variableElement);
        ParameterName parameterName = variableElement.getAnnotation(ParameterName.class);
        if (parameterName != null && !parameterName.value().isEmpty()) {
            return parameterName.value();
        }
        return variableElement.getSimpleName().toString();
    }

    public static boolean isEnclosing(Element enclosingElement, Element enclosedElement) {
        AssertionUtil.assertNotNull((Object)enclosingElement, (Object)enclosedElement);
        if (enclosingElement.equals(enclosedElement)) {
            return true;
        }
        for (Element e = enclosedElement; e != null; e = e.getEnclosingElement()) {
            if (!enclosingElement.equals(e)) continue;
            return true;
        }
        return false;
    }

    public static ExecutableType toExecutableType(ExecutableElement element, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)element, (Object)env);
        return element.asType().accept(new SimpleTypeVisitor8<ExecutableType, Void>(){

            @Override
            public ExecutableType visitExecutable(ExecutableType t, Void p) {
                return t;
            }
        }, null);
    }

    public static TypeElement toTypeElement(Element element, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)element, (Object)env);
        return element.accept(new SimpleElementVisitor8<TypeElement, Void>(){

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    public static TypeElement getTypeElement(String className, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)className, (Object)env);
        String[] parts = className.split("\\$");
        if (parts.length > 1) {
            TypeElement topElement = ElementUtil.getTypeElement(parts[0], env);
            if (topElement == null) {
                return null;
            }
            return ElementUtil.getEnclosedTypeElement(topElement, Arrays.asList(parts).subList(1, parts.length), env);
        }
        Elements elements = env.getElementUtils();
        try {
            return elements.getTypeElement(className);
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    public static TypeElement getTypeElement(Class<?> clazz, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(clazz, (Object)env);
        return env.getElementUtils().getTypeElement(clazz.getCanonicalName());
    }

    public static TypeElement getEnclosedTypeElement(TypeElement typeElement, List<String> enclosedNames, ProcessingEnvironment env) {
        TypeElement enclosing = typeElement;
        block0: for (String enclosedName : enclosedNames) {
            for (TypeElement enclosed : ElementFilter.typesIn(enclosing.getEnclosedElements())) {
                if (!enclosed.getSimpleName().contentEquals(enclosedName)) continue;
                enclosing = enclosed;
                continue block0;
            }
        }
        return typeElement != enclosing ? enclosing : null;
    }

    public static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass, ProcessingEnvironment env) {
        return ElementUtil.getAnnotationMirrorInternal(element, env, type -> TypeMirrorUtil.isSameType((TypeMirror)type, annotationClass, env));
    }

    public static AnnotationMirror getAnnotationMirror(Element element, String annotationClassName, ProcessingEnvironment env) {
        return ElementUtil.getAnnotationMirrorInternal(element, env, type -> TypeMirrorUtil.getClassName(type, env).equals(annotationClassName));
    }

    protected static AnnotationMirror getAnnotationMirrorInternal(Element element, ProcessingEnvironment env, Predicate<DeclaredType> predicate) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            DeclaredType annotationType = annotationMirror.getAnnotationType();
            if (!predicate.test(annotationType)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static ExecutableElement getNoArgConstructor(TypeElement typeElement, ProcessingEnvironment env) {
        for (ExecutableElement constructor : ElementFilter.constructorsIn(typeElement.getEnclosedElements())) {
            if (!constructor.getParameters().isEmpty()) continue;
            return constructor;
        }
        return null;
    }
}

