/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.FetchType;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.Select;
import org.seasar.doma.SelectType;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlLogType;

public class SelectMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue strategy;
    protected AnnotationValue fetch;
    protected AnnotationValue ensureResult;
    protected AnnotationValue ensureResultMapping;
    protected AnnotationValue queryTimeout;
    protected AnnotationValue fetchSize;
    protected AnnotationValue maxRows;
    protected AnnotationValue mapKeyNaming;
    protected AnnotationValue sqlLog;

    protected SelectMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
    }

    public AnnotationValue getStrategy() {
        return this.strategy;
    }

    public AnnotationValue getFetch() {
        return this.fetch;
    }

    public AnnotationValue getEnsureResult() {
        return this.ensureResult;
    }

    public AnnotationValue getEnsureResultMapping() {
        return this.ensureResultMapping;
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public AnnotationValue getFetchSize() {
        return this.fetchSize;
    }

    public AnnotationValue getMaxRows() {
        return this.maxRows;
    }

    public AnnotationValue getMapKeyNaming() {
        return this.mapKeyNaming;
    }

    public AnnotationValue getSqlLog() {
        return this.sqlLog;
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException("queryTimeout");
        }
        return value;
    }

    public int getFetchSizeValue() {
        Integer value = AnnotationValueUtil.toInteger(this.fetchSize);
        if (value == null) {
            throw new AptIllegalStateException("fetchSize");
        }
        return value;
    }

    public int getMaxRowsValue() {
        Integer value = AnnotationValueUtil.toInteger(this.maxRows);
        if (value == null) {
            throw new AptIllegalStateException("maxRows");
        }
        return value;
    }

    public SelectType getStrategyValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.strategy);
        if (enumConstant == null) {
            throw new AptIllegalStateException("strategy");
        }
        return SelectType.valueOf(enumConstant.getSimpleName().toString());
    }

    public FetchType getFetchValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.fetch);
        if (enumConstant == null) {
            throw new AptIllegalStateException("fetch");
        }
        return FetchType.valueOf(enumConstant.getSimpleName().toString());
    }

    public boolean getEnsureResultValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.ensureResult);
        if (value == null) {
            throw new AptIllegalStateException("ensureResult");
        }
        return value;
    }

    public boolean getEnsureResultMappingValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.ensureResultMapping);
        if (value == null) {
            throw new AptIllegalStateException("ensureResultMapping");
        }
        return value;
    }

    public MapKeyNamingType getMapKeyNamingValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.mapKeyNaming);
        if (enumConstant == null) {
            throw new AptIllegalStateException("mapKeyNaming");
        }
        return MapKeyNamingType.valueOf(enumConstant.getSimpleName().toString());
    }

    public SqlLogType getSqlLogValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.sqlLog);
        if (enumConstant == null) {
            throw new AptIllegalStateException("sqlLog");
        }
        return SqlLogType.valueOf(enumConstant.getSimpleName().toString());
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public static SelectMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror((Element)method, Select.class, env);
        if (annotationMirror == null) {
            return null;
        }
        SelectMirror result = new SelectMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("strategy".equals(name)) {
                result.strategy = value;
                continue;
            }
            if ("fetch".equals(name)) {
                result.fetch = value;
                continue;
            }
            if ("ensureResult".equals(name)) {
                result.ensureResult = value;
                continue;
            }
            if ("ensureResultMapping".equals(name)) {
                result.ensureResultMapping = value;
                continue;
            }
            if ("queryTimeout".equals(name)) {
                result.queryTimeout = value;
                continue;
            }
            if ("fetchSize".equals(name)) {
                result.fetchSize = value;
                continue;
            }
            if ("maxRows".equals(name)) {
                result.maxRows = value;
                continue;
            }
            if ("mapKeyNaming".equals(name)) {
                result.mapKeyNaming = value;
                continue;
            }
            if (!"sqlLog".equals(name)) continue;
            result.sqlLog = value;
        }
        return result;
    }
}

