/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.Script;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlLogType;

public class ScriptMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue haltOnError;
    protected AnnotationValue blockDelimiter;
    protected AnnotationValue sqlLog;

    protected ScriptMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
    }

    public AnnotationValue getHaltOnError() {
        return this.haltOnError;
    }

    public AnnotationValue getBlockDelimiter() {
        return this.blockDelimiter;
    }

    public AnnotationValue getSqlLog() {
        return this.sqlLog;
    }

    public boolean getHaltOnErrorValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.haltOnError);
        if (value == null) {
            throw new AptIllegalStateException("haltOnError");
        }
        return value;
    }

    public String getBlockDelimiterValue() {
        String value = AnnotationValueUtil.toString(this.blockDelimiter);
        if (value == null) {
            throw new AptIllegalStateException("blockDelimiter");
        }
        return value;
    }

    public SqlLogType getSqlLogValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.sqlLog);
        if (enumConstant == null) {
            throw new AptIllegalStateException("sqlLog");
        }
        return SqlLogType.valueOf(enumConstant.getSimpleName().toString());
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public static ScriptMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror((Element)method, Script.class, env);
        if (annotationMirror == null) {
            return null;
        }
        ScriptMirror result = new ScriptMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("haltOnError".equals(name)) {
                result.haltOnError = value;
                continue;
            }
            if ("blockDelimiter".equals(name)) {
                result.blockDelimiter = value;
                continue;
            }
            if (!"sqlLog".equals(name)) continue;
            result.sqlLog = value;
        }
        return result;
    }
}

