/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.ResultSet;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class ResultSetMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue ensureResultMapping;

    protected ResultSetMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
    }

    public static ResultSetMirror newInstance(VariableElement param, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror((Element)param, ResultSet.class, env);
        if (annotationMirror == null) {
            return null;
        }
        ResultSetMirror result = new ResultSetMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if (!"ensureResultMapping".equals(name)) continue;
            result.ensureResultMapping = value;
        }
        return result;
    }

    public AnnotationValue getEnsureResultMapping() {
        return this.ensureResultMapping;
    }

    public boolean getEnsureResultMappingValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.ensureResultMapping);
        if (value == null) {
            throw new AptIllegalStateException("ensureResultMapping");
        }
        return value;
    }
}

