/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.Function;
import org.seasar.doma.MapKeyNamingType;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.SqlLogType;

public class FunctionMirror {
    protected final AnnotationMirror annotationMirror;
    protected final String defaultName;
    protected AnnotationValue catalog;
    protected AnnotationValue schema;
    protected AnnotationValue name;
    protected AnnotationValue quote;
    protected AnnotationValue queryTimeout;
    protected AnnotationValue mapKeyNaming;
    protected AnnotationValue ensureResultMapping;
    protected AnnotationValue sqlLog;

    protected FunctionMirror(AnnotationMirror annotationMirror, String defaultName) {
        AssertionUtil.assertNotNull((Object)annotationMirror, (Object)defaultName);
        this.annotationMirror = annotationMirror;
        this.defaultName = defaultName;
    }

    public static FunctionMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror((Element)method, Function.class, env);
        if (annotationMirror == null) {
            return null;
        }
        FunctionMirror result = new FunctionMirror(annotationMirror, method.getSimpleName().toString());
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("catalog".equals(name)) {
                result.catalog = value;
                continue;
            }
            if ("schema".equals(name)) {
                result.schema = value;
                continue;
            }
            if ("name".equals(name)) {
                result.name = value;
                continue;
            }
            if ("quote".equals(name)) {
                result.quote = value;
                continue;
            }
            if ("queryTimeout".equals(name)) {
                result.queryTimeout = value;
                continue;
            }
            if ("mapKeyNaming".equals(name)) {
                result.mapKeyNaming = value;
                continue;
            }
            if ("ensureResultMapping".equals(name)) {
                result.ensureResultMapping = value;
                continue;
            }
            if (!"sqlLog".equals(name)) continue;
            result.sqlLog = value;
        }
        return result;
    }

    public AnnotationValue getQueryTimeout() {
        return this.queryTimeout;
    }

    public AnnotationValue getMapKeyNaming() {
        return this.mapKeyNaming;
    }

    public AnnotationValue getSqlLog() {
        return this.sqlLog;
    }

    public String getCatalogValue() {
        String value = AnnotationValueUtil.toString(this.catalog);
        if (value == null) {
            throw new AptIllegalStateException("catalog");
        }
        return value;
    }

    public String getSchemaValue() {
        String value = AnnotationValueUtil.toString(this.schema);
        if (value == null) {
            throw new AptIllegalStateException("schema");
        }
        return value;
    }

    public String getNameValue() {
        String value = AnnotationValueUtil.toString(this.name);
        if (value == null || value.isEmpty()) {
            return this.defaultName;
        }
        return value;
    }

    public boolean getQuoteValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.quote);
        if (value == null) {
            throw new AptIllegalStateException("quote");
        }
        return value;
    }

    public int getQueryTimeoutValue() {
        Integer value = AnnotationValueUtil.toInteger(this.queryTimeout);
        if (value == null) {
            throw new AptIllegalStateException("queryTimeout");
        }
        return value;
    }

    public MapKeyNamingType getMapKeyNamingValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.mapKeyNaming);
        if (enumConstant == null) {
            throw new AptIllegalStateException("mapKeyNaming");
        }
        return MapKeyNamingType.valueOf(enumConstant.getSimpleName().toString());
    }

    public boolean getEnsureResultMappingValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.ensureResultMapping);
        if (value == null) {
            throw new AptIllegalStateException("ensureResultMapping");
        }
        return value;
    }

    public SqlLogType getSqlLogValue() {
        VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(this.sqlLog);
        if (enumConstant == null) {
            throw new AptIllegalStateException("sqlLog");
        }
        return SqlLogType.valueOf(enumConstant.getSimpleName().toString());
    }
}

