/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.Domain;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class DomainMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue valueType;
    protected AnnotationValue factoryMethod;
    protected AnnotationValue accessorMethod;
    protected AnnotationValue acceptNull;

    protected DomainMirror(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull(annotationMirror);
        this.annotationMirror = annotationMirror;
    }

    public static DomainMirror newInstance(TypeElement clazz, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror((Element)clazz, Domain.class, env);
        if (annotationMirror == null) {
            return null;
        }
        DomainMirror result = new DomainMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("valueType".equals(name)) {
                result.valueType = value;
                continue;
            }
            if ("factoryMethod".equals(name)) {
                result.factoryMethod = value;
                continue;
            }
            if ("accessorMethod".equals(name)) {
                result.accessorMethod = value;
                continue;
            }
            if (!"acceptNull".equals(name)) continue;
            result.acceptNull = value;
        }
        return result;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getValueType() {
        return this.valueType;
    }

    public AnnotationValue getFactoryMethod() {
        return this.factoryMethod;
    }

    public AnnotationValue getAccessorMethod() {
        return this.accessorMethod;
    }

    public AnnotationValue getAcceptNull() {
        return this.acceptNull;
    }

    public TypeMirror getValueTypeValue() {
        TypeMirror value = AnnotationValueUtil.toType(this.valueType);
        if (value == null) {
            throw new AptIllegalStateException("valueType");
        }
        return value;
    }

    public String getFactoryMethodValue() {
        String value = AnnotationValueUtil.toString(this.factoryMethod);
        if (value == null) {
            throw new AptIllegalStateException("factoryMethod");
        }
        return value;
    }

    public String getAccessorMethodValue() {
        String value = AnnotationValueUtil.toString(this.accessorMethod);
        if (value == null) {
            throw new AptIllegalStateException("accessorMethod");
        }
        return value;
    }

    public boolean getAcceptNullValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.acceptNull);
        if (value == null) {
            throw new AptIllegalStateException("acceptNull");
        }
        return value;
    }
}

