/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.seasar.doma.Column;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class ColumnMirror {
    protected final AnnotationMirror annotationMirror;
    protected AnnotationValue name;
    protected AnnotationValue insertable;
    protected AnnotationValue updatable;
    protected AnnotationValue quote;

    protected ColumnMirror(AnnotationMirror annotationMirror) {
        AssertionUtil.assertNotNull(annotationMirror);
        this.annotationMirror = annotationMirror;
    }

    public static ColumnMirror newInstance(VariableElement field, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror((Element)field, Column.class, env);
        if (annotationMirror == null) {
            return null;
        }
        ColumnMirror result = new ColumnMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("name".equals(name)) {
                result.name = value;
                continue;
            }
            if ("insertable".equals(name)) {
                result.insertable = value;
                continue;
            }
            if ("updatable".equals(name)) {
                result.updatable = value;
                continue;
            }
            if (!"quote".equals(name)) continue;
            result.quote = value;
        }
        return result;
    }

    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getName() {
        return this.name;
    }

    public AnnotationValue getInsertable() {
        return this.insertable;
    }

    public AnnotationValue getUpdatable() {
        return this.updatable;
    }

    public AnnotationValue getQuote() {
        return this.quote;
    }

    public String getNameValue() {
        String value = AnnotationValueUtil.toString(this.name);
        if (value == null) {
            throw new AptIllegalStateException("name");
        }
        return value;
    }

    public boolean getInsertableValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.insertable);
        if (value == null) {
            throw new AptIllegalStateException("insertable");
        }
        return value;
    }

    public boolean getUpdatableValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.updatable);
        if (value == null) {
            throw new AptIllegalStateException("updatable");
        }
        return value;
    }

    public boolean getQuoteValue() {
        Boolean value = AnnotationValueUtil.toBoolean(this.quote);
        if (value == null) {
            throw new AptIllegalStateException("quote");
        }
        return value;
    }
}

