/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.seasar.doma.BatchDelete;
import org.seasar.doma.internal.apt.mirror.BatchModifyMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class BatchDeleteMirror
extends BatchModifyMirror {
    protected BatchDeleteMirror(AnnotationMirror annotationMirror) {
        super(annotationMirror);
    }

    public static BatchDeleteMirror newInstance(ExecutableElement method, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        AnnotationMirror annotationMirror = ElementUtil.getAnnotationMirror((Element)method, BatchDelete.class, env);
        if (annotationMirror == null) {
            return null;
        }
        BatchDeleteMirror result = new BatchDeleteMirror(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotationMirror).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if ("sqlFile".equals(name)) {
                result.sqlFile = value;
                continue;
            }
            if ("queryTimeout".equals(name)) {
                result.queryTimeout = value;
                continue;
            }
            if ("batchSize".equals(name)) {
                result.batchSize = value;
                continue;
            }
            if ("ignoreVersion".equals(name)) {
                result.ignoreVersion = value;
                continue;
            }
            if ("suppressOptimisticLockException".equals(name)) {
                result.suppressOptimisticLockException = value;
                continue;
            }
            if (!"sqlLog".equals(name)) continue;
            result.sqlLog = value;
        }
        return result;
    }
}

