/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.mirror;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.seasar.doma.AnnotateWith;
import org.seasar.doma.internal.apt.mirror.AnnotationMirror;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class AnnotateWithMirror {
    protected final javax.lang.model.element.AnnotationMirror annotationMirror;
    protected TypeElement ownerElement;
    protected AnnotationValue annotations;
    protected List<AnnotationMirror> annotationsValue;

    protected AnnotateWithMirror(javax.lang.model.element.AnnotationMirror annotationMirror, TypeElement ownerElement) {
        AssertionUtil.assertNotNull((Object)annotationMirror, (Object)ownerElement);
        this.annotationMirror = annotationMirror;
        this.ownerElement = ownerElement;
    }

    public static AnnotateWithMirror newInstance(TypeElement clazz, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        javax.lang.model.element.AnnotationMirror annotateWith = ElementUtil.getAnnotationMirror((Element)clazz, AnnotateWith.class, env);
        TypeElement ownerElement = null;
        if (annotateWith == null) {
            javax.lang.model.element.AnnotationMirror annotationMirror;
            Iterator<? extends javax.lang.model.element.AnnotationMirror> iterator = clazz.getAnnotationMirrors().iterator();
            while (iterator.hasNext() && ((ownerElement = ElementUtil.toTypeElement((annotationMirror = iterator.next()).getAnnotationType().asElement(), env)) == null || (annotateWith = ElementUtil.getAnnotationMirror((Element)ownerElement, AnnotateWith.class, env)) == null)) {
            }
            if (annotateWith == null) {
                return null;
            }
        } else {
            ownerElement = clazz;
        }
        AnnotateWithMirror result = new AnnotateWithMirror(annotateWith, ownerElement);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : env.getElementUtils().getElementValuesWithDefaults(annotateWith).entrySet()) {
            String name = entry.getKey().getSimpleName().toString();
            AnnotationValue value = entry.getValue();
            if (!"annotations".equals(name)) continue;
            result.annotations = value;
            result.annotationsValue = new ArrayList<AnnotationMirror>();
            for (javax.lang.model.element.AnnotationMirror a : AnnotationValueUtil.toAnnotationList(value)) {
                result.annotationsValue.add(AnnotationMirror.newInstance(a, env));
            }
        }
        return result;
    }

    public TypeElement getOwnerElement() {
        return this.ownerElement;
    }

    public javax.lang.model.element.AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public AnnotationValue getAnnotations() {
        return this.annotations;
    }

    public List<AnnotationMirror> getAnnotationsValue() {
        return this.annotationsValue;
    }
}

