/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.BiFunctionCtType;
import org.seasar.doma.internal.apt.cttype.ConfigCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.PreparedSqlCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlProcessorQueryMeta;
import org.seasar.doma.internal.apt.mirror.SqlProcessorMirror;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlProcessorQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlProcessorQueryMeta> {
    public SqlProcessorQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        SqlProcessorQueryMeta queryMeta = this.createSqlContentQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        this.doSqlFiles(queryMeta, method, daoMeta, false, false);
        return queryMeta;
    }

    protected SqlProcessorQueryMeta createSqlContentQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        SqlProcessorMirror sqlProcessorMirror = SqlProcessorMirror.newInstance(method, this.env);
        if (sqlProcessorMirror == null) {
            return null;
        }
        SqlProcessorQueryMeta queryMeta = new SqlProcessorQueryMeta(method, daoMeta.getDaoElement());
        queryMeta.setSqlProcessorMirror(sqlProcessorMirror);
        queryMeta.setQueryKind(QueryKind.SQL_PROCESSOR);
        return queryMeta;
    }

    @Override
    protected void doParameters(SqlProcessorQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (VariableElement variableElement : method.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement, queryMeta);
            parameterMeta.getCtType().accept(new ParamCtTypeVisitor(queryMeta, parameterMeta), null);
            queryMeta.addParameterMeta(parameterMeta);
            if (!parameterMeta.isBindable()) continue;
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
        if (queryMeta.getBiFunctionCtType() == null) {
            SqlProcessorMirror sqlProcessorMirror = queryMeta.getSqlProcessorMirror();
            throw new AptException((MessageResource)Message.DOMA4433, this.env, (Element)method, sqlProcessorMirror.getAnnotationMirror(), new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
    }

    @Override
    protected void doReturnType(SqlProcessorQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        queryMeta.setReturnMeta(returnMeta);
        BiFunctionCtType biFunctionCtType = queryMeta.getBiFunctionCtType();
        AnyCtType resultCtType = biFunctionCtType.getResultCtType();
        if (resultCtType == null || !this.isConvertibleReturnType(returnMeta, resultCtType)) {
            throw new AptException((MessageResource)Message.DOMA4436, this.env, method, new Object[]{returnMeta.getType(), resultCtType.getBoxedTypeName(), daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
    }

    protected boolean isConvertibleReturnType(QueryReturnMeta returnMeta, AnyCtType resultCtType) {
        if (this.env.getTypeUtils().isSameType(returnMeta.getType(), resultCtType.getTypeMirror())) {
            return true;
        }
        if (returnMeta.getType().getKind() == TypeKind.VOID) {
            return TypeMirrorUtil.isSameType(resultCtType.getTypeMirror(), Void.class, this.env);
        }
        return false;
    }

    protected class ParamBiFunctionSecondArgCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlProcessorQueryMeta queryMeta;
        protected QueryParameterMeta parameterMeta;

        protected ParamBiFunctionSecondArgCtTypeVisitor(SqlProcessorQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4435, SqlProcessorQueryMetaFactory.this.env, this.queryMeta.getMethodElement(), new Object[]{this.parameterMeta.getDaoElement().getQualifiedName(), this.parameterMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public Void visitPreparedSqlCtType(PreparedSqlCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    protected class ParamBiFunctionFirstArgCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlProcessorQueryMeta queryMeta;
        protected QueryParameterMeta parameterMeta;

        protected ParamBiFunctionFirstArgCtTypeVisitor(SqlProcessorQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4437, SqlProcessorQueryMetaFactory.this.env, this.queryMeta.getMethodElement(), new Object[]{this.parameterMeta.getDaoElement().getQualifiedName(), this.parameterMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public Void visitConfigCtType(ConfigCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    protected class ParamCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlProcessorQueryMeta queryMeta;
        protected QueryParameterMeta parameterMeta;

        protected ParamCtTypeVisitor(SqlProcessorQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        public Void visitBiFunctionCtType(BiFunctionCtType ctType, Void p) throws RuntimeException {
            if (this.queryMeta.getBiFunctionCtType() != null) {
                throw new AptException((MessageResource)Message.DOMA4434, SqlProcessorQueryMetaFactory.this.env, this.parameterMeta.getElement(), new Object[]{this.parameterMeta.getDaoElement().getQualifiedName(), this.parameterMeta.getMethodElement().getSimpleName()});
            }
            ctType.getFirstArgCtType().accept(new ParamBiFunctionFirstArgCtTypeVisitor(this.queryMeta, this.parameterMeta), null);
            ctType.getSecondArgCtType().accept(new ParamBiFunctionSecondArgCtTypeVisitor(this.queryMeta, this.parameterMeta), null);
            this.queryMeta.setBiFunctionCtType(ctType);
            this.queryMeta.setBiFunctionParameterName(this.parameterMeta.getName());
            return null;
        }
    }
}

