/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.seasar.doma.SelectType;
import org.seasar.doma.Suppress;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CollectorCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.FunctionCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SelectOptionsCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.meta.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlFileSelectQueryMeta;
import org.seasar.doma.internal.apt.mirror.SelectMirror;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileSelectQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileSelectQueryMeta> {
    public SqlFileSelectQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        SqlFileSelectQueryMeta queryMeta = this.createSqlFileSelectQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        this.doSqlFiles(queryMeta, method, daoMeta, queryMeta.isExpandable(), false);
        return queryMeta;
    }

    protected SqlFileSelectQueryMeta createSqlFileSelectQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        SelectMirror selectMirror = SelectMirror.newInstance(method, this.env);
        if (selectMirror == null) {
            return null;
        }
        SqlFileSelectQueryMeta queryMeta = new SqlFileSelectQueryMeta(method, daoMeta.getDaoElement());
        queryMeta.setSelectMirror(selectMirror);
        queryMeta.setQueryKind(QueryKind.SQLFILE_SELECT);
        return queryMeta;
    }

    @Override
    protected void doParameters(SqlFileSelectQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        for (VariableElement variableElement : method.getParameters()) {
            QueryParameterMeta parameterMeta = this.createParameterMeta(variableElement, queryMeta);
            parameterMeta.getCtType().accept(new ParamCtTypeVisitor(queryMeta, parameterMeta), null);
            queryMeta.addParameterMeta(parameterMeta);
            if (!parameterMeta.isBindable()) continue;
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
        if (queryMeta.getSelectStrategyType() == SelectType.STREAM) {
            if (queryMeta.getFunctionCtType() == null) {
                throw new AptException((MessageResource)Message.DOMA4247, this.env, method, new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
            }
        } else if (queryMeta.getSelectStrategyType() == SelectType.COLLECT) {
            if (queryMeta.getCollectorCtType() == null) {
                throw new AptException((MessageResource)Message.DOMA4266, this.env, method, new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
            }
        } else if (queryMeta.getFunctionCtType() != null) {
            SelectMirror selectMirror = queryMeta.getSelectMirror();
            throw new AptException((MessageResource)Message.DOMA4248, this.env, method, selectMirror.getAnnotationMirror(), selectMirror.getStrategy(), new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
    }

    @Override
    protected void doReturnType(SqlFileSelectQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        queryMeta.setReturnMeta(returnMeta);
        if (queryMeta.getSelectStrategyType() == SelectType.STREAM) {
            FunctionCtType functionCtType = queryMeta.getFunctionCtType();
            AnyCtType returnCtType = functionCtType.getReturnCtType();
            if (returnCtType == null || !this.env.getTypeUtils().isSameType(returnMeta.getType(), returnCtType.getTypeMirror())) {
                throw new AptException((MessageResource)Message.DOMA4246, this.env, method, new Object[]{returnMeta.getType(), returnCtType.getBoxedTypeName(), daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
            }
        } else if (queryMeta.getSelectStrategyType() == SelectType.COLLECT) {
            CollectorCtType collectorCtType = queryMeta.getCollectorCtType();
            AnyCtType returnCtType = collectorCtType.getReturnCtType();
            if (returnCtType == null || !this.env.getTypeUtils().isSameType(returnMeta.getType(), returnCtType.getTypeMirror())) {
                throw new AptException((MessageResource)Message.DOMA4265, this.env, method, new Object[]{returnMeta.getType(), returnCtType.getBoxedTypeName(), daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
            }
        } else {
            returnMeta.getCtType().accept(new ReturnCtTypeVisitor(queryMeta, returnMeta), null);
        }
    }

    protected class ReturnStreamOptionalElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryReturnMeta returnMeta;

        protected ReturnStreamOptionalElementCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4267, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{type.getTypeName(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    protected class ReturnListOptionalElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryReturnMeta returnMeta;

        protected ReturnListOptionalElementCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4267, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{type.getTypeName(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    protected class ReturnOptionalElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryReturnMeta returnMeta;

        protected ReturnOptionalElementCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4235, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{type.getTypeName(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4234, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{ctType.getTypeMirror(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }
    }

    protected class ReturnStreamElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryReturnMeta returnMeta;

        protected ReturnStreamElementCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4271, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{type.getTypeName(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4272, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{ctType.getTypeMirror(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new ReturnStreamOptionalElementCtTypeVisitor(this.queryMeta, this.returnMeta), p);
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    protected class ReturnListElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryReturnMeta returnMeta;

        protected ReturnListElementCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4007, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{type.getTypeName(), this.queryMeta.getDaoElement(), this.queryMeta.getMethodElement()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4155, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{ctType.getTypeMirror(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new ReturnListOptionalElementCtTypeVisitor(this.queryMeta, this.returnMeta), p);
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    protected class ReturnCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryReturnMeta returnMeta;
        protected Suppress suppress;

        protected ReturnCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryReturnMeta returnMeta) {
            this.queryMeta = queryMeta;
            this.returnMeta = returnMeta;
            this.suppress = queryMeta.getMethodElement().getAnnotation(Suppress.class);
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4008, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{this.returnMeta.getType(), this.queryMeta.getDaoElement(), this.queryMeta.getMethodElement()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4154, SqlFileSelectQueryMetaFactory.this.env, this.returnMeta.getMethodElement(), new Object[]{ctType.getQualifiedName(), this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitIterableCtType(IterableCtType ctType, Void p) throws RuntimeException {
            if (!ctType.isList()) {
                this.defaultAction((CtType)ctType, p);
            }
            ctType.getElementCtType().accept(new ReturnListElementCtTypeVisitor(this.queryMeta, this.returnMeta), p);
            return null;
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void p) throws RuntimeException {
            if (!this.isSuppressed(Message.DOMA4274)) {
                Notifier.notify(SqlFileSelectQueryMetaFactory.this.env, Diagnostic.Kind.WARNING, Message.DOMA4274, this.returnMeta.getMethodElement(), new Object[]{this.returnMeta.getDaoElement().getQualifiedName(), this.returnMeta.getMethodElement().getSimpleName()});
            }
            this.queryMeta.setResultStream(true);
            ctType.getElementCtType().accept(new ReturnStreamElementCtTypeVisitor(this.queryMeta, this.returnMeta), p);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new ReturnOptionalElementCtTypeVisitor(this.queryMeta, this.returnMeta), p);
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        protected boolean isSuppressed(Message message) {
            if (this.suppress != null) {
                for (Message suppressMessage : this.suppress.messages()) {
                    if (suppressMessage != message) continue;
                    return true;
                }
            }
            return false;
        }
    }

    protected class ParamCollectorTargetCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryParameterMeta parameterMeta;

        protected ParamCollectorTargetCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4262, SqlFileSelectQueryMetaFactory.this.env, this.queryMeta.getMethodElement(), new Object[]{this.parameterMeta.getDaoElement().getQualifiedName(), this.parameterMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            if (ctType.isAbstract()) {
                throw new AptException((MessageResource)Message.DOMA4263, SqlFileSelectQueryMetaFactory.this.env, this.parameterMeta.getElement(), new Object[]{ctType.getTypeName(), this.parameterMeta.getDaoElement().getQualifiedName(), this.parameterMeta.getMethodElement().getSimpleName()});
            }
            this.queryMeta.setEntityCtType(ctType);
            return null;
        }

        @Override
        public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            Boolean valid = ctType.getElementCtType().accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(){

                @Override
                protected Boolean defaultAction(CtType ctType, Void p) throws RuntimeException {
                    return false;
                }

                @Override
                public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                    return true;
                }

                @Override
                public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                    return true;
                }
            }, null);
            if (Boolean.FALSE == valid) {
                this.defaultAction((CtType)ctType, null);
            }
            return null;
        }

        @Override
        public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return null;
        }

        @Override
        public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return null;
        }
    }

    protected class ParamFunctionTargetCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryParameterMeta parameterMeta;

        protected ParamFunctionTargetCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        protected Void defaultAction(CtType type, Void p) throws RuntimeException {
            throw new AptException((MessageResource)Message.DOMA4244, SqlFileSelectQueryMetaFactory.this.env, this.queryMeta.getMethodElement(), new Object[]{this.parameterMeta.getDaoElement().getQualifiedName(), this.parameterMeta.getMethodElement().getSimpleName()});
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void p) throws RuntimeException {
            return ctType.getElementCtType().accept(new StreamElementCtTypeVisitor(), null);
        }

        protected class StreamElementCtTypeVisitor
        extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
            protected StreamElementCtTypeVisitor() {
            }

            @Override
            protected Void defaultAction(CtType ctType, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4245, SqlFileSelectQueryMetaFactory.this.env, ParamFunctionTargetCtTypeVisitor.this.queryMeta.getMethodElement(), new Object[]{ParamFunctionTargetCtTypeVisitor.this.parameterMeta.getDaoElement().getQualifiedName(), ParamFunctionTargetCtTypeVisitor.this.parameterMeta.getMethodElement().getSimpleName()});
            }

            @Override
            public Void visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitMapCtType(MapCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
                if (ctType.isAbstract()) {
                    throw new AptException((MessageResource)Message.DOMA4250, SqlFileSelectQueryMetaFactory.this.env, ParamFunctionTargetCtTypeVisitor.this.parameterMeta.getElement(), new Object[]{ctType.getTypeName(), ParamFunctionTargetCtTypeVisitor.this.parameterMeta.getDaoElement().getQualifiedName(), ParamFunctionTargetCtTypeVisitor.this.parameterMeta.getMethodElement().getSimpleName()});
                }
                ParamFunctionTargetCtTypeVisitor.this.queryMeta.setEntityCtType(ctType);
                return null;
            }

            @Override
            public Void visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
                Boolean valid = ctType.getElementCtType().accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(){

                    @Override
                    protected Boolean defaultAction(CtType ctType, Void p) throws RuntimeException {
                        return false;
                    }

                    @Override
                    public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                        return true;
                    }

                    @Override
                    public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                        return true;
                    }
                }, null);
                if (Boolean.FALSE == valid) {
                    this.defaultAction((CtType)ctType, null);
                }
                return null;
            }

            @Override
            public Void visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
                return null;
            }

            @Override
            public Void visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
                return null;
            }
        }
    }

    protected class ParamCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected SqlFileSelectQueryMeta queryMeta;
        protected QueryParameterMeta parameterMeta;

        protected ParamCtTypeVisitor(SqlFileSelectQueryMeta queryMeta, QueryParameterMeta parameterMeta) {
            this.queryMeta = queryMeta;
            this.parameterMeta = parameterMeta;
        }

        @Override
        public Void visitFunctionCtType(FunctionCtType ctType, Void p) throws RuntimeException {
            if (this.queryMeta.getFunctionCtType() != null) {
                throw new AptException((MessageResource)Message.DOMA4249, SqlFileSelectQueryMetaFactory.this.env, this.parameterMeta.getElement(), new Object[]{this.parameterMeta.getDaoElement().getQualifiedName(), this.parameterMeta.getMethodElement().getSimpleName()});
            }
            ctType.getTargetCtType().accept(new ParamFunctionTargetCtTypeVisitor(this.queryMeta, this.parameterMeta), null);
            this.queryMeta.setFunctionCtType(ctType);
            this.queryMeta.setFunctionParameterName(this.parameterMeta.getName());
            return null;
        }

        @Override
        public Void visitCollectorCtType(CollectorCtType ctType, Void p) throws RuntimeException {
            if (this.queryMeta.getCollectorCtType() != null) {
                throw new AptException((MessageResource)Message.DOMA4264, SqlFileSelectQueryMetaFactory.this.env, this.parameterMeta.getElement(), new Object[]{this.parameterMeta.getDaoElement().getQualifiedName(), this.parameterMeta.getMethodElement().getSimpleName()});
            }
            ctType.getTargetCtType().accept(new ParamCollectorTargetCtTypeVisitor(this.queryMeta, this.parameterMeta), null);
            this.queryMeta.setCollectorCtType(ctType);
            this.queryMeta.setCollectorParameterName(this.parameterMeta.getName());
            return null;
        }

        @Override
        public Void visitSelectOptionsCtType(SelectOptionsCtType ctType, Void p) throws RuntimeException {
            if (this.queryMeta.getSelectOptionsCtType() != null) {
                throw new AptException((MessageResource)Message.DOMA4053, SqlFileSelectQueryMetaFactory.this.env, this.parameterMeta.getElement(), new Object[]{this.queryMeta.getDaoElement().getQualifiedName(), this.queryMeta.getMethodElement().getSimpleName()});
            }
            this.queryMeta.setSelectOptionsCtType(ctType);
            this.queryMeta.setSelectOptionsParameterName(this.parameterMeta.getName());
            return null;
        }
    }
}

