/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.io.File;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.meta.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlFileScriptQueryMeta;
import org.seasar.doma.internal.apt.mirror.ScriptMirror;
import org.seasar.doma.internal.jdbc.util.ScriptFileUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileScriptQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileScriptQueryMeta> {
    public SqlFileScriptQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        SqlFileScriptQueryMeta queryMeta = this.createSqlFileScriptQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        this.doSqlFiles(queryMeta, method, daoMeta, false, false);
        return queryMeta;
    }

    protected SqlFileScriptQueryMeta createSqlFileScriptQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        SqlFileScriptQueryMeta queryMeta = new SqlFileScriptQueryMeta(method, daoMeta.getDaoElement());
        ScriptMirror scriptMirror = ScriptMirror.newInstance(method, this.env);
        if (scriptMirror == null) {
            return null;
        }
        queryMeta.setScriptMirror(scriptMirror);
        queryMeta.setQueryKind(QueryKind.SQLFILE_SCRIPT);
        return queryMeta;
    }

    @Override
    protected void doReturnType(SqlFileScriptQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        if (!returnMeta.isPrimitiveVoid()) {
            throw new AptException((MessageResource)Message.DOMA4172, this.env, returnMeta.getMethodElement(), new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(SqlFileScriptQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        if (!method.getParameters().isEmpty()) {
            throw new AptException((MessageResource)Message.DOMA4173, this.env, method, new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
    }

    @Override
    protected void doSqlFiles(SqlFileScriptQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta, boolean expandable, boolean populatable) {
        String filePath = ScriptFileUtil.buildPath(daoMeta.getDaoElement().getQualifiedName().toString(), queryMeta.getName());
        File file = this.getFile(queryMeta, method, filePath);
        File[] siblingfiles = this.getSiblingFiles(queryMeta, method, file);
        String methodName = queryMeta.getName();
        for (File siblingfile : siblingfiles) {
            if (!ScriptFileUtil.isScriptFile(siblingfile, methodName)) continue;
            String fileName = siblingfile.getName();
            queryMeta.addFileName(fileName);
        }
    }
}

