/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.BatchSqlValidator;
import org.seasar.doma.internal.apt.SqlValidator;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.AbstractSqlFileQueryMetaFactory;
import org.seasar.doma.internal.apt.meta.DaoMeta;
import org.seasar.doma.internal.apt.meta.QueryKind;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.meta.QueryParameterMeta;
import org.seasar.doma.internal.apt.meta.QueryReturnMeta;
import org.seasar.doma.internal.apt.meta.SqlFileBatchModifyQueryMeta;
import org.seasar.doma.internal.apt.mirror.BatchDeleteMirror;
import org.seasar.doma.internal.apt.mirror.BatchInsertMirror;
import org.seasar.doma.internal.apt.mirror.BatchModifyMirror;
import org.seasar.doma.internal.apt.mirror.BatchUpdateMirror;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class SqlFileBatchModifyQueryMetaFactory
extends AbstractSqlFileQueryMetaFactory<SqlFileBatchModifyQueryMeta> {
    public SqlFileBatchModifyQueryMetaFactory(ProcessingEnvironment env) {
        super(env);
    }

    @Override
    public QueryMeta createQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        AssertionUtil.assertNotNull((Object)method, (Object)daoMeta);
        SqlFileBatchModifyQueryMeta queryMeta = this.createSqlFileBatchModifyQueryMeta(method, daoMeta);
        if (queryMeta == null) {
            return null;
        }
        this.doTypeParameters(queryMeta, method, daoMeta);
        this.doParameters(queryMeta, method, daoMeta);
        this.doReturnType(queryMeta, method, daoMeta);
        this.doThrowTypes(queryMeta, method, daoMeta);
        this.doSqlFiles(queryMeta, method, daoMeta, false, queryMeta.isPopulatable());
        return queryMeta;
    }

    protected SqlFileBatchModifyQueryMeta createSqlFileBatchModifyQueryMeta(ExecutableElement method, DaoMeta daoMeta) {
        SqlFileBatchModifyQueryMeta queryMeta = new SqlFileBatchModifyQueryMeta(method, daoMeta.getDaoElement());
        BatchModifyMirror batchModifyMirror = BatchInsertMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_INSERT);
            return queryMeta;
        }
        batchModifyMirror = BatchUpdateMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_UPDATE);
            return queryMeta;
        }
        batchModifyMirror = BatchDeleteMirror.newInstance(method, this.env);
        if (batchModifyMirror != null && batchModifyMirror.getSqlFileValue()) {
            queryMeta.setBatchModifyMirror(batchModifyMirror);
            queryMeta.setQueryKind(QueryKind.SQLFILE_BATCH_DELETE);
            return queryMeta;
        }
        return null;
    }

    @Override
    protected void doReturnType(SqlFileBatchModifyQueryMeta queryMeta, ExecutableElement method, DaoMeta daoMeta) {
        QueryReturnMeta returnMeta = this.createReturnMeta(queryMeta);
        EntityCtType entityCtType = queryMeta.getEntityType();
        if (entityCtType != null && entityCtType.isImmutable()) {
            if (!returnMeta.isBatchResult(entityCtType)) {
                throw new AptException((MessageResource)Message.DOMA4223, this.env, returnMeta.getMethodElement(), new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
            }
        } else if (!returnMeta.isPrimitiveIntArray()) {
            throw new AptException((MessageResource)Message.DOMA4040, this.env, returnMeta.getMethodElement(), new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
        queryMeta.setReturnMeta(returnMeta);
    }

    @Override
    protected void doParameters(final SqlFileBatchModifyQueryMeta queryMeta, final ExecutableElement method, final DaoMeta daoMeta) {
        List<? extends VariableElement> parameters = method.getParameters();
        int size = parameters.size();
        if (size != 1) {
            throw new AptException((MessageResource)Message.DOMA4002, this.env, method, new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
        }
        QueryParameterMeta parameterMeta = this.createParameterMeta(parameters.get(0), queryMeta);
        IterableCtType iterableCtType = parameterMeta.getCtType().accept(new SimpleCtTypeVisitor<IterableCtType, Void, RuntimeException>(){

            @Override
            protected IterableCtType defaultAction(CtType type, Void p) throws RuntimeException {
                throw new AptException((MessageResource)Message.DOMA4042, SqlFileBatchModifyQueryMetaFactory.this.env, method, new Object[]{daoMeta.getDaoElement().getQualifiedName(), method.getSimpleName()});
            }

            @Override
            public IterableCtType visitIterableCtType(IterableCtType ctType, Void p) throws RuntimeException {
                return ctType;
            }
        }, null);
        CtType elementCtType = iterableCtType.getElementCtType();
        queryMeta.setElementCtType(elementCtType);
        queryMeta.setElementsParameterName(parameterMeta.getName());
        elementCtType.accept(new SimpleCtTypeVisitor<Void, Void, RuntimeException>(){

            @Override
            public Void visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
                queryMeta.setEntityType(ctType);
                return null;
            }
        }, null);
        queryMeta.addParameterMeta(parameterMeta);
        if (parameterMeta.isBindable()) {
            queryMeta.addBindableParameterCtType(parameterMeta.getName(), parameterMeta.getCtType());
        }
    }

    @Override
    protected SqlValidator createSqlValidator(ExecutableElement method, LinkedHashMap<String, TypeMirror> parameterTypeMap, String sqlFilePath, boolean expandable, boolean populatable) {
        return new BatchSqlValidator(this.env, method, parameterTypeMap, sqlFilePath, expandable, populatable);
    }
}

