/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.TypeKindVisitor8;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.MapCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.BatchResult;
import org.seasar.doma.jdbc.Result;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class QueryReturnMeta {
    protected final ProcessingEnvironment env;
    protected final ExecutableElement methodElement;
    protected final TypeElement daoElement;
    protected final TypeMirror type;
    protected final String typeName;
    protected final CtType ctType;

    public QueryReturnMeta(QueryMeta queryMeta, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)queryMeta, (Object)env);
        this.env = env;
        this.methodElement = queryMeta.getMethodElement();
        this.daoElement = queryMeta.getDaoElement();
        this.type = this.methodElement.getReturnType();
        this.typeName = TypeMirrorUtil.getTypeName(this.type, env);
        this.ctType = this.createCtType();
    }

    protected CtType createCtType() {
        IterableCtType iterableCtType = IterableCtType.newInstance(this.type, this.env);
        if (iterableCtType != null) {
            if (iterableCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4109, this.env, this.methodElement, new Object[]{this.typeName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (iterableCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4113, this.env, this.methodElement, new Object[]{this.typeName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            iterableCtType.getElementCtType().accept(new IterableElementCtTypeVisitor(), null);
            return iterableCtType;
        }
        StreamCtType streamCtType = StreamCtType.newInstance(this.type, this.env);
        if (streamCtType != null) {
            return streamCtType;
        }
        EntityCtType entityCtType = EntityCtType.newInstance(this.type, this.env);
        if (entityCtType != null) {
            return entityCtType;
        }
        OptionalCtType optionalCtType = OptionalCtType.newInstance(this.type, this.env);
        if (optionalCtType != null) {
            if (optionalCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4236, this.env, this.methodElement, new Object[]{optionalCtType.getQualifiedName(), this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (optionalCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4237, this.env, this.methodElement, new Object[]{optionalCtType.getQualifiedName(), this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            optionalCtType.getElementCtType().accept(new OptionalElementCtTypeVisitor(), null);
            return optionalCtType;
        }
        OptionalIntCtType optionalIntCtType = OptionalIntCtType.newInstance(this.type, this.env);
        if (optionalIntCtType != null) {
            return optionalIntCtType;
        }
        OptionalLongCtType optionalLongCtType = OptionalLongCtType.newInstance(this.type, this.env);
        if (optionalLongCtType != null) {
            return optionalLongCtType;
        }
        OptionalDoubleCtType optionalDoubleCtType = OptionalDoubleCtType.newInstance(this.type, this.env);
        if (optionalDoubleCtType != null) {
            return optionalDoubleCtType;
        }
        DomainCtType domainCtType = DomainCtType.newInstance(this.type, this.env);
        if (domainCtType != null) {
            if (domainCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4206, this.env, this.methodElement, new Object[]{domainCtType.getQualifiedName(), this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (domainCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4207, this.env, this.methodElement, new Object[]{domainCtType.getQualifiedName(), this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            return domainCtType;
        }
        BasicCtType basicCtType = BasicCtType.newInstance(this.type, this.env);
        if (basicCtType != null) {
            return basicCtType;
        }
        MapCtType mapCtType = MapCtType.newInstance(this.type, this.env);
        if (mapCtType != null) {
            return mapCtType;
        }
        return AnyCtType.newInstance(this.type, this.env);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getBoxedTypeName() {
        return this.ctType.getBoxedTypeName();
    }

    public boolean isPrimitiveInt() {
        return this.type.getKind() == TypeKind.INT;
    }

    public boolean isPrimitiveIntArray() {
        return this.type.accept(new TypeKindVisitor8<Boolean, Void>(Boolean.valueOf(false)){

            @Override
            public Boolean visitArray(ArrayType t, Void p) {
                return t.getComponentType().getKind() == TypeKind.INT;
            }
        }, null);
    }

    public boolean isPrimitiveVoid() {
        return this.type.getKind() == TypeKind.VOID;
    }

    public boolean isResult(EntityCtType entityCtType) {
        if (!TypeMirrorUtil.isSameType(this.env.getTypeUtils().erasure(this.type), Result.class, this.env)) {
            return false;
        }
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(this.type, this.env);
        if (declaredType == null) {
            return false;
        }
        List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
        if (typeArgs.size() != 1) {
            return false;
        }
        TypeMirror typeArg = typeArgs.get(0);
        return TypeMirrorUtil.isSameType(typeArg, entityCtType.getTypeMirror(), this.env);
    }

    public boolean isBatchResult(EntityCtType entityCtType) {
        if (!TypeMirrorUtil.isSameType(this.env.getTypeUtils().erasure(this.type), BatchResult.class, this.env)) {
            return false;
        }
        DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(this.type, this.env);
        if (declaredType == null) {
            return false;
        }
        List<? extends TypeMirror> typeArgs = declaredType.getTypeArguments();
        if (typeArgs.size() != 1) {
            return false;
        }
        TypeMirror typeArg = typeArgs.get(0);
        return TypeMirrorUtil.isSameType(typeArg, entityCtType.getTypeMirror(), this.env);
    }

    public ExecutableElement getMethodElement() {
        return this.methodElement;
    }

    public TypeElement getDaoElement() {
        return this.daoElement;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public CtType getCtType() {
        return this.ctType;
    }

    protected class OptionalElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected OptionalElementCtTypeVisitor() {
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4238, QueryReturnMeta.this.env, QueryReturnMeta.this.methodElement, new Object[]{ctType.getQualifiedName(), QueryReturnMeta.this.daoElement.getQualifiedName(), QueryReturnMeta.this.methodElement.getSimpleName()});
            }
            if (ctType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4239, QueryReturnMeta.this.env, QueryReturnMeta.this.methodElement, new Object[]{ctType.getQualifiedName(), QueryReturnMeta.this.daoElement.getQualifiedName(), QueryReturnMeta.this.methodElement.getSimpleName()});
            }
            return null;
        }
    }

    protected class IterableElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected IterableElementCtTypeVisitor() {
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4210, QueryReturnMeta.this.env, QueryReturnMeta.this.methodElement, new Object[]{ctType.getQualifiedName(), QueryReturnMeta.this.daoElement.getQualifiedName(), QueryReturnMeta.this.methodElement.getSimpleName()});
            }
            if (ctType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4211, QueryReturnMeta.this.env, QueryReturnMeta.this.methodElement, new Object[]{ctType.getQualifiedName(), QueryReturnMeta.this.daoElement.getQualifiedName(), QueryReturnMeta.this.methodElement.getSimpleName()});
            }
            return null;
        }
    }
}

