/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.cttype.AnyCtType;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.BiFunctionCtType;
import org.seasar.doma.internal.apt.cttype.CollectorCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.EntityCtType;
import org.seasar.doma.internal.apt.cttype.FunctionCtType;
import org.seasar.doma.internal.apt.cttype.IterableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.ReferenceCtType;
import org.seasar.doma.internal.apt.cttype.SelectOptionsCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.cttype.StreamCtType;
import org.seasar.doma.internal.apt.meta.QueryMeta;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class QueryParameterMeta {
    protected final VariableElement element;
    protected final ExecutableElement methodElement;
    protected final TypeElement daoElement;
    protected final ProcessingEnvironment env;
    protected final String name;
    protected final String typeName;
    protected final TypeMirror type;
    protected final String qualifiedName;
    protected final CtType ctType;

    public QueryParameterMeta(VariableElement parameterElement, QueryMeta queryMeta, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)parameterElement, (Object)queryMeta, (Object)env);
        this.element = parameterElement;
        this.methodElement = queryMeta.getMethodElement();
        this.daoElement = queryMeta.getDaoElement();
        this.env = env;
        this.name = ElementUtil.getParameterName(parameterElement);
        if (this.name.startsWith("__")) {
            throw new AptException((MessageResource)Message.DOMA4025, env, parameterElement, new Object[]{"__", queryMeta.getDaoElement().getQualifiedName(), queryMeta.getMethodElement().getSimpleName()});
        }
        this.type = parameterElement.asType();
        this.typeName = TypeMirrorUtil.getTypeName(this.type, env);
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(this.type, env);
        this.qualifiedName = typeElement != null ? typeElement.getQualifiedName().toString() : this.typeName;
        this.ctType = this.createCtType(parameterElement, env);
    }

    protected CtType createCtType(VariableElement parameterElement, ProcessingEnvironment env) {
        IterableCtType iterableCtType = IterableCtType.newInstance(this.type, env);
        if (iterableCtType != null) {
            if (iterableCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4159, env, parameterElement, new Object[]{this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (iterableCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4160, env, parameterElement, new Object[]{this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            iterableCtType.getElementCtType().accept(new IterableElementCtTypeVisitor(parameterElement), null);
            return iterableCtType;
        }
        EntityCtType entityCtType = EntityCtType.newInstance(this.type, env);
        if (entityCtType != null) {
            return entityCtType;
        }
        OptionalCtType optionalCtType = OptionalCtType.newInstance(this.type, env);
        if (optionalCtType != null) {
            if (optionalCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4236, env, parameterElement, new Object[]{optionalCtType.getQualifiedName(), this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (optionalCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4237, env, parameterElement, new Object[]{optionalCtType.getQualifiedName(), this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            optionalCtType.getElementCtType().accept(new OptionalElementCtTypeVisitor(parameterElement), null);
            return optionalCtType;
        }
        OptionalIntCtType optionalIntCtType = OptionalIntCtType.newInstance(this.type, env);
        if (optionalIntCtType != null) {
            return optionalIntCtType;
        }
        OptionalLongCtType optionalLongCtType = OptionalLongCtType.newInstance(this.type, env);
        if (optionalLongCtType != null) {
            return optionalLongCtType;
        }
        OptionalDoubleCtType optionalDoubleCtType = OptionalDoubleCtType.newInstance(this.type, env);
        if (optionalDoubleCtType != null) {
            return optionalDoubleCtType;
        }
        DomainCtType domainCtType = DomainCtType.newInstance(this.type, env);
        if (domainCtType != null) {
            if (domainCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4208, env, parameterElement, new Object[]{domainCtType.getQualifiedName(), this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (domainCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4209, env, parameterElement, new Object[]{domainCtType.getQualifiedName(), this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            return domainCtType;
        }
        BasicCtType basicCtType = BasicCtType.newInstance(this.type, env);
        if (basicCtType != null) {
            return basicCtType;
        }
        SelectOptionsCtType selectOptionsCtType = SelectOptionsCtType.newInstance(this.type, env);
        if (selectOptionsCtType != null) {
            return selectOptionsCtType;
        }
        FunctionCtType functionCtType = FunctionCtType.newInstance(this.type, env);
        if (functionCtType != null) {
            if (functionCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4240, env, parameterElement, new Object[]{this.qualifiedName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (functionCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4241, env, parameterElement, new Object[]{this.qualifiedName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            functionCtType.getTargetCtType().accept(new FunctionTargetCtTypeVisitor(parameterElement), null);
            return functionCtType;
        }
        CollectorCtType collectorCtType = CollectorCtType.newInstance(this.type, env);
        if (collectorCtType != null) {
            if (collectorCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4258, env, parameterElement, new Object[]{this.qualifiedName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (collectorCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4259, env, parameterElement, new Object[]{this.qualifiedName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            collectorCtType.getTargetCtType().accept(new CollectorTargetCtTypeVisitor(parameterElement), null);
            return collectorCtType;
        }
        ReferenceCtType referenceCtType = ReferenceCtType.newInstance(this.type, env);
        if (referenceCtType != null) {
            if (referenceCtType.isRaw()) {
                throw new AptException((MessageResource)Message.DOMA4108, env, parameterElement, new Object[]{this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (referenceCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4112, env, parameterElement, new Object[]{this.qualifiedName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            referenceCtType.getReferentCtType().accept(new ReferenceReferentCtTypeVisitor(parameterElement), null);
            return referenceCtType;
        }
        BiFunctionCtType biFunctionCtType = BiFunctionCtType.newInstance(this.type, env);
        if (biFunctionCtType != null) {
            if (biFunctionCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4438, env, parameterElement, new Object[]{this.qualifiedName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            if (biFunctionCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4439, env, parameterElement, new Object[]{this.qualifiedName, this.daoElement.getQualifiedName(), this.methodElement.getSimpleName()});
            }
            return biFunctionCtType;
        }
        return AnyCtType.newInstance(this.type, env);
    }

    public VariableElement getElement() {
        return this.element;
    }

    public ExecutableElement getMethodElement() {
        return this.methodElement;
    }

    public TypeElement getDaoElement() {
        return this.daoElement;
    }

    public String getName() {
        return this.name;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public CtType getCtType() {
        return this.ctType;
    }

    public boolean isNullable() {
        return this.ctType.accept(new NullableCtTypeVisitor(false), null);
    }

    public boolean isBindable() {
        return this.ctType.accept(new BindableCtTypeVisitor(false), null);
    }

    public boolean isAnnotated(Class<? extends Annotation> annotationType) {
        return this.element.getAnnotation(annotationType) != null;
    }

    protected class ReferenceReferentCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected final VariableElement parameterElement;

        protected ReferenceReferentCtTypeVisitor(VariableElement parameterElement) {
            this.parameterElement = parameterElement;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4218, QueryParameterMeta.this.env, this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
            }
            if (ctType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4219, QueryParameterMeta.this.env, this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
            }
            return null;
        }
    }

    protected class CollectorTargetCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected final VariableElement parameterElement;

        protected CollectorTargetCtTypeVisitor(VariableElement parameterElement) {
            this.parameterElement = parameterElement;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4260, QueryParameterMeta.this.env, this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
            }
            if (ctType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4261, QueryParameterMeta.this.env, this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
            }
            return null;
        }
    }

    protected class FunctionTargetCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected final VariableElement parameterElement;

        protected FunctionTargetCtTypeVisitor(VariableElement parameterElement) {
            this.parameterElement = parameterElement;
        }

        @Override
        public Void visitStreamCtType(StreamCtType ctType, Void p) throws RuntimeException {
            ctType.getElementCtType().accept(new StreamElementCtTypeVisitor(), p);
            return null;
        }

        protected class StreamElementCtTypeVisitor
        extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
            protected StreamElementCtTypeVisitor() {
            }

            @Override
            public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                if (ctType.isRawType()) {
                    throw new AptException((MessageResource)Message.DOMA4242, QueryParameterMeta.this.env, FunctionTargetCtTypeVisitor.this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
                }
                if (ctType.isWildcardType()) {
                    throw new AptException((MessageResource)Message.DOMA4243, QueryParameterMeta.this.env, FunctionTargetCtTypeVisitor.this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
                }
                return null;
            }
        }
    }

    protected class OptionalElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected final VariableElement parameterElement;

        protected OptionalElementCtTypeVisitor(VariableElement parameterElement) {
            this.parameterElement = parameterElement;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4238, QueryParameterMeta.this.env, this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
            }
            if (ctType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4239, QueryParameterMeta.this.env, this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
            }
            return null;
        }
    }

    protected class IterableElementCtTypeVisitor
    extends SimpleCtTypeVisitor<Void, Void, RuntimeException> {
        protected final VariableElement parameterElement;

        protected IterableElementCtTypeVisitor(VariableElement parameterElement) {
            this.parameterElement = parameterElement;
        }

        @Override
        public Void visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            if (ctType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4212, QueryParameterMeta.this.env, this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
            }
            if (ctType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4213, QueryParameterMeta.this.env, this.parameterElement, new Object[]{ctType.getQualifiedName(), QueryParameterMeta.this.daoElement.getQualifiedName(), QueryParameterMeta.this.methodElement.getSimpleName()});
            }
            return null;
        }
    }

    protected class BindableCtTypeVisitor
    extends SimpleCtTypeVisitor<Boolean, Void, RuntimeException> {
        public BindableCtTypeVisitor(boolean bindable) {
            super(bindable);
        }

        @Override
        public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitEmbeddableCtType(EmbeddableCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitEntityCtType(EntityCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitIterableCtType(IterableCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitReferenceCtType(ReferenceCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitAnyCtType(AnyCtType ctType, Void p) throws RuntimeException {
            return true;
        }
    }

    protected class NullableCtTypeVisitor
    extends SimpleCtTypeVisitor<Boolean, Void, RuntimeException> {
        public NullableCtTypeVisitor(boolean nullable) {
            super(nullable);
        }

        @Override
        public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
            return true;
        }

        @Override
        public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
            return true;
        }
    }
}

