/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Transient;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;

public class EntityPropertyNameCollector {
    protected final ProcessingEnvironment env;

    public EntityPropertyNameCollector(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        this.env = env;
    }

    public Set<String> collect(TypeMirror entityType) {
        HashSet<String> names = new HashSet<String>();
        this.collectNames(entityType, names);
        return names;
    }

    protected void collectNames(TypeMirror type, Set<String> names) {
        TypeElement t = TypeMirrorUtil.toTypeElement(type, this.env);
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            for (VariableElement field : ElementFilter.fieldsIn(t.getEnclosedElements())) {
                if (!this.isPersistent(field)) continue;
                names.add(field.getSimpleName().toString());
            }
            t = TypeMirrorUtil.toTypeElement(t.getSuperclass(), this.env);
        }
    }

    protected boolean isPersistent(VariableElement field) {
        return field.getAnnotation(Transient.class) == null && !field.getModifiers().contains((Object)Modifier.STATIC);
    }
}

