/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.GeneratedValue;
import org.seasar.doma.Id;
import org.seasar.doma.SequenceGenerator;
import org.seasar.doma.TableGenerator;
import org.seasar.doma.TenantId;
import org.seasar.doma.Version;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.EntityMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.IdentityIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.SequenceIdGeneratorMeta;
import org.seasar.doma.internal.apt.meta.TableIdGeneratorMeta;
import org.seasar.doma.internal.apt.mirror.ColumnMirror;
import org.seasar.doma.internal.apt.mirror.SequenceGeneratorMirror;
import org.seasar.doma.internal.apt.mirror.TableGeneratorMirror;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EntityPropertyMetaFactory {
    protected final ProcessingEnvironment env;

    public EntityPropertyMetaFactory(ProcessingEnvironment env) {
        AssertionUtil.assertNotNull(env);
        this.env = env;
    }

    public EntityPropertyMeta createEntityPropertyMeta(VariableElement fieldElement, EntityMeta entityMeta) {
        AssertionUtil.assertNotNull((Object)fieldElement, (Object)entityMeta);
        TypeElement entityElement = ElementUtil.toTypeElement(fieldElement.getEnclosingElement(), this.env);
        if (entityElement == null) {
            throw new AptIllegalStateException(fieldElement.toString());
        }
        EntityPropertyMeta propertyMeta = new EntityPropertyMeta(entityElement, fieldElement, entityMeta.getNamingType(), this.env);
        this.doCtType(propertyMeta, fieldElement, entityMeta);
        this.doName(propertyMeta, fieldElement, entityMeta);
        this.doId(propertyMeta, fieldElement, entityMeta);
        this.doVersion(propertyMeta, fieldElement, entityMeta);
        this.doTenantId(propertyMeta, fieldElement, entityMeta);
        this.doColumn(propertyMeta, fieldElement, entityMeta);
        return propertyMeta;
    }

    protected void doCtType(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        CtType ctType = this.resolveCtType(fieldElement, fieldElement.asType(), entityMeta);
        propertyMeta.setCtType(ctType);
    }

    protected CtType resolveCtType(VariableElement fieldElement, TypeMirror type, EntityMeta entityMeta) {
        OptionalCtType optionalCtType = OptionalCtType.newInstance(type, this.env);
        if (optionalCtType != null) {
            if (optionalCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4232, this.env, fieldElement, new Object[]{optionalCtType.getQualifiedName(), entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (optionalCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4233, this.env, fieldElement, new Object[]{optionalCtType.getQualifiedName(), entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            return optionalCtType;
        }
        OptionalIntCtType optionalIntCtType = OptionalIntCtType.newInstance(type, this.env);
        if (optionalIntCtType != null) {
            return optionalIntCtType;
        }
        OptionalLongCtType optionalLongCtType = OptionalLongCtType.newInstance(type, this.env);
        if (optionalLongCtType != null) {
            return optionalLongCtType;
        }
        OptionalDoubleCtType optionalDoubleCtType = OptionalDoubleCtType.newInstance(type, this.env);
        if (optionalDoubleCtType != null) {
            return optionalDoubleCtType;
        }
        DomainCtType domainCtType = DomainCtType.newInstance(type, this.env);
        if (domainCtType != null) {
            if (domainCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4204, this.env, fieldElement, new Object[]{domainCtType.getQualifiedName(), entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (domainCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4205, this.env, fieldElement, new Object[]{domainCtType.getQualifiedName(), entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            return domainCtType;
        }
        EmbeddableCtType embeddableCtType = EmbeddableCtType.newInstance(type, this.env);
        if (embeddableCtType != null) {
            return embeddableCtType;
        }
        BasicCtType basicCtType = BasicCtType.newInstance(type, this.env);
        if (basicCtType != null) {
            return basicCtType;
        }
        throw new AptException((MessageResource)Message.DOMA4096, this.env, fieldElement, new Object[]{type, entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
    }

    protected void doName(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        String name = fieldElement.getSimpleName().toString();
        if (name.startsWith("__")) {
            throw new AptException((MessageResource)Message.DOMA4025, this.env, fieldElement, new Object[]{"__", entityMeta.getEntityElement().getQualifiedName()});
        }
        propertyMeta.setName(name);
    }

    protected void doId(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        Id id = fieldElement.getAnnotation(Id.class);
        if (id == null) {
            GeneratedValue generatedValue = fieldElement.getAnnotation(GeneratedValue.class);
            if (generatedValue == null) {
                this.validateSequenceGeneratorNotExistent(propertyMeta, fieldElement, entityMeta);
                this.validateTableGeneratorNotExistent(propertyMeta, fieldElement, entityMeta);
                return;
            }
            throw new AptException((MessageResource)Message.DOMA4033, this.env, fieldElement, new Object[]{entityMeta.getEntityElement(), fieldElement.getSimpleName()});
        }
        if (propertyMeta.isEmbedded()) {
            throw new AptException((MessageResource)Message.DOMA4302, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
        }
        propertyMeta.setId(true);
        GeneratedValue generatedValue = fieldElement.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            this.validateSequenceGeneratorNotExistent(propertyMeta, fieldElement, entityMeta);
            this.validateTableGeneratorNotExistent(propertyMeta, fieldElement, entityMeta);
            return;
        }
        if (propertyMeta.isEmbedded()) {
            throw new AptException((MessageResource)Message.DOMA4303, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
        }
        if (entityMeta.hasGeneratedIdPropertyMeta()) {
            throw new AptException((MessageResource)Message.DOMA4037, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
        }
        if (!this.isNumber(propertyMeta.getCtType())) {
            throw new AptException((MessageResource)Message.DOMA4095, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
        }
        switch (generatedValue.strategy()) {
            case IDENTITY: {
                this.doIdentityIdGeneratorMeta(propertyMeta, fieldElement, entityMeta);
                break;
            }
            case SEQUENCE: {
                this.doSequenceIdGeneratorMeta(propertyMeta, fieldElement, entityMeta);
                break;
            }
            case TABLE: {
                this.doTableIdGeneratorMeta(propertyMeta, fieldElement, entityMeta);
                break;
            }
            default: {
                AssertionUtil.assertUnreachable();
            }
        }
    }

    protected void validateSequenceGeneratorNotExistent(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        SequenceGenerator sequenceGenerator = fieldElement.getAnnotation(SequenceGenerator.class);
        if (sequenceGenerator != null) {
            throw new AptException((MessageResource)Message.DOMA4030, this.env, fieldElement, new Object[]{entityMeta.getEntityElement(), fieldElement.getSimpleName()});
        }
    }

    protected void validateTableGeneratorNotExistent(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        TableGenerator tableGenerator = fieldElement.getAnnotation(TableGenerator.class);
        if (tableGenerator != null) {
            throw new AptException((MessageResource)Message.DOMA4031, this.env, fieldElement, new Object[]{entityMeta.getEntityElement(), fieldElement.getSimpleName()});
        }
    }

    protected void doIdentityIdGeneratorMeta(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        propertyMeta.setIdGeneratorMeta(new IdentityIdGeneratorMeta());
    }

    protected void doSequenceIdGeneratorMeta(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        SequenceGeneratorMirror sequenceGeneratorMirror = SequenceGeneratorMirror.newInstance(fieldElement, this.env);
        if (sequenceGeneratorMirror == null) {
            throw new AptException((MessageResource)Message.DOMA4034, this.env, fieldElement, new Object[]{entityMeta.getEntityElement(), fieldElement.getSimpleName()});
        }
        this.validateSequenceIdGenerator(propertyMeta, fieldElement, sequenceGeneratorMirror);
        SequenceIdGeneratorMeta idGeneratorMeta = new SequenceIdGeneratorMeta(sequenceGeneratorMirror);
        propertyMeta.setIdGeneratorMeta(idGeneratorMeta);
    }

    protected void validateSequenceIdGenerator(EntityPropertyMeta propertyMeta, VariableElement fieldElement, SequenceGeneratorMirror sequenceGeneratorMirror) {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(sequenceGeneratorMirror.getImplementerValue(), this.env);
        if (typeElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement");
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4170, this.env, fieldElement, sequenceGeneratorMirror.getAnnotationMirror(), sequenceGeneratorMirror.getImplementer(), new Object[]{typeElement.getQualifiedName()});
        }
        ExecutableElement constructor = ElementUtil.getNoArgConstructor(typeElement, this.env);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4171, this.env, fieldElement, sequenceGeneratorMirror.getAnnotationMirror(), sequenceGeneratorMirror.getImplementer(), new Object[]{typeElement.getQualifiedName()});
        }
    }

    protected void doTableIdGeneratorMeta(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        TableGeneratorMirror tableGeneratorMirror = TableGeneratorMirror.newInstance(fieldElement, this.env);
        if (tableGeneratorMirror == null) {
            throw new AptException((MessageResource)Message.DOMA4035, this.env, fieldElement, new Object[]{entityMeta.getEntityElement(), fieldElement.getSimpleName()});
        }
        this.validateTableIdGenerator(propertyMeta, fieldElement, tableGeneratorMirror);
        TableIdGeneratorMeta idGeneratorMeta = new TableIdGeneratorMeta(tableGeneratorMirror);
        propertyMeta.setIdGeneratorMeta(idGeneratorMeta);
    }

    protected void validateTableIdGenerator(EntityPropertyMeta propertyMeta, VariableElement fieldElement, TableGeneratorMirror tableGeneratorMirror) {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(tableGeneratorMirror.getImplementerValue(), this.env);
        if (typeElement == null) {
            throw new AptIllegalStateException("failed to convert to TypeElement");
        }
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            throw new AptException((MessageResource)Message.DOMA4168, this.env, fieldElement, tableGeneratorMirror.getAnnotationMirror(), tableGeneratorMirror.getImplementer(), new Object[]{typeElement.getQualifiedName()});
        }
        ExecutableElement constructor = ElementUtil.getNoArgConstructor(typeElement, this.env);
        if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
            throw new AptException((MessageResource)Message.DOMA4169, this.env, fieldElement, tableGeneratorMirror.getAnnotationMirror(), tableGeneratorMirror.getImplementer(), new Object[]{typeElement.getQualifiedName()});
        }
    }

    protected void doVersion(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        Version version = fieldElement.getAnnotation(Version.class);
        if (version != null) {
            if (propertyMeta.isEmbedded()) {
                throw new AptException((MessageResource)Message.DOMA4304, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (entityMeta.hasVersionPropertyMeta()) {
                throw new AptException((MessageResource)Message.DOMA4024, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (!this.isNumber(propertyMeta.getCtType())) {
                throw new AptException((MessageResource)Message.DOMA4093, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            propertyMeta.setVersion(true);
        }
    }

    protected void doTenantId(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        TenantId tenantId = fieldElement.getAnnotation(TenantId.class);
        if (tenantId != null) {
            if (propertyMeta.isEmbedded()) {
                throw new AptException((MessageResource)Message.DOMA4441, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (entityMeta.hasTenantIdPropertyMeta()) {
                throw new AptException((MessageResource)Message.DOMA4442, this.env, fieldElement, new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            propertyMeta.setTenantId(true);
        }
    }

    protected void doColumn(EntityPropertyMeta propertyMeta, VariableElement fieldElement, EntityMeta entityMeta) {
        ColumnMirror columnMirror = ColumnMirror.newInstance(fieldElement, this.env);
        if (columnMirror == null) {
            return;
        }
        if (propertyMeta.isEmbedded()) {
            throw new AptException((MessageResource)Message.DOMA4306, this.env, (Element)fieldElement, columnMirror.getAnnotationMirror(), new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
        }
        if (propertyMeta.isId() || propertyMeta.isVersion()) {
            if (!columnMirror.getInsertableValue()) {
                throw new AptException((MessageResource)Message.DOMA4088, this.env, fieldElement, columnMirror.getAnnotationMirror(), columnMirror.getInsertable(), new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (!columnMirror.getUpdatableValue()) {
                throw new AptException((MessageResource)Message.DOMA4089, this.env, fieldElement, columnMirror.getAnnotationMirror(), columnMirror.getUpdatable(), new Object[]{entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
        }
        propertyMeta.setColumnMirror(columnMirror);
    }

    protected boolean isNumber(CtType ctType) {
        Boolean isNumber = ctType.accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(){

            @Override
            public Boolean visitOptionalCtType(OptionalCtType ctType, Void p) throws RuntimeException {
                return ctType.getElementCtType().accept(this, p);
            }

            @Override
            public Boolean visitOptionalIntCtType(OptionalIntCtType ctType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitOptionalLongCtType(OptionalLongCtType ctType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitOptionalDoubleCtType(OptionalDoubleCtType ctType, Void p) throws RuntimeException {
                return true;
            }

            @Override
            public Boolean visitDomainCtType(DomainCtType ctType, Void p) throws RuntimeException {
                return ctType.getBasicCtType().accept(this, p);
            }

            @Override
            public Boolean visitBasicCtType(BasicCtType ctType, Void p) throws RuntimeException {
                TypeMirror boxedType = TypeMirrorUtil.boxIfPrimitive(ctType.getTypeMirror(), EntityPropertyMetaFactory.this.env);
                return TypeMirrorUtil.isAssignable(boxedType, Number.class, EntityPropertyMetaFactory.this.env);
            }
        }, null);
        return isNumber == Boolean.TRUE;
    }
}

