/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Options;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.SimpleCtTypeVisitor;
import org.seasar.doma.internal.apt.meta.IdGeneratorMeta;
import org.seasar.doma.internal.apt.mirror.ColumnMirror;
import org.seasar.doma.internal.apt.util.MetaUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.NamingType;

public class EntityPropertyMeta {
    protected final String entityName;
    protected final String entityTypeName;
    protected final String entityMetaTypeName;
    protected final NamingType namingType;
    protected final TypeMirror type;
    protected final String typeName;
    protected final String boxedTypeName;
    protected final String boxedClassName;
    protected final String fieldPrefix;
    protected final ProcessingEnvironment env;
    protected String name;
    protected boolean id;
    protected boolean version;
    protected boolean tenantId;
    protected ColumnMirror columnMirror;
    protected IdGeneratorMeta idGeneratorMeta;
    protected CtType ctType;

    public EntityPropertyMeta(TypeElement entityElement, VariableElement propertyElement, NamingType namingType, ProcessingEnvironment env) {
        AssertionUtil.assertNotNull((Object)entityElement, (Object)propertyElement, (Object)env);
        this.entityName = entityElement.getSimpleName().toString();
        this.entityTypeName = entityElement.getQualifiedName().toString();
        this.entityMetaTypeName = MetaUtil.toFullMetaName(entityElement, env);
        this.namingType = namingType;
        this.type = propertyElement.asType();
        this.typeName = TypeMirrorUtil.getTypeName(this.type, env);
        this.boxedTypeName = TypeMirrorUtil.getBoxedTypeName(this.type, env);
        this.boxedClassName = TypeMirrorUtil.getBoxedClassName(this.type, env);
        this.fieldPrefix = Options.getEntityFieldPrefix(env);
        this.env = env;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public String getEntityMetaTypeName() {
        return this.entityMetaTypeName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.fieldPrefix + this.name;
    }

    public boolean isId() {
        return this.id;
    }

    public void setId(boolean id) {
        this.id = id;
    }

    public boolean isVersion() {
        return this.version;
    }

    public void setVersion(boolean version) {
        this.version = version;
    }

    public boolean isTenantId() {
        return this.tenantId;
    }

    public void setTenantId(boolean tenantId) {
        this.tenantId = tenantId;
    }

    public IdGeneratorMeta getIdGeneratorMeta() {
        return this.idGeneratorMeta;
    }

    public void setIdGeneratorMeta(IdGeneratorMeta idGeneratorMeta) {
        this.idGeneratorMeta = idGeneratorMeta;
    }

    public TypeMirror getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getBoxedTypeName() {
        return this.boxedTypeName;
    }

    public String getBoxedClassName() {
        return this.boxedClassName;
    }

    public CtType getCtType() {
        return this.ctType;
    }

    public void setCtType(CtType ctType) {
        this.ctType = ctType;
    }

    public void setColumnMirror(ColumnMirror columnMirror) {
        this.columnMirror = columnMirror;
    }

    public String getColumnName() {
        return this.columnMirror != null ? this.columnMirror.getNameValue() : "";
    }

    public boolean isColumnInsertable() {
        return this.columnMirror != null ? this.columnMirror.getInsertableValue() : true;
    }

    public boolean isColumnUpdatable() {
        return this.columnMirror != null ? this.columnMirror.getUpdatableValue() : true;
    }

    public boolean isColumnQuoteRequired() {
        return this.columnMirror != null ? this.columnMirror.getQuoteValue() : false;
    }

    public boolean isEmbedded() {
        return this.ctType.accept(new SimpleCtTypeVisitor<Boolean, Void, RuntimeException>(Boolean.valueOf(false)){

            @Override
            public Boolean visitEmbeddableCtType(EmbeddableCtType ctType, Void p) throws RuntimeException {
                return true;
            }
        }, null);
    }

    public String getEmbeddableMetaTypeName() {
        TypeElement typeElement = TypeMirrorUtil.toTypeElement(this.type, this.env);
        if (typeElement == null) {
            throw new AptIllegalStateException("typeElement must not be null.");
        }
        return MetaUtil.toFullMetaName(typeElement, this.env);
    }
}

