/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.seasar.doma.Entity;
import org.seasar.doma.EntityField;
import org.seasar.doma.OriginalStates;
import org.seasar.doma.ParameterName;
import org.seasar.doma.Transient;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.AptIllegalStateException;
import org.seasar.doma.internal.apt.Notifier;
import org.seasar.doma.internal.apt.meta.EntityConstructorMeta;
import org.seasar.doma.internal.apt.meta.EntityMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMetaFactory;
import org.seasar.doma.internal.apt.meta.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMetaFactory;
import org.seasar.doma.internal.apt.mirror.AllArgsConstructorMirror;
import org.seasar.doma.internal.apt.mirror.EntityMirror;
import org.seasar.doma.internal.apt.mirror.TableMirror;
import org.seasar.doma.internal.apt.mirror.ValueMirror;
import org.seasar.doma.internal.apt.util.AnnotationValueUtil;
import org.seasar.doma.internal.apt.util.ElementUtil;
import org.seasar.doma.internal.apt.util.TypeMirrorUtil;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.EntityListener;
import org.seasar.doma.jdbc.entity.NamingType;
import org.seasar.doma.jdbc.entity.NullEntityListener;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EntityMetaFactory
implements TypeElementMetaFactory<EntityMeta> {
    protected final ProcessingEnvironment env;
    protected final EntityPropertyMetaFactory propertyMetaFactory;

    public EntityMetaFactory(ProcessingEnvironment env, EntityPropertyMetaFactory propertyMetaFactory) {
        AssertionUtil.assertNotNull((Object)env, (Object)propertyMetaFactory);
        this.env = env;
        this.propertyMetaFactory = propertyMetaFactory;
    }

    @Override
    public EntityMeta createTypeElementMeta(TypeElement classElement) {
        AssertionUtil.assertNotNull(classElement);
        EntityMirror entityMirror = EntityMirror.newInstance(classElement, this.env);
        if (entityMirror == null) {
            throw new AptIllegalStateException("entityMirror.");
        }
        EntityMeta entityMeta = new EntityMeta(entityMirror, classElement);
        TypeMirror entityListener = this.resolveEntityListener(classElement);
        entityMeta.setEntityListener(entityListener);
        TypeElement entityListenerElement = TypeMirrorUtil.toTypeElement(entityListener, this.env);
        if (entityListenerElement == null) {
            throw new AptIllegalStateException("entityListener.");
        }
        entityMeta.setEntityListenerElement(entityListenerElement);
        entityMeta.setGenericEntityListener(!entityListenerElement.getTypeParameters().isEmpty());
        NamingType namingType = this.resolveNamingType(classElement);
        entityMeta.setNamingType(namingType);
        boolean immutable = this.resolveImmutable(classElement, entityMirror);
        entityMeta.setImmutable(immutable);
        entityMeta.setEntityName(classElement.getSimpleName().toString());
        entityMeta.setEntityTypeName(TypeMirrorUtil.getTypeName(classElement.asType(), this.env));
        Strategy strategy = this.createStrategy(classElement, entityMeta);
        strategy.doClassElement(classElement, entityMeta);
        strategy.doFieldElements(classElement, entityMeta);
        strategy.validateGeneratedId(classElement, entityMeta);
        strategy.validateOriginalStates(classElement, entityMeta);
        strategy.doConstructor(classElement, entityMeta);
        return entityMeta;
    }

    protected Strategy createStrategy(TypeElement classElement, EntityMeta entityMeta) {
        ValueMirror valueMirror = ValueMirror.newInstance(classElement, this.env);
        if (valueMirror != null) {
            return new ValueStrategy(this.env, this.propertyMetaFactory, valueMirror);
        }
        AllArgsConstructorMirror allArgsConstructorMirror = AllArgsConstructorMirror.newInstance(classElement, this.env);
        if (allArgsConstructorMirror != null) {
            return new AllArgsConstructorStrategy(this.env, this.propertyMetaFactory, allArgsConstructorMirror);
        }
        return new DefaultStrategy(this.env, this.propertyMetaFactory);
    }

    protected TypeMirror resolveEntityListener(TypeElement classElement) {
        TypeMirror result = TypeMirrorUtil.getTypeMirror(NullEntityListener.class, this.env);
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "listener")) {
            if (value == null) continue;
            TypeMirror listenerType = AnnotationValueUtil.toType(value);
            if (listenerType == null) {
                throw new AptIllegalStateException("listener");
            }
            result = listenerType;
        }
        return result;
    }

    protected NamingType resolveNamingType(TypeElement classElement) {
        NamingType result = null;
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "naming")) {
            if (value == null) continue;
            VariableElement enumConstant = AnnotationValueUtil.toEnumConstant(value);
            if (enumConstant == null) {
                throw new AptIllegalStateException("naming");
            }
            result = NamingType.valueOf(enumConstant.getSimpleName().toString());
        }
        return result;
    }

    protected boolean resolveImmutable(TypeElement classElement, EntityMirror entityMirror) {
        boolean result = false;
        ArrayList<Boolean> resolvedList = new ArrayList<Boolean>();
        for (AnnotationValue value : this.getEntityElementValueList(classElement, "immutable")) {
            if (value == null) continue;
            Boolean immutable = AnnotationValueUtil.toBoolean(value);
            if (immutable == null) {
                throw new AptIllegalStateException("immutable");
            }
            result = immutable;
            resolvedList.add(immutable);
        }
        if (resolvedList.contains(Boolean.TRUE) && resolvedList.contains(Boolean.FALSE)) {
            throw new AptException((MessageResource)Message.DOMA4226, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getImmutable(), new Object[]{classElement.getQualifiedName()});
        }
        return result;
    }

    protected List<AnnotationValue> getEntityElementValueList(TypeElement classElement, String entityElementName) {
        LinkedList<AnnotationValue> list = new LinkedList<AnnotationValue>();
        TypeElement t = classElement;
        while (t != null && t.asType().getKind() != TypeKind.NONE) {
            AnnotationMirror annMirror = ElementUtil.getAnnotationMirror((Element)t, Entity.class, this.env);
            if (annMirror != null) {
                AnnotationValue value = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annMirror.getElementValues().entrySet()) {
                    ExecutableElement element = entry.getKey();
                    if (!entityElementName.equals(element.getSimpleName().toString())) continue;
                    value = entry.getValue();
                    break;
                }
                list.add(value);
            }
            t = TypeMirrorUtil.toTypeElement(t.getSuperclass(), this.env);
        }
        Collections.reverse(list);
        return list;
    }

    protected static class ValueStrategy
    extends DefaultStrategy {
        protected final ValueMirror valueMirror;

        public ValueStrategy(ProcessingEnvironment env, EntityPropertyMetaFactory propertyMetaFactory, ValueMirror valueMirror) {
            super(env, propertyMetaFactory);
            AssertionUtil.assertNotNull(valueMirror);
            this.valueMirror = valueMirror;
        }

        @Override
        protected void validateClass(TypeElement classElement, EntityMeta entityMeta) {
            if (!entityMeta.isImmutable()) {
                EntityMirror entityMirror = entityMeta.getEntityMirror();
                throw new AptException((MessageResource)Message.DOMA4418, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getImmutable(), new Object[]{classElement.getQualifiedName()});
            }
            super.validateClass(classElement, entityMeta);
        }

        @Override
        public void doConstructor(TypeElement classElement, EntityMeta entityMeta) {
            if (!this.valueMirror.getStaticConstructorValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4419, this.env, classElement, this.valueMirror.getAnnotationMirror(), this.valueMirror.getStaticConstructor(), new Object[]{classElement.getQualifiedName()});
            }
        }

        @Override
        protected void validateField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
        }
    }

    protected static class AllArgsConstructorStrategy
    extends DefaultStrategy {
        protected final AllArgsConstructorMirror allArgsConstructorMirror;

        public AllArgsConstructorStrategy(ProcessingEnvironment env, EntityPropertyMetaFactory propertyMetaFactory, AllArgsConstructorMirror allArgsConstructorMirror) {
            super(env, propertyMetaFactory);
            AssertionUtil.assertNotNull(allArgsConstructorMirror);
            this.allArgsConstructorMirror = allArgsConstructorMirror;
        }

        @Override
        protected void validateClass(TypeElement classElement, EntityMeta entityMeta) {
            if (!entityMeta.isImmutable()) {
                throw new AptException((MessageResource)Message.DOMA4420, this.env, (Element)classElement, this.allArgsConstructorMirror.getAnnotationMirror(), new Object[]{classElement.getQualifiedName()});
            }
            super.validateClass(classElement, entityMeta);
        }

        @Override
        public void doConstructor(TypeElement classElement, EntityMeta entityMeta) {
            if (!this.allArgsConstructorMirror.getStaticNameValue().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4421, this.env, classElement, this.allArgsConstructorMirror.getAnnotationMirror(), this.allArgsConstructorMirror.getStaticName(), new Object[]{classElement.getQualifiedName()});
            }
            if (this.allArgsConstructorMirror.isAccessPrivate()) {
                throw new AptException((MessageResource)Message.DOMA4422, this.env, classElement, this.allArgsConstructorMirror.getAnnotationMirror(), this.allArgsConstructorMirror.getAccess(), new Object[]{classElement.getQualifiedName()});
            }
            if (this.allArgsConstructorMirror.isAccessNone()) {
                throw new AptException((MessageResource)Message.DOMA4426, this.env, classElement, this.allArgsConstructorMirror.getAnnotationMirror(), this.allArgsConstructorMirror.getAccess(), new Object[]{classElement.getQualifiedName()});
            }
        }

        @Override
        protected void validateField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
        }
    }

    protected static class DefaultStrategy
    implements Strategy {
        protected final ProcessingEnvironment env;
        protected final EntityPropertyMetaFactory propertyMetaFactory;

        public DefaultStrategy(ProcessingEnvironment env, EntityPropertyMetaFactory propertyMetaFactory) {
            AssertionUtil.assertNotNull((Object)env, (Object)propertyMetaFactory);
            this.env = env;
            this.propertyMetaFactory = propertyMetaFactory;
        }

        @Override
        public void doClassElement(TypeElement classElement, EntityMeta entityMeta) {
            this.validateClass(classElement, entityMeta);
            this.validateEntityListener(classElement, entityMeta);
            this.doTable(classElement, entityMeta);
        }

        protected void validateClass(TypeElement classElement, EntityMeta entityMeta) {
            EntityMirror entityMirror = entityMeta.getEntityMirror();
            if (classElement.getKind() != ElementKind.CLASS) {
                throw new AptException((MessageResource)Message.DOMA4015, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), new Object[]{classElement.getQualifiedName()});
            }
            if (!classElement.getTypeParameters().isEmpty()) {
                throw new AptException((MessageResource)Message.DOMA4051, this.env, classElement, new Object[]{classElement.getQualifiedName()});
            }
            this.validateEnclosingElement(classElement);
        }

        protected void validateEnclosingElement(Element element) {
            TypeElement typeElement = ElementUtil.toTypeElement(element, this.env);
            if (typeElement == null) {
                return;
            }
            String simpleName = typeElement.getSimpleName().toString();
            if (simpleName.contains("$") || simpleName.contains("__")) {
                throw new AptException((MessageResource)Message.DOMA4317, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            NestingKind nestingKind = typeElement.getNestingKind();
            if (nestingKind == NestingKind.TOP_LEVEL) {
                return;
            }
            if (nestingKind == NestingKind.MEMBER) {
                Set<Modifier> modifiers = typeElement.getModifiers();
                if (!modifiers.containsAll(Arrays.asList(Modifier.STATIC, Modifier.PUBLIC))) {
                    throw new AptException((MessageResource)Message.DOMA4315, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
                }
            } else {
                throw new AptException((MessageResource)Message.DOMA4316, this.env, typeElement, new Object[]{typeElement.getQualifiedName()});
            }
            this.validateEnclosingElement(typeElement.getEnclosingElement());
        }

        protected void validateEntityListener(TypeElement classElement, EntityMeta entityMeta) {
            EntityMirror entityMirror = entityMeta.getEntityMirror();
            TypeMirror listenerType = entityMirror.getListenerValue();
            TypeElement listenerElement = TypeMirrorUtil.toTypeElement(listenerType, this.env);
            if (listenerElement == null) {
                throw new AptIllegalStateException("failed to convert to TypeElement");
            }
            if (listenerElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new AptException((MessageResource)Message.DOMA4166, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[]{listenerElement.getQualifiedName()});
            }
            ExecutableElement constructor = ElementUtil.getNoArgConstructor(listenerElement, this.env);
            if (constructor == null || !constructor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                throw new AptException((MessageResource)Message.DOMA4167, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[]{listenerElement.getQualifiedName()});
            }
            if (listenerElement.getTypeParameters().size() > 0) {
                this.validateGenericEntityListener(classElement, entityMeta, listenerElement);
            } else {
                this.validateNonGenericEntityListener(classElement, entityMeta, listenerType);
            }
            TypeElement inheritedListenerElement = entityMeta.getEntityListenerElement();
            if (!TypeMirrorUtil.isSameType(listenerType, inheritedListenerElement.asType(), this.env)) {
                this.validateInheritedEntityListener(classElement, entityMeta, inheritedListenerElement);
            }
        }

        protected void validateGenericEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeElement listenerElement) {
            EntityMirror entityMirror = entityMeta.getEntityMirror();
            List<? extends TypeParameterElement> typeParams = listenerElement.getTypeParameters();
            if (typeParams.size() == 0) {
                throw new AptIllegalStateException("typeParams size should be more than 0");
            }
            if (typeParams.size() > 1) {
                throw new AptException((MessageResource)Message.DOMA4227, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[]{classElement.getQualifiedName()});
            }
            TypeParameterElement typeParam = typeParams.get(0);
            for (TypeMirror typeMirror : typeParam.getBounds()) {
                if (TypeMirrorUtil.isAssignable(classElement.asType(), typeMirror, this.env)) continue;
                throw new AptException((MessageResource)Message.DOMA4229, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[]{typeParam.getSimpleName(), typeMirror, classElement.getQualifiedName()});
            }
            if (this.findListenerTypeParam(listenerElement, 0) == null) {
                throw new AptException((MessageResource)Message.DOMA4228, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[]{typeParam.getSimpleName(), classElement.getQualifiedName()});
            }
        }

        protected TypeParameterElement findListenerTypeParam(TypeElement listenerElement, int typeParamIndex) {
            TypeParameterElement typeParam = listenerElement.getTypeParameters().get(typeParamIndex);
            for (TypeMirror typeMirror : listenerElement.getInterfaces()) {
                DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror, this.env);
                if (declaredType == null) continue;
                int i = -1;
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    ++i;
                    TypeVariable typeVariable = TypeMirrorUtil.toTypeVariable(typeMirror2, this.env);
                    if (typeVariable == null || !typeParam.getSimpleName().equals(typeVariable.asElement().getSimpleName())) continue;
                    if (TypeMirrorUtil.isSameType((TypeMirror)declaredType, EntityListener.class, this.env)) {
                        return typeParam;
                    }
                    TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
                    if (typeElement == null) {
                        throw new AptIllegalStateException(declaredType.toString());
                    }
                    TypeParameterElement candidate = this.findListenerTypeParam(typeElement, i);
                    if (candidate == null) continue;
                    return candidate;
                }
            }
            TypeMirror superclass = listenerElement.getSuperclass();
            DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(superclass, this.env);
            if (declaredType == null) {
                return null;
            }
            int i = -1;
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                ++i;
                TypeVariable typeVariable = TypeMirrorUtil.toTypeVariable(typeMirror, this.env);
                if (typeVariable == null || !typeParam.getSimpleName().equals(typeVariable.asElement().getSimpleName())) continue;
                if (TypeMirrorUtil.isSameType((TypeMirror)declaredType, EntityListener.class, this.env)) {
                    return typeParam;
                }
                TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
                if (typeElement == null) {
                    throw new AptIllegalStateException(declaredType.toString());
                }
                TypeParameterElement candidate = this.findListenerTypeParam(typeElement, i);
                if (candidate == null) continue;
                return candidate;
            }
            return null;
        }

        protected void validateNonGenericEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeMirror listenerType) {
            EntityMirror entityMirror = entityMeta.getEntityMirror();
            TypeMirror argumentType = this.getListenerArgumentType(listenerType);
            if (argumentType == null) {
                throw new AptException((MessageResource)Message.DOMA4202, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[]{classElement.getQualifiedName()});
            }
            if (!TypeMirrorUtil.isAssignable(classElement.asType(), argumentType, this.env)) {
                throw new AptException((MessageResource)Message.DOMA4038, this.env, classElement, entityMirror.getAnnotationMirror(), entityMirror.getListener(), new Object[]{listenerType, argumentType, classElement.getQualifiedName()});
            }
        }

        protected void validateInheritedEntityListener(TypeElement classElement, EntityMeta entityMeta, TypeElement inheritedListenerElement) {
            EntityMirror entityMirror = entityMeta.getEntityMirror();
            List<? extends TypeParameterElement> typeParams = inheritedListenerElement.getTypeParameters();
            if (typeParams.size() == 0) {
                throw new AptException((MessageResource)Message.DOMA4230, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), new Object[]{inheritedListenerElement.getQualifiedName(), classElement.getQualifiedName()});
            }
            TypeParameterElement typeParam = typeParams.get(0);
            for (TypeMirror typeMirror : typeParam.getBounds()) {
                if (TypeMirrorUtil.isAssignable(classElement.asType(), typeMirror, this.env)) continue;
                throw new AptException((MessageResource)Message.DOMA4231, this.env, (Element)classElement, entityMirror.getAnnotationMirror(), new Object[]{inheritedListenerElement.getQualifiedName(), typeParam.getSimpleName(), typeMirror, classElement.getQualifiedName()});
            }
        }

        protected TypeMirror getListenerArgumentType(TypeMirror typeMirror) {
            for (TypeMirror typeMirror2 : this.env.getTypeUtils().directSupertypes(typeMirror)) {
                if (!TypeMirrorUtil.isAssignable(typeMirror2, EntityListener.class, this.env)) continue;
                if (TypeMirrorUtil.isSameType(typeMirror2, EntityListener.class, this.env)) {
                    DeclaredType declaredType = TypeMirrorUtil.toDeclaredType(typeMirror2, this.env);
                    if (declaredType == null) {
                        throw new AptIllegalStateException("declaredType");
                    }
                    List<? extends TypeMirror> args = declaredType.getTypeArguments();
                    if (args.size() != 1) {
                        return null;
                    }
                    return args.get(0);
                }
                TypeMirror argumentType = this.getListenerArgumentType(typeMirror2);
                if (argumentType == null) continue;
                return argumentType;
            }
            return null;
        }

        protected void doTable(TypeElement classElement, EntityMeta entityMeta) {
            TableMirror tableMirror = TableMirror.newInstance(classElement, this.env);
            if (tableMirror == null) {
                return;
            }
            entityMeta.setTableMirror(tableMirror);
        }

        @Override
        public void doFieldElements(TypeElement classElement, EntityMeta entityMeta) {
            for (VariableElement fieldElement : this.getFieldElements(classElement)) {
                try {
                    if (fieldElement.getAnnotation(Transient.class) != null || fieldElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
                    if (fieldElement.getAnnotation(OriginalStates.class) != null) {
                        this.doOriginalStatesField(classElement, fieldElement, entityMeta);
                        continue;
                    }
                    this.doEntityPropertyMeta(classElement, fieldElement, entityMeta);
                }
                catch (AptException e) {
                    Notifier.notify(this.env, e);
                    entityMeta.setError(true);
                }
            }
        }

        protected List<VariableElement> getFieldElements(TypeElement classElement) {
            LinkedList<VariableElement> results = new LinkedList<VariableElement>();
            TypeElement t = classElement;
            while (t != null && t.asType().getKind() != TypeKind.NONE) {
                if (t.getAnnotation(Entity.class) != null) {
                    LinkedList<VariableElement> fields = new LinkedList<VariableElement>();
                    for (VariableElement field : ElementFilter.fieldsIn(t.getEnclosedElements())) {
                        fields.add(field);
                    }
                    Collections.reverse(fields);
                    results.addAll(fields);
                }
                t = TypeMirrorUtil.toTypeElement(t.getSuperclass(), this.env);
            }
            Collections.reverse(results);
            LinkedList hiderFields = new LinkedList(results);
            Iterator it = results.iterator();
            while (it.hasNext()) {
                VariableElement hidden = (VariableElement)it.next();
                for (VariableElement hider : hiderFields) {
                    if (!this.env.getElementUtils().hides(hider, hidden)) continue;
                    it.remove();
                }
            }
            return results;
        }

        protected void doOriginalStatesField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
            if (entityMeta.hasOriginalStatesMeta()) {
                throw new AptException((MessageResource)Message.DOMA4125, this.env, fieldElement, new Object[]{classElement.getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (classElement.equals(fieldElement.getEnclosingElement()) && !TypeMirrorUtil.isSameType(fieldElement.asType(), classElement.asType(), this.env)) {
                throw new AptException((MessageResource)Message.DOMA4135, this.env, fieldElement, new Object[]{classElement.getQualifiedName()});
            }
            TypeElement enclosingElement = ElementUtil.toTypeElement(fieldElement.getEnclosingElement(), this.env);
            if (enclosingElement == null) {
                throw new AptIllegalStateException(fieldElement.toString());
            }
            if (entityMeta.isImmutable() && classElement.equals(enclosingElement)) {
                throw new AptException((MessageResource)Message.DOMA4224, this.env, fieldElement, new Object[]{classElement.getQualifiedName(), fieldElement.getSimpleName()});
            }
            OriginalStatesMeta originalStatesMeta = new OriginalStatesMeta(classElement, fieldElement, enclosingElement, this.env);
            entityMeta.setOriginalStatesMeta(originalStatesMeta);
        }

        protected void doEntityPropertyMeta(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
            this.validateFieldAnnotation(fieldElement, entityMeta);
            EntityPropertyMeta propertyMeta = this.propertyMetaFactory.createEntityPropertyMeta(fieldElement, entityMeta);
            entityMeta.addPropertyMeta(propertyMeta);
            this.validateField(classElement, fieldElement, entityMeta);
        }

        protected void validateFieldAnnotation(VariableElement fieldElement, EntityMeta entityMeta) {
            TypeElement foundAnnotationTypeElement = null;
            for (AnnotationMirror annotationMirror : fieldElement.getAnnotationMirrors()) {
                DeclaredType declaredType = annotationMirror.getAnnotationType();
                TypeElement typeElement = TypeMirrorUtil.toTypeElement(declaredType, this.env);
                if (typeElement.getAnnotation(EntityField.class) == null) continue;
                if (foundAnnotationTypeElement != null) {
                    throw new AptException((MessageResource)Message.DOMA4086, this.env, fieldElement, new Object[]{foundAnnotationTypeElement.getQualifiedName(), typeElement.getQualifiedName(), entityMeta.getEntityElement().getQualifiedName(), fieldElement.getSimpleName()});
                }
                foundAnnotationTypeElement = typeElement;
            }
        }

        protected void validateField(TypeElement classElement, VariableElement fieldElement, EntityMeta entityMeta) {
            if (entityMeta.isImmutable() && !fieldElement.getModifiers().contains((Object)Modifier.FINAL)) {
                throw new AptException((MessageResource)Message.DOMA4225, this.env, fieldElement, new Object[]{classElement.getQualifiedName(), fieldElement.getSimpleName()});
            }
        }

        @Override
        public void validateGeneratedId(TypeElement classElement, EntityMeta entityMeta) {
            if (entityMeta.hasGeneratedIdPropertyMeta() && entityMeta.getIdPropertyMetas().size() > 1) {
                throw new AptException((MessageResource)Message.DOMA4036, this.env, classElement, new Object[]{classElement.getQualifiedName()});
            }
        }

        @Override
        public void validateOriginalStates(TypeElement classElement, EntityMeta entityMeta) {
            if (entityMeta.hasOriginalStatesMeta() && entityMeta.hasEmbeddedProperties()) {
                throw new AptException((MessageResource)Message.DOMA4305, this.env, classElement, new Object[]{classElement.getQualifiedName()});
            }
        }

        @Override
        public void doConstructor(TypeElement classElement, EntityMeta entityMeta) {
            if (classElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                return;
            }
            if (entityMeta.isImmutable()) {
                EntityConstructorMeta constructorMeta = this.getConstructorMeta(classElement, entityMeta);
                if (constructorMeta == null) {
                    throw new AptException((MessageResource)Message.DOMA4281, this.env, classElement, new Object[]{classElement.getQualifiedName()});
                }
                if (constructorMeta.getConstructorElement().getModifiers().contains((Object)Modifier.PRIVATE)) {
                    throw new AptException((MessageResource)Message.DOMA4221, this.env, classElement, new Object[]{classElement.getQualifiedName()});
                }
                entityMeta.setConstructorMeta(constructorMeta);
            } else {
                ExecutableElement constructor = ElementUtil.getNoArgConstructor(classElement, this.env);
                if (constructor == null || constructor.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    throw new AptException((MessageResource)Message.DOMA4124, this.env, classElement, new Object[]{classElement.getQualifiedName()});
                }
            }
        }

        protected EntityConstructorMeta getConstructorMeta(TypeElement classElement, EntityMeta entityMeta) {
            HashMap<String, EntityPropertyMeta> entityPropertyMetaMap = new HashMap<String, EntityPropertyMeta>();
            for (EntityPropertyMeta propertyMeta : entityMeta.getAllPropertyMetas()) {
                entityPropertyMetaMap.put(propertyMeta.getName(), propertyMeta);
            }
            block1: for (ExecutableElement constructor : ElementFilter.constructorsIn(classElement.getEnclosedElements())) {
                ArrayList<EntityPropertyMeta> entityPropertyMetaList = new ArrayList<EntityPropertyMeta>();
                for (VariableElement variableElement : constructor.getParameters()) {
                    TypeMirror propertyType;
                    String name = variableElement.getSimpleName().toString();
                    ParameterName parameterName = variableElement.getAnnotation(ParameterName.class);
                    if (parameterName != null) {
                        name = parameterName.value();
                    }
                    TypeMirror paramType = variableElement.asType();
                    EntityPropertyMeta propertyMeta = (EntityPropertyMeta)entityPropertyMetaMap.get(name);
                    if (propertyMeta == null || !TypeMirrorUtil.isSameType(paramType, propertyType = propertyMeta.getType(), this.env)) continue block1;
                    entityPropertyMetaList.add(propertyMeta);
                }
                if (entityPropertyMetaMap.size() != entityPropertyMetaList.size()) continue;
                return new EntityConstructorMeta(constructor, entityPropertyMetaList);
            }
            return null;
        }
    }

    protected static interface Strategy {
        public void doClassElement(TypeElement var1, EntityMeta var2);

        public void doFieldElements(TypeElement var1, EntityMeta var2);

        public void validateGeneratedId(TypeElement var1, EntityMeta var2);

        public void validateOriginalStates(TypeElement var1, EntityMeta var2);

        public void doConstructor(TypeElement var1, EntityMeta var2);
    }
}

