/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.meta.EntityConstructorMeta;
import org.seasar.doma.internal.apt.meta.EntityPropertyMeta;
import org.seasar.doma.internal.apt.meta.OriginalStatesMeta;
import org.seasar.doma.internal.apt.meta.TypeElementMeta;
import org.seasar.doma.internal.apt.mirror.EntityMirror;
import org.seasar.doma.internal.apt.mirror.TableMirror;
import org.seasar.doma.internal.util.AssertionUtil;
import org.seasar.doma.jdbc.entity.NamingType;

public class EntityMeta
implements TypeElementMeta {
    protected final List<EntityPropertyMeta> allPropertyMetas = new ArrayList<EntityPropertyMeta>();
    protected final Map<String, EntityPropertyMeta> allPropertyMetaMap = new HashMap<String, EntityPropertyMeta>();
    protected final List<EntityPropertyMeta> idPropertyMetas = new ArrayList<EntityPropertyMeta>();
    protected final EntityMirror entityMirror;
    protected final TypeElement entityElement;
    protected boolean immutable;
    protected NamingType namingType;
    protected TypeMirror entityListener;
    protected TypeElement entityListenerElement;
    protected boolean genericEntityListener;
    protected TableMirror tableMirror;
    protected EntityPropertyMeta versionPropertyMeta;
    protected EntityPropertyMeta tenantIdPropertyMeta;
    protected EntityPropertyMeta generatedIdPropertyMeta;
    protected String entityName;
    protected String entityTypeName;
    protected OriginalStatesMeta originalStatesMeta;
    protected EntityConstructorMeta constructorMeta;
    protected boolean error;

    public EntityMeta(EntityMirror entityMirror, TypeElement entityElement) {
        AssertionUtil.assertNotNull(entityMirror);
        this.entityMirror = entityMirror;
        this.entityElement = entityElement;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    EntityMirror getEntityMirror() {
        return this.entityMirror;
    }

    public NamingType getNamingType() {
        return this.namingType;
    }

    public void setNamingType(NamingType namingType) {
        this.namingType = namingType;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    public TypeElement getEntityElement() {
        return this.entityElement;
    }

    public void setTableMirror(TableMirror tableMirror) {
        this.tableMirror = tableMirror;
    }

    public void addPropertyMeta(EntityPropertyMeta propertyMeta) {
        AssertionUtil.assertNotNull(propertyMeta);
        this.allPropertyMetas.add(propertyMeta);
        this.allPropertyMetaMap.put(propertyMeta.getName(), propertyMeta);
        if (propertyMeta.isId()) {
            this.idPropertyMetas.add(propertyMeta);
            if (propertyMeta.getIdGeneratorMeta() != null) {
                this.generatedIdPropertyMeta = propertyMeta;
            }
        }
        if (propertyMeta.isVersion()) {
            this.versionPropertyMeta = propertyMeta;
        }
        if (propertyMeta.isTenantId()) {
            this.tenantIdPropertyMeta = propertyMeta;
        }
    }

    public List<EntityPropertyMeta> getAllPropertyMetas() {
        if (this.constructorMeta == null) {
            return this.allPropertyMetas;
        }
        return this.constructorMeta.getEntityPropertyMetas();
    }

    public List<EntityPropertyMeta> getIdPropertyMetas() {
        return this.idPropertyMetas;
    }

    public boolean hasVersionPropertyMeta() {
        return this.versionPropertyMeta != null;
    }

    public EntityPropertyMeta getVersionPropertyMeta() {
        return this.versionPropertyMeta;
    }

    public boolean hasTenantIdPropertyMeta() {
        return this.tenantIdPropertyMeta != null;
    }

    public EntityPropertyMeta getTenanatIdPropertyMeta() {
        return this.tenantIdPropertyMeta;
    }

    public boolean hasGeneratedIdPropertyMeta() {
        return this.generatedIdPropertyMeta != null;
    }

    public EntityPropertyMeta getGeneratedIdPropertyMeta() {
        return this.generatedIdPropertyMeta;
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public void setEntityTypeName(String entityTypeName) {
        this.entityTypeName = entityTypeName;
    }

    public boolean hasOriginalStatesMeta() {
        return this.originalStatesMeta != null;
    }

    public OriginalStatesMeta getOriginalStatesMeta() {
        return this.originalStatesMeta;
    }

    public void setOriginalStatesMeta(OriginalStatesMeta originalStatesMeta) {
        this.originalStatesMeta = originalStatesMeta;
    }

    public EntityConstructorMeta getConstructorMeta() {
        return this.constructorMeta;
    }

    public void setConstructorMeta(EntityConstructorMeta constructorMeta) {
        this.constructorMeta = constructorMeta;
    }

    public TypeMirror getEntityListener() {
        return this.entityListener;
    }

    public void setEntityListener(TypeMirror entityListener) {
        this.entityListener = entityListener;
    }

    public TypeElement getEntityListenerElement() {
        return this.entityListenerElement;
    }

    public void setEntityListenerElement(TypeElement entityListenerElement) {
        this.entityListenerElement = entityListenerElement;
    }

    public boolean isGenericEntityListener() {
        return this.genericEntityListener;
    }

    public void setGenericEntityListener(boolean genericEntityListener) {
        this.genericEntityListener = genericEntityListener;
    }

    public String getCatalogName() {
        return this.tableMirror != null ? this.tableMirror.getCatalogValue() : "";
    }

    public String getSchemaName() {
        return this.tableMirror != null ? this.tableMirror.getSchemaValue() : "";
    }

    public String getTableName() {
        return this.tableMirror != null ? this.tableMirror.getNameValue() : "";
    }

    public boolean isQuoteRequired() {
        return this.tableMirror != null ? this.tableMirror.getQuoteValue() : false;
    }

    public boolean isAbstract() {
        return this.entityElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public boolean hasEmbeddedProperties() {
        return this.allPropertyMetas.stream().anyMatch(EntityPropertyMeta::isEmbedded);
    }

    @Override
    public boolean isError() {
        return this.error;
    }

    public void setError(boolean error) {
        this.error = error;
    }
}

