/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.doma.internal.apt.meta;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.seasar.doma.internal.apt.AptException;
import org.seasar.doma.internal.apt.cttype.BasicCtType;
import org.seasar.doma.internal.apt.cttype.CtType;
import org.seasar.doma.internal.apt.cttype.DomainCtType;
import org.seasar.doma.internal.apt.cttype.EmbeddableCtType;
import org.seasar.doma.internal.apt.cttype.OptionalCtType;
import org.seasar.doma.internal.apt.cttype.OptionalDoubleCtType;
import org.seasar.doma.internal.apt.cttype.OptionalIntCtType;
import org.seasar.doma.internal.apt.cttype.OptionalLongCtType;
import org.seasar.doma.internal.apt.meta.EmbeddableMeta;
import org.seasar.doma.internal.apt.meta.EmbeddablePropertyMeta;
import org.seasar.doma.internal.apt.mirror.ColumnMirror;
import org.seasar.doma.message.Message;
import org.seasar.doma.message.MessageResource;

public class EmbeddablePropertyMetaFactory {
    protected final ProcessingEnvironment env;

    public EmbeddablePropertyMetaFactory(ProcessingEnvironment env) {
        this.env = env;
    }

    public EmbeddablePropertyMeta createEmbeddablePropertyMeta(VariableElement fieldElement, EmbeddableMeta embeddableMeta) {
        EmbeddablePropertyMeta embeddablePropertyMeta = new EmbeddablePropertyMeta(fieldElement, this.env);
        embeddablePropertyMeta.setName(fieldElement.getSimpleName().toString());
        CtType ctType = this.resolveCtType(fieldElement, fieldElement.asType(), embeddableMeta);
        embeddablePropertyMeta.setCtType(ctType);
        ColumnMirror columnMirror = ColumnMirror.newInstance(fieldElement, this.env);
        if (columnMirror != null) {
            embeddablePropertyMeta.setColumnMirror(columnMirror);
        }
        return embeddablePropertyMeta;
    }

    protected CtType resolveCtType(VariableElement fieldElement, TypeMirror type, EmbeddableMeta embeddableMeta) {
        OptionalCtType optionalCtType = OptionalCtType.newInstance(type, this.env);
        if (optionalCtType != null) {
            if (optionalCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4299, this.env, fieldElement, new Object[]{optionalCtType.getQualifiedName(), embeddableMeta.getEmbeddableElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (optionalCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4301, this.env, fieldElement, new Object[]{optionalCtType.getQualifiedName(), embeddableMeta.getEmbeddableElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            return optionalCtType;
        }
        OptionalIntCtType optionalIntCtType = OptionalIntCtType.newInstance(type, this.env);
        if (optionalIntCtType != null) {
            return optionalIntCtType;
        }
        OptionalLongCtType optionalLongCtType = OptionalLongCtType.newInstance(type, this.env);
        if (optionalLongCtType != null) {
            return optionalLongCtType;
        }
        OptionalDoubleCtType optionalDoubleCtType = OptionalDoubleCtType.newInstance(type, this.env);
        if (optionalDoubleCtType != null) {
            return optionalDoubleCtType;
        }
        DomainCtType domainCtType = DomainCtType.newInstance(type, this.env);
        if (domainCtType != null) {
            if (domainCtType.isRawType()) {
                throw new AptException((MessageResource)Message.DOMA4295, this.env, fieldElement, new Object[]{domainCtType.getQualifiedName(), embeddableMeta.getEmbeddableElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            if (domainCtType.isWildcardType()) {
                throw new AptException((MessageResource)Message.DOMA4296, this.env, fieldElement, new Object[]{domainCtType.getQualifiedName(), embeddableMeta.getEmbeddableElement().getQualifiedName(), fieldElement.getSimpleName()});
            }
            return domainCtType;
        }
        BasicCtType basicCtType = BasicCtType.newInstance(type, this.env);
        if (basicCtType != null) {
            return basicCtType;
        }
        EmbeddableCtType embeddableCtType = EmbeddableCtType.newInstance(type, this.env);
        if (embeddableCtType != null) {
            throw new AptException((MessageResource)Message.DOMA4297, this.env, fieldElement, new Object[]{type, embeddableMeta.getEmbeddableElement().getQualifiedName(), fieldElement.getSimpleName()});
        }
        throw new AptException((MessageResource)Message.DOMA4298, this.env, fieldElement, new Object[]{type, embeddableMeta.getEmbeddableElement().getQualifiedName(), fieldElement.getSimpleName()});
    }
}

